/*     */ package org.jboss.remoting.samples.stream;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.stream.StreamInvocationHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class StreamingServer
/*     */ {
/*  45 */   private static String transport = "socket";
/*  46 */   private static String host = "localhost";
/*  47 */   private static int port = 5400;
/*     */   private String locatorURI;
/*     */   private Connector connector;
/*     */ 
/*     */   public StreamingServer()
/*     */   {
/*  49 */     this.locatorURI = (transport + "://" + host + ":" + port);
/*  50 */     this.connector = null;
/*     */   }
/*     */ 
/*     */   public void setupServer() throws Exception {
/*  54 */     InvokerLocator locator = new InvokerLocator(this.locatorURI);
/*  55 */     System.out.println("Starting remoting server with locator uri of: " + this.locatorURI);
/*  56 */     this.connector = new Connector();
/*  57 */     this.connector.setInvokerLocator(locator.getLocatorURI());
/*  58 */     this.connector.create();
/*     */ 
/*  60 */     TestStreamInvocationHandler invocationHandler = new TestStreamInvocationHandler();
/*     */ 
/*  62 */     this.connector.addInvocationHandler("test_stream", invocationHandler);
/*     */ 
/*  64 */     this.connector.start(true);
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  76 */     if ((args != null) && (args.length == 3))
/*     */     {
/*  78 */       transport = args[0];
/*  79 */       host = args[1];
/*  80 */       port = Integer.parseInt(args[2]);
/*     */     }
/*     */ 
/*  83 */     StreamingServer server = new StreamingServer();
/*     */     try
/*     */     {
/*  86 */       server.setupServer();
/*     */       while (true)
/*     */       {
/*  91 */         Thread.sleep(1000L);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  97 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class TestStreamInvocationHandler
/*     */     implements StreamInvocationHandler
/*     */   {
/* 106 */     private long streamSize = 0L;
/*     */ 
/*     */     public Object handleStream(InputStream stream, InvocationRequest param)
/*     */     {
/*     */       try
/*     */       {
/* 120 */         String fileName = (String)param.getParameter();
/* 121 */         System.out.println("Received input stream from client to write out to file " + fileName);
/* 122 */         File newFile = new File(fileName);
/* 123 */         if (!newFile.exists())
/*     */         {
/* 125 */           newFile.createNewFile();
/*     */         }
/*     */ 
/* 128 */         FileOutputStream out = new FileOutputStream(newFile, false);
/*     */ 
/* 130 */         byte[] buf = new byte[4096];
/*     */         while (true)
/*     */         {
/* 133 */           int c = stream.read(buf);
/* 134 */           if (c < 0)
/*     */           {
/*     */             break;
/*     */           }
/* 138 */           out.write(buf, 0, c);
/*     */         }
/*     */ 
/* 141 */         out.flush();
/* 142 */         out.close();
/*     */ 
/* 144 */         this.streamSize = newFile.length();
/* 145 */         System.out.println("New file " + fileName + " has been written out to " + newFile.getAbsolutePath());
/* 146 */         System.out.println("Size of " + newFile.getAbsolutePath() + " is " + this.streamSize);
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 150 */         e.printStackTrace();
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 156 */           stream.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 160 */           e.printStackTrace();
/*     */         }
/*     */       }
/* 163 */       return new Long(this.streamSize);
/*     */     }
/*     */ 
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 176 */       System.out.println("Invocation request is: " + invocation.getParameter());
/*     */ 
/* 179 */       return new Long(this.streamSize);
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.stream.StreamingServer
 * JD-Core Version:    0.6.0
 */