/*     */ package org.jboss.remoting.samples.serialization;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class SerializationServer
/*     */ {
/*  47 */   private static String transport = "socket";
/*  48 */   private static String host = "localhost";
/*  49 */   private static int port = 5400;
/*     */ 
/*  52 */   private static final NonSerializablePayload RESPONSE_VALUE = new NonSerializablePayload("bar", 2);
/*     */ 
/*     */   public void setupServer(String locatorURI)
/*     */     throws Exception
/*     */   {
/*  60 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  61 */     System.out.println("Starting remoting server with locator uri of: " + locatorURI);
/*  62 */     Connector connector = new Connector(locator);
/*     */ 
/*  64 */     connector.create();
/*     */ 
/*  67 */     SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
/*     */ 
/*  69 */     connector.addInvocationHandler("sample", invocationHandler);
/*     */ 
/*  73 */     connector.start();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  85 */     if ((args != null) && (args.length == 3))
/*     */     {
/*  87 */       transport = args[0];
/*  88 */       host = args[1];
/*  89 */       port = Integer.parseInt(args[2]);
/*     */     }
/*     */ 
/*  93 */     String locatorURI = transport + "://" + host + ":" + port + "/?serializationtype=jboss";
/*  94 */     SerializationServer server = new SerializationServer();
/*     */     try
/*     */     {
/*  97 */       server.setupServer(locatorURI);
/*     */       while (true)
/*     */       {
/* 102 */         Thread.sleep(1000L);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 108 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler
/*     */   {
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 128 */       System.out.println("Invocation request is: " + invocation.getParameter());
/* 129 */       System.out.println("Returning response of: " + SerializationServer.RESPONSE_VALUE);
/*     */ 
/* 131 */       return SerializationServer.RESPONSE_VALUE;
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.serialization.SerializationServer
 * JD-Core Version:    0.6.0
 */