/*     */ package org.jboss.remoting.samples.multiplex.invoker;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class Client3Server1
/*     */ {
/*     */   private Client client;
/*     */   private SampleCallbackHandler handler;
/*     */   private Connector connector;
/*     */   private InvokerLocator locator;
/*     */ 
/*     */   public void init()
/*     */   {
/*     */     try
/*     */     {
/*  64 */       String locatorURI = "multiplex://localhost:9090";
/*  65 */       InvokerLocator locator = new InvokerLocator(locatorURI);
/*  66 */       Map configuration = new HashMap();
/*  67 */       configuration.put("clientMultiplexId", "client3server1");
/*  68 */       this.client = new Client(locator, "sample", configuration);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  72 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private InvokerLocator initServer()
/*     */     throws Exception
/*     */   {
/*  86 */     String locatorURI = "multiplex://localhost:8080";
/*  87 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  88 */     Map configuration = new HashMap();
/*  89 */     configuration.put("serverMultiplexId", "client3server1");
/*  90 */     this.connector = new Connector(locator.getLocatorURI(), configuration);
/*  91 */     this.connector.create();
/*  92 */     this.connector.start();
/*  93 */     System.out.println("Started callback server at:    " + this.connector.getInvokerLocator());
/*  94 */     return this.connector.getLocator();
/*     */   }
/*     */ 
/*     */   public void setUp()
/*     */     throws Exception
/*     */   {
/* 100 */     init();
/* 101 */     this.locator = initServer();
/* 102 */     this.client.connect();
/* 103 */     System.out.println("Connected client to server at: " + this.client.getInvoker().getLocator().getLocatorURI());
/*     */   }
/*     */ 
/*     */   public void tearDown() throws Throwable
/*     */   {
/* 108 */     while (!this.handler.gotCallbacks) {
/* 109 */       Thread.sleep(1000L);
/*     */     }
/* 111 */     this.client.removeListener(this.handler);
/*     */ 
/* 113 */     if (this.connector != null)
/*     */     {
/* 115 */       this.connector.stop();
/* 116 */       this.connector.destroy();
/* 117 */       this.connector = null;
/*     */     }
/* 119 */     this.locator = null;
/* 120 */     if (this.client != null)
/*     */     {
/* 122 */       this.client.disconnect();
/* 123 */       this.client = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void makeClientCall()
/*     */     throws Throwable
/*     */   {
/* 130 */     this.handler = new SampleCallbackHandler();
/*     */ 
/* 133 */     this.client.addListener(this.handler, this.locator, this.client.getSessionId());
/*     */ 
/* 136 */     Object answer = this.client.invoke(new Integer(17));
/*     */ 
/* 138 */     System.out.println("invocation returns: " + ((Integer)answer).intValue());
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 144 */     Client3Server1 test = new Client3Server1();
/*     */     try
/*     */     {
/* 148 */       test.setUp();
/* 149 */       test.makeClientCall();
/* 150 */       test.tearDown();
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 154 */       throwable.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleCallbackHandler implements InvokerCallbackHandler
/*     */   {
/*     */     int callbackCounter;
/*     */     boolean gotCallbacks;
/*     */ 
/*     */     public void handleCallback(Callback callback) throws HandleCallbackException {
/* 166 */       Object ret = callback.getCallbackObject();
/* 167 */       System.out.println("callback value: " + ret);
/*     */ 
/* 169 */       if (++this.callbackCounter == 2)
/* 170 */         this.gotCallbacks = true;
/*     */     }
/*     */ 
/*     */     public boolean gotCallbacks()
/*     */     {
/* 175 */       return this.gotCallbacks;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.invoker.Client3Server1
 * JD-Core Version:    0.6.0
 */