/*     */ package org.jboss.remoting.samples.multiplex;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import org.jboss.remoting.transport.multiplex.MasterServerSocket;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualSocket;
/*     */ 
/*     */ public class SymmetricScenarioServer
/*     */ {
/*  51 */   static int bindPort = 6666;
/*  52 */   static String connectHost = "localhost";
/*  53 */   static int connectPort = 5555;
/*     */ 
/*     */   public void runSymmetricScenario()
/*     */   {
/*     */     try
/*     */     {
/*  61 */       ServerSocket ss = new ServerSocket(bindPort);
/*  62 */       Socket syncSocket = ss.accept();
/*  63 */       ss.close();
/*  64 */       InputStream is_sync = syncSocket.getInputStream();
/*  65 */       OutputStream os_sync = syncSocket.getOutputStream();
/*     */ 
/*  70 */       MasterServerSocket mss = new MasterServerSocket(bindPort + 1);
/*  71 */       os_sync.write(3);
/*  72 */       mss.setSoTimeout(5000);
/*  73 */       int port = mss.acceptServerSocketConnection();
/*  74 */       mss.close();
/*     */ 
/*  80 */       is_sync.read();
/*  81 */       VirtualServerSocket vss = new VirtualServerSocket(port);
/*  82 */       InetSocketAddress address = new InetSocketAddress(connectHost, connectPort);
/*  83 */       vss.setSoTimeout(5000);
/*  84 */       vss.connect(address);
/*     */ 
/*  87 */       os_sync.write(7);
/*     */ 
/*  90 */       Socket virtualSocket1 = vss.accept();
/*  91 */       InputStream is1 = virtualSocket1.getInputStream();
/*  92 */       OutputStream os1 = virtualSocket1.getOutputStream();
/*     */ 
/*  95 */       Socket virtualSocket2 = new VirtualSocket(connectHost, connectPort);
/*  96 */       InputStream is2 = virtualSocket2.getInputStream();
/*  97 */       OutputStream os2 = virtualSocket2.getOutputStream();
/*     */ 
/* 100 */       os1.write(is1.read());
/* 101 */       os2.write(is2.read());
/* 102 */       virtualSocket1.close();
/* 103 */       virtualSocket2.close();
/* 104 */       syncSocket.close();
/* 105 */       vss.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 109 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 116 */     if (args.length == 3)
/*     */     {
/* 118 */       bindPort = Integer.parseInt(args[0]);
/* 119 */       connectHost = args[1];
/* 120 */       connectPort = Integer.parseInt(args[2]);
/*     */     }
/*     */ 
/* 123 */     new SymmetricScenarioServer().runSymmetricScenario();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.SymmetricScenarioServer
 * JD-Core Version:    0.6.0
 */