/*     */ package org.jboss.remoting.samples.multiplex;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
/*     */ 
/*     */ public class N_SocketScenarioClient
/*     */ {
/*  49 */   static int bindPort = 5555;
/*  50 */   static String connectHost = "localhost";
/*  51 */   static int connectPort = 6666;
/*     */ 
/*     */   public void runN_SocketScenario()
/*     */   {
/*     */     try
/*     */     {
/*  58 */       VirtualServerSocket serverSocket = new VirtualServerSocket(bindPort);
/*  59 */       InetSocketAddress connectAddress = new InetSocketAddress(connectHost, connectPort);
/*  60 */       serverSocket.setSoTimeout(10000);
/*  61 */       serverSocket.connect(connectAddress);
/*     */ 
/*  64 */       Socket socket1 = serverSocket.accept();
/*  65 */       Socket socket2 = serverSocket.accept();
/*  66 */       Socket socket3 = serverSocket.accept();
/*     */ 
/*  69 */       InputStream is1 = socket1.getInputStream();
/*  70 */       OutputStream os1 = socket1.getOutputStream();
/*  71 */       InputStream is2 = socket2.getInputStream();
/*  72 */       OutputStream os2 = socket2.getOutputStream();
/*  73 */       InputStream is3 = socket3.getInputStream();
/*  74 */       OutputStream os3 = socket3.getOutputStream();
/*  75 */       os1.write(3);
/*  76 */       os2.write(7);
/*  77 */       os3.write(11);
/*  78 */       System.out.println(is1.read());
/*  79 */       System.out.println(is2.read());
/*  80 */       System.out.println(is3.read());
/*     */ 
/*  82 */       socket1.close();
/*  83 */       socket2.close();
/*  84 */       socket3.close();
/*  85 */       serverSocket.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  89 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  95 */     if (args.length == 3)
/*     */     {
/*  97 */       bindPort = Integer.parseInt(args[0]);
/*  98 */       connectHost = args[1];
/*  99 */       connectPort = Integer.parseInt(args[2]);
/*     */     }
/*     */ 
/* 102 */     new N_SocketScenarioClient().runN_SocketScenario();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.N_SocketScenarioClient
 * JD-Core Version:    0.6.0
 */