/*     */ package org.jboss.remoting.samples.multiplex;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.SocketFactory;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualServerSocketFactory;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualSocketFactory;
/*     */ 
/*     */ public class FactoryExample
/*     */ {
/*     */   void runFactoryExample()
/*     */   {
/*  54 */     ServerSocketFactory serverSocketFactory = VirtualServerSocketFactory.getDefault();
/*  55 */     ((VirtualServerSocketFactory)serverSocketFactory).setOnServer();
/*  56 */     SocketFactory socketFactory = VirtualSocketFactory.getDefault();
/*  57 */     useServerSocketFactory(serverSocketFactory);
/*  58 */     useSocketFactory(socketFactory);
/*     */   }
/*     */ 
/*     */   void useServerSocketFactory(ServerSocketFactory serverSocketFactory)
/*     */   {
/*  63 */     new Thread(serverSocketFactory) {
/*     */       private final ServerSocketFactory val$serverSocketFactory;
/*     */ 
/*     */       public void run() {
/*     */         try {
/*  69 */           ServerSocket serverSocket = this.val$serverSocketFactory.createServerSocket(5555);
/*  70 */           Socket socket = serverSocket.accept();
/*  71 */           int b = socket.getInputStream().read();
/*  72 */           socket.getOutputStream().write(b);
/*  73 */           socket.close();
/*  74 */           serverSocket.close();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*  78 */           e.printStackTrace();
/*     */         }
/*     */       }
/*     */     }
/*  63 */     .start();
/*     */   }
/*     */ 
/*     */   public void useSocketFactory(SocketFactory socketFactory)
/*     */   {
/*     */     try
/*     */     {
/*  88 */       Thread.sleep(1000L);
/*  89 */       Socket socket = socketFactory.createSocket("localhost", 5555);
/*  90 */       socket.getOutputStream().write(7);
/*  91 */       System.out.println(socket.getInputStream().read());
/*  92 */       socket.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  96 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 103 */     new FactoryExample().runFactoryExample();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.FactoryExample
 * JD-Core Version:    0.6.0
 */