/*    */ package org.jboss.remoting.samples.http;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import java.util.Map;
/*    */ import javax.management.MBeanServer;
/*    */ import org.jboss.remoting.InvocationRequest;
/*    */ import org.jboss.remoting.ServerInvocationHandler;
/*    */ import org.jboss.remoting.ServerInvoker;
/*    */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*    */ 
/*    */ public class WebInvocationHandler
/*    */   implements ServerInvocationHandler
/*    */ {
/*    */   public static final String RESPONSE_VALUE = "This is the return to simple text based http invocation.";
/* 43 */   public static final ComplexObject OBJECT_RESPONSE_VALUE = new ComplexObject(5, "dub", false);
/*    */   public static final String HTML_PAGE_RESPONSE = "<html><head><title>Test HTML page</title></head><body><h1>HTTP/Servlet Test HTML page</h1><p>This is a simple page served for test.<p>Should show up in browser or via invoker client</body></html>";
/*    */   public static final String NULL_RETURN_PARAM = "return_null";
/*    */   public static final String OBJECT_RETURN_PARAM = "return_object";
/*    */   public static final String STRING_RETURN_PARAM = "return_string";
/*    */ 
/*    */   public Object invoke(InvocationRequest invocation)
/*    */     throws Throwable
/*    */   {
/* 64 */     System.out.println("Invocation request from client is: " + invocation.getParameter());
/* 65 */     if ("return_null".equals(invocation.getParameter()))
/*    */     {
/* 67 */       return null;
/*    */     }
/* 69 */     if ((invocation.getParameter() instanceof ComplexObject))
/*    */     {
/* 71 */       return OBJECT_RESPONSE_VALUE;
/*    */     }
/* 73 */     if ("return_string".equals(invocation.getParameter()))
/*    */     {
/* 75 */       Map responseMetadata = invocation.getReturnPayload();
/* 76 */       responseMetadata.put("ResponseCode", new Integer(207));
/* 77 */       responseMetadata.put("ResponseCodeMessage", "Custom response code and message from remoting server");
/*    */ 
/* 79 */       return "This is the return to simple text based http invocation.";
/*    */     }
/*    */ 
/* 83 */     return "<html><head><title>Test HTML page</title></head><body><h1>HTTP/Servlet Test HTML page</h1><p>This is a simple page served for test.<p>Should show up in browser or via invoker client</body></html>";
/*    */   }
/*    */ 
/*    */   public void addListener(InvokerCallbackHandler callbackHandler)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void removeListener(InvokerCallbackHandler callbackHandler)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void setMBeanServer(MBeanServer server)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void setInvoker(ServerInvoker invoker)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.http.WebInvocationHandler
 * JD-Core Version:    0.6.0
 */