/*     */ package org.jboss.remoting.samples.http;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class SimpleClient
/*     */ {
/*  40 */   private static String transport = "http";
/*  41 */   private static String host = "localhost";
/*  42 */   private static int port = 5400;
/*     */ 
/*     */   public void makeInvocation(String locatorURI)
/*     */     throws Throwable
/*     */   {
/*  48 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  49 */     System.out.println("Calling remoting server with locator uri of: " + locatorURI);
/*     */ 
/*  51 */     Client remotingClient = new Client(locator);
/*  52 */     remotingClient.connect();
/*     */ 
/*  58 */     Object response = remotingClient.invoke(new ComplexObject(2, "foo", true), null);
/*     */ 
/*  60 */     System.out.println("\nResponse from remoting http server when making http POST request and sending a complex data object:\n" + response);
/*     */ 
/*  63 */     Map metadata = new HashMap();
/*     */ 
/*  65 */     metadata.put("TYPE", "GET");
/*     */ 
/*  67 */     response = remotingClient.invoke((Object)null, metadata);
/*     */ 
/*  69 */     System.out.println("\nResponse from remoting http server when making GET request:\n" + response);
/*     */ 
/*  72 */     metadata.put("TYPE", "POST");
/*  73 */     response = remotingClient.invoke("return_string", metadata);
/*     */ 
/*  75 */     System.out.println("\nResponse from remoting http server when making http POST request and sending a text based request:\n" + response);
/*     */ 
/*  78 */     Integer responseCode = (Integer)metadata.get("ResponseCode");
/*  79 */     String responseMessage = (String)metadata.get("ResponseCodeMessage");
/*  80 */     System.out.println("Response code from server: " + responseCode);
/*  81 */     System.out.println("Response message from server: " + responseMessage);
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  94 */     if ((args != null) && (args.length == 3))
/*     */     {
/*  96 */       transport = args[0];
/*  97 */       host = args[1];
/*  98 */       port = Integer.parseInt(args[2]);
/*     */     }
/* 100 */     String locatorURI = transport + "://" + host + ":" + port;
/* 101 */     SimpleClient client = new SimpleClient();
/*     */     try
/*     */     {
/* 104 */       client.makeInvocation(locatorURI);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 108 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.http.SimpleClient
 * JD-Core Version:    0.6.0
 */