/*     */ package org.jboss.remoting.samples.config.factories;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.HashMap;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import junit.framework.TestCase;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ import org.jboss.remoting.transport.PortUtil;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class FactoryConfigSample extends TestCase
/*     */ {
/*  76 */   protected static Logger log = Logger.getLogger(FactoryConfigSample.class);
/*     */ 
/*     */   public void testFactoriesBySettingInvokers()
/*     */   {
/*     */     try
/*     */     {
/*  97 */       HashMap sconfig = new HashMap();
/*     */ 
/* 100 */       sconfig.put("force_remote", "true");
/*     */ 
/* 103 */       int freeport = PortUtil.findFreePort(getHostName());
/* 104 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 105 */       Connector connector = new Connector(locator, sconfig);
/* 106 */       connector.create();
/*     */ 
/* 109 */       ServerInvoker serverInvoker = connector.getServerInvoker();
/* 110 */       ServerSocketFactory ssf1 = getDefaultServerSocketFactory();
/* 111 */       serverInvoker.setServerSocketFactory(ssf1);
/* 112 */       SocketFactory sf1 = getDefaultCallbackSocketFactory();
/* 113 */       serverInvoker.setSocketFactory(sf1);
/*     */ 
/* 115 */       connector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 116 */       connector.start();
/*     */ 
/* 122 */       HashMap cconfig = new HashMap();
/*     */ 
/* 125 */       cconfig.put("force_remote", "true");
/*     */ 
/* 128 */       Client client = new Client(locator, cconfig);
/* 129 */       client.connect();
/*     */ 
/* 132 */       SocketFactory sf2 = getDefaultSocketFactory();
/* 133 */       ClientInvoker clientInvoker = client.getInvoker();
/* 134 */       clientInvoker.setSocketFactory(sf2);
/*     */ 
/* 136 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 144 */       freeport = PortUtil.findFreePort(getHostName());
/* 145 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 146 */       Connector callbackConnector = new Connector(callbackLocator.getLocatorURI());
/* 147 */       callbackConnector.create();
/* 148 */       ServerInvoker callbackServerInvoker = callbackConnector.getServerInvoker();
/* 149 */       ServerSocketFactory ssf2 = getDefaultCallbackServerSocketFactory();
/* 150 */       callbackServerInvoker.setServerSocketFactory(ssf2);
/* 151 */       callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 152 */       callbackConnector.start();
/*     */ 
/* 155 */       CallbackHandler callbackHandler = new CallbackHandler();
/* 156 */       String callbackHandleObject = "myCallbackHandleObject";
/* 157 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 159 */       client.disconnect();
/* 160 */       callbackConnector.stop();
/* 161 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 165 */       log.error(t);
/* 166 */       t.printStackTrace();
/* 167 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testFactoriesBySettingConnectorAndClient()
/*     */   {
/*     */     try
/*     */     {
/* 189 */       HashMap sconfig = new HashMap();
/*     */ 
/* 192 */       sconfig.put("force_remote", "true");
/*     */ 
/* 195 */       int freeport = PortUtil.findFreePort(getHostName());
/* 196 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 197 */       Connector connector = new Connector(locator, sconfig);
/*     */ 
/* 200 */       ServerSocketFactory ssf1 = getDefaultServerSocketFactory();
/* 201 */       connector.setServerSocketFactory(ssf1);
/* 202 */       SocketFactory sf1 = getDefaultCallbackSocketFactory();
/* 203 */       connector.setSocketFactory(sf1);
/* 204 */       connector.create();
/* 205 */       connector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 206 */       connector.start();
/*     */ 
/* 212 */       HashMap cconfig = new HashMap();
/*     */ 
/* 215 */       cconfig.put("force_remote", "true");
/*     */ 
/* 218 */       Client client = new Client(locator, cconfig);
/*     */ 
/* 221 */       SocketFactory sf2 = getDefaultSocketFactory();
/* 222 */       client.setSocketFactory(sf2);
/* 223 */       client.connect();
/* 224 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 232 */       freeport = PortUtil.findFreePort(getHostName());
/* 233 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 234 */       Connector callbackConnector = new Connector(callbackLocator.getLocatorURI());
/*     */ 
/* 237 */       ServerSocketFactory ssf2 = getDefaultCallbackServerSocketFactory();
/* 238 */       callbackConnector.setServerSocketFactory(ssf2);
/* 239 */       callbackConnector.create();
/* 240 */       callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 241 */       callbackConnector.start();
/*     */ 
/* 244 */       CallbackHandler callbackHandler = new CallbackHandler();
/* 245 */       String callbackHandleObject = "myCallbackHandleObject";
/* 246 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 248 */       client.disconnect();
/* 249 */       callbackConnector.stop();
/* 250 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 254 */       log.error(t);
/* 255 */       t.printStackTrace();
/* 256 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testFactoriesByPassingInConfig()
/*     */   {
/*     */     try
/*     */     {
/* 278 */       HashMap sconfig = new HashMap();
/*     */ 
/* 281 */       ServerSocketFactory ssf1 = getDefaultServerSocketFactory();
/* 282 */       sconfig.put("customServerSocketFactory", ssf1);
/* 283 */       SocketFactory sf1 = getDefaultCallbackSocketFactory();
/* 284 */       sconfig.put("customSocketFactory", sf1);
/*     */ 
/* 287 */       sconfig.put("force_remote", "true");
/*     */ 
/* 290 */       int freeport = PortUtil.findFreePort(getHostName());
/* 291 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 292 */       Connector connector = new Connector(locator, sconfig);
/* 293 */       connector.create();
/* 294 */       connector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 295 */       connector.start();
/*     */ 
/* 301 */       HashMap cconfig = new HashMap();
/*     */ 
/* 304 */       SocketFactory sf2 = getDefaultSocketFactory();
/* 305 */       cconfig.put("customSocketFactory", sf2);
/*     */ 
/* 308 */       cconfig.put("force_remote", "true");
/*     */ 
/* 311 */       Client client = new Client(locator, cconfig);
/* 312 */       client.connect();
/*     */ 
/* 314 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 322 */       HashMap cbconfig = new HashMap();
/* 323 */       ServerSocketFactory ssf2 = getDefaultCallbackServerSocketFactory();
/* 324 */       cbconfig.put("customServerSocketFactory", ssf2);
/* 325 */       freeport = PortUtil.findFreePort(getHostName());
/* 326 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 327 */       Connector callbackConnector = new Connector(callbackLocator.getLocatorURI(), cbconfig);
/* 328 */       callbackConnector.create();
/* 329 */       callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 330 */       callbackConnector.start();
/*     */ 
/* 333 */       CallbackHandler callbackHandler = new CallbackHandler();
/* 334 */       String callbackHandleObject = "myCallbackHandleObject";
/* 335 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 337 */       client.disconnect();
/* 338 */       callbackConnector.stop();
/* 339 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 343 */       log.error(t);
/* 344 */       t.printStackTrace();
/* 345 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testFactoriesByPassingClassnameInXml()
/*     */   {
/*     */     try
/*     */     {
/* 367 */       HashMap sconfig = new HashMap();
/*     */ 
/* 370 */       sconfig.put("force_remote", "true");
/*     */ 
/* 373 */       int freeport = PortUtil.findFreePort(getHostName());
/* 374 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 375 */       Connector connector = new Connector(sconfig);
/*     */ 
/* 378 */       StringBuffer buf = new StringBuffer();
/* 379 */       buf.append("<?xml version=\"1.0\"?>\n");
/* 380 */       buf.append("<config>");
/* 381 */       buf.append("<invoker transport=\"" + getTransport() + "\">");
/* 382 */       buf.append("<attribute name=\"serverBindAddress\">" + getHostName() + "</attribute>");
/* 383 */       buf.append("<attribute name=\"serverBindPort\">" + freeport + "</attribute>");
/* 384 */       buf.append("<attribute name=\"serverSocketFactory\">");
/* 385 */       buf.append(getDefaultServerSocketFactoryClass().getName());
/* 386 */       buf.append("</attribute>");
/* 387 */       buf.append("<attribute name=\"socketFactory\">");
/* 388 */       buf.append(getDefaultSocketFactoryClass().getName());
/* 389 */       buf.append("</attribute>");
/* 390 */       buf.append("</invoker>");
/* 391 */       buf.append("</config>");
/*     */ 
/* 393 */       ByteArrayInputStream bais = new ByteArrayInputStream(buf.toString().getBytes());
/* 394 */       Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
/* 395 */       connector.setConfiguration(xml.getDocumentElement());
/*     */ 
/* 397 */       connector.create();
/* 398 */       connector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 399 */       connector.start();
/*     */ 
/* 405 */       HashMap cconfig = new HashMap();
/*     */ 
/* 408 */       cconfig.put("force_remote", "true");
/*     */ 
/* 411 */       Client client = new Client(locator, cconfig);
/*     */ 
/* 415 */       SocketFactory sf = getDefaultSocketFactory();
/* 416 */       client.setSocketFactory(sf);
/* 417 */       client.connect();
/* 418 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 426 */       freeport = PortUtil.findFreePort(getHostName());
/* 427 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 428 */       Connector callbackConnector = new Connector();
/*     */ 
/* 431 */       buf = new StringBuffer();
/* 432 */       buf.append("<?xml version=\"1.0\"?>\n");
/* 433 */       buf.append("<config>");
/* 434 */       buf.append("<invoker transport=\"" + getTransport() + "\">");
/* 435 */       buf.append("<attribute name=\"serverBindAddress\">" + getHostName() + "</attribute>");
/* 436 */       buf.append("<attribute name=\"serverBindPort\">" + freeport + "</attribute>");
/* 437 */       buf.append("<attribute name=\"serverSocketFactory\">");
/* 438 */       buf.append(getDefaultCallbackServerSocketFactoryClass().getName());
/* 439 */       buf.append("</attribute>");
/* 440 */       buf.append("</invoker>");
/* 441 */       buf.append("</config>");
/* 442 */       bais = new ByteArrayInputStream(buf.toString().getBytes());
/* 443 */       xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
/* 444 */       callbackConnector.setConfiguration(xml.getDocumentElement());
/*     */ 
/* 446 */       callbackConnector.create();
/* 447 */       callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 448 */       callbackConnector.start();
/*     */ 
/* 451 */       CallbackHandler callbackHandler = new CallbackHandler();
/* 452 */       String callbackHandleObject = "myCallbackHandleObject";
/* 453 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 455 */       client.disconnect();
/* 456 */       callbackConnector.stop();
/* 457 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 461 */       log.error(t);
/* 462 */       t.printStackTrace();
/* 463 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testFactoriesByClassNameinConfig()
/*     */   {
/*     */     try
/*     */     {
/* 485 */       HashMap sconfig = new HashMap();
/*     */ 
/* 488 */       sconfig.put("serverSocketFactory", getDefaultServerSocketFactoryClass().getName());
/* 489 */       sconfig.put("socketFactory", getDefaultCallbackSocketFactoryClass().getName());
/*     */ 
/* 492 */       sconfig.put("force_remote", "true");
/*     */ 
/* 495 */       int freeport = PortUtil.findFreePort(getHostName());
/* 496 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 497 */       Connector connector = new Connector(locator, sconfig);
/* 498 */       connector.create();
/* 499 */       connector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 500 */       connector.start();
/*     */ 
/* 506 */       HashMap cconfig = new HashMap();
/*     */ 
/* 509 */       cconfig.put("socketFactory", getDefaultSocketFactoryClass().getName());
/*     */ 
/* 512 */       cconfig.put("force_remote", "true");
/*     */ 
/* 515 */       Client client = new Client(locator, cconfig);
/* 516 */       client.connect();
/*     */ 
/* 518 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 526 */       HashMap cbconfig = new HashMap();
/* 527 */       cbconfig.put("serverSocketFactory", getDefaultCallbackServerSocketFactoryClass().getName());
/* 528 */       freeport = PortUtil.findFreePort(getHostName());
/* 529 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 530 */       Connector callbackConnector = new Connector(callbackLocator.getLocatorURI(), cbconfig);
/* 531 */       callbackConnector.create();
/* 532 */       callbackConnector.addInvocationHandler("sample", new SampleInvocationHandler());
/* 533 */       callbackConnector.start();
/*     */ 
/* 536 */       CallbackHandler callbackHandler = new CallbackHandler();
/* 537 */       String callbackHandleObject = "myCallbackHandleObject";
/* 538 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 540 */       client.disconnect();
/* 541 */       callbackConnector.stop();
/* 542 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 546 */       log.error(t);
/* 547 */       t.printStackTrace();
/* 548 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getTransport()
/*     */   {
/* 555 */     return "socket";
/*     */   }
/*     */ 
/*     */   protected String getHostName()
/*     */   {
/* 561 */     return "localhost";
/*     */   }
/*     */ 
/*     */   protected ServerSocketFactory getDefaultServerSocketFactory()
/*     */     throws Exception
/*     */   {
/* 567 */     return new SampleServerSocketFactory();
/*     */   }
/*     */ 
/*     */   protected SocketFactory getDefaultSocketFactory()
/*     */     throws Exception
/*     */   {
/* 573 */     return new SampleSocketFactory();
/*     */   }
/*     */ 
/*     */   protected ServerSocketFactory getDefaultCallbackServerSocketFactory()
/*     */     throws Exception
/*     */   {
/* 579 */     return new SampleServerSocketFactory();
/*     */   }
/*     */ 
/*     */   protected SocketFactory getDefaultCallbackSocketFactory()
/*     */     throws Exception
/*     */   {
/* 585 */     return new SampleSocketFactory();
/*     */   }
/*     */ 
/*     */   protected Class getDefaultServerSocketFactoryClass()
/*     */     throws Exception
/*     */   {
/* 591 */     return SampleServerSocketFactory.class;
/*     */   }
/*     */ 
/*     */   protected Class getDefaultSocketFactoryClass()
/*     */     throws Exception
/*     */   {
/* 597 */     return SampleSocketFactory.class;
/*     */   }
/*     */ 
/*     */   protected Class getDefaultCallbackServerSocketFactoryClass()
/*     */     throws Exception
/*     */   {
/* 603 */     return SampleServerSocketFactory.class;
/*     */   }
/*     */ 
/*     */   protected Class getDefaultCallbackSocketFactoryClass()
/*     */     throws Exception
/*     */   {
/* 609 */     return SampleSocketFactory.class;
/*     */   }
/*     */ 
/*     */   public static class CallbackHandler
/*     */     implements InvokerCallbackHandler
/*     */   {
/*     */     public void handleCallback(Callback callback)
/*     */       throws HandleCallbackException
/*     */     {
/* 720 */       System.out.println("Received callback value of: " + callback.getCallbackObject());
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler
/*     */   {
/*     */     private InvokerCallbackHandler callbackHandler;
/*     */ 
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 668 */       return invocation.getParameter();
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/* 673 */       FactoryConfigSample.log.info("entering addListener()");
/* 674 */       this.callbackHandler = callbackHandler;
/*     */       try
/*     */       {
/* 678 */         Callback callback = new Callback(new Integer(1));
/* 679 */         callbackHandler.handleCallback(callback);
/* 680 */         FactoryConfigSample.log.info("sent first callback");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 684 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */ 
/*     */     public InvokerCallbackHandler getCallbackHandler()
/*     */     {
/* 704 */       return this.callbackHandler;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleSocketFactory extends SocketFactory
/*     */   {
/*     */     public Socket createSocket(String arg0, int arg1)
/*     */       throws IOException, UnknownHostException
/*     */     {
/* 638 */       return new Socket(arg0, arg1);
/*     */     }
/*     */ 
/*     */     public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException
/*     */     {
/* 643 */       return new Socket(arg0, arg1, arg2, arg3);
/*     */     }
/*     */ 
/*     */     public Socket createSocket(InetAddress arg0, int arg1) throws IOException
/*     */     {
/* 648 */       return new Socket(arg0, arg1);
/*     */     }
/*     */ 
/*     */     public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException
/*     */     {
/* 653 */       return new Socket(arg0, arg1, arg2, arg3);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleServerSocketFactory extends ServerSocketFactory
/*     */   {
/*     */     public ServerSocket createServerSocket(int arg0)
/*     */       throws IOException
/*     */     {
/* 618 */       return new ServerSocket(arg0);
/*     */     }
/*     */ 
/*     */     public ServerSocket createServerSocket(int arg0, int arg1) throws IOException
/*     */     {
/* 623 */       return new ServerSocket(arg0, arg1);
/*     */     }
/*     */ 
/*     */     public ServerSocket createServerSocket(int arg0, int arg1, InetAddress arg2) throws IOException
/*     */     {
/* 628 */       return new ServerSocket(arg0, arg1, arg2);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.config.factories.FactoryConfigSample
 * JD-Core Version:    0.6.0
 */