/*     */ package org.jboss.remoting.samples.config.factories;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import java.util.HashMap;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.ObjectName;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import junit.framework.TestCase;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.security.SSLServerSocketFactoryService;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.security.SSLSocketFactoryService;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ import org.jboss.remoting.transport.PortUtil;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class FactoryConfigSSLSample extends TestCase
/*     */ {
/*  74 */   private static Logger log = Logger.getLogger(FactoryConfigSSLSample.class);
/*     */ 
/*     */   public void testFactoriesByPassingMBeanInXml()
/*     */   {
/*     */     try
/*     */     {
/*  95 */       HashMap sconfig = new HashMap();
/*     */ 
/*  98 */       sconfig.put("force_remote", "true");
/*     */ 
/* 101 */       ServerSocketFactory service = getDefaultServerSocketFactory();
/* 102 */       String serverSocketFactoryName = "jboss:type=serversocketfactory";
/* 103 */       ObjectName objName = new ObjectName(serverSocketFactoryName);
/* 104 */       MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
/* 105 */       mbeanServer.registerMBean(service, objName);
/*     */ 
/* 108 */       int freeport = PortUtil.findFreePort(getHostName());
/* 109 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 110 */       Connector connector = new Connector(sconfig);
/* 111 */       mbeanServer.registerMBean(connector, new ObjectName("test:type=connector"));
/*     */ 
/* 114 */       StringBuffer buf = new StringBuffer();
/* 115 */       buf.append("<?xml version=\"1.0\"?>\n");
/* 116 */       buf.append("<config>");
/* 117 */       buf.append("<invoker transport=\"" + getTransport() + "\">");
/* 118 */       buf.append("<attribute name=\"serverBindAddress\">" + getHostName() + "</attribute>");
/* 119 */       buf.append("<attribute name=\"serverBindPort\">" + freeport + "</attribute>");
/* 120 */       buf.append("<attribute name=\"serverSocketFactory\">");
/* 121 */       buf.append(serverSocketFactoryName);
/* 122 */       buf.append("</attribute>");
/* 123 */       buf.append("</invoker>");
/* 124 */       buf.append("</config>");
/* 125 */       ByteArrayInputStream bais = new ByteArrayInputStream(buf.toString().getBytes());
/* 126 */       Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
/* 127 */       connector.setConfiguration(xml.getDocumentElement());
/*     */ 
/* 129 */       connector.create();
/* 130 */       connector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
/* 131 */       connector.start();
/*     */ 
/* 137 */       HashMap cconfig = new HashMap();
/*     */ 
/* 140 */       cconfig.put("force_remote", "true");
/*     */ 
/* 143 */       Client client = new Client(locator, cconfig);
/*     */ 
/* 147 */       SocketFactory sf = getDefaultSocketFactory();
/* 148 */       client.setSocketFactory(sf);
/* 149 */       client.connect();
/* 150 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 159 */       freeport = PortUtil.findFreePort(getHostName());
/* 160 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 161 */       Connector callbackConnector = new Connector(callbackLocator.getLocatorURI());
/* 162 */       ServerSocketFactory ssf = getDefaultCallbackServerSocketFactory();
/* 163 */       callbackConnector.setServerSocketFactory(ssf);
/* 164 */       callbackConnector.create();
/* 165 */       callbackConnector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
/* 166 */       callbackConnector.start();
/*     */ 
/* 169 */       FactoryConfigSample.CallbackHandler callbackHandler = new FactoryConfigSample.CallbackHandler();
/* 170 */       String callbackHandleObject = "myCallbackHandleObject";
/* 171 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 173 */       client.disconnect();
/* 174 */       callbackConnector.stop();
/* 175 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 179 */       log.error(t);
/* 180 */       t.printStackTrace();
/* 181 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testFactoriesByPassingMBeanInConfig()
/*     */   {
/*     */     try
/*     */     {
/* 206 */       HashMap sconfig = new HashMap();
/*     */ 
/* 209 */       ServerSocketFactory service = getDefaultServerSocketFactory();
/* 210 */       String serverSocketFactoryName = "jboss:type=serversocketfactory";
/* 211 */       ObjectName objName = new ObjectName(serverSocketFactoryName);
/* 212 */       MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
/* 213 */       mbeanServer.registerMBean(service, objName);
/* 214 */       sconfig.put("serverSocketFactory", serverSocketFactoryName);
/*     */ 
/* 217 */       sconfig.put("force_remote", "true");
/*     */ 
/* 220 */       int freeport = PortUtil.findFreePort(getHostName());
/* 221 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 222 */       Connector connector = new Connector(locator, sconfig);
/* 223 */       mbeanServer.registerMBean(connector, new ObjectName("test:type=connector"));
/* 224 */       connector.create();
/* 225 */       connector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
/* 226 */       connector.start();
/*     */ 
/* 232 */       HashMap cconfig = new HashMap();
/*     */ 
/* 235 */       cconfig.put("force_remote", "true");
/*     */ 
/* 238 */       Client client = new Client(locator, cconfig);
/*     */ 
/* 242 */       SocketFactory sf = getDefaultSocketFactory();
/* 243 */       client.setSocketFactory(sf);
/* 244 */       client.connect();
/* 245 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 254 */       freeport = PortUtil.findFreePort(getHostName());
/* 255 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 256 */       Connector callbackConnector = new Connector(callbackLocator.getLocatorURI());
/* 257 */       ServerSocketFactory ssf = getDefaultCallbackServerSocketFactory();
/* 258 */       callbackConnector.setServerSocketFactory(ssf);
/* 259 */       callbackConnector.create();
/* 260 */       callbackConnector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
/* 261 */       callbackConnector.start();
/*     */ 
/* 264 */       FactoryConfigSample.CallbackHandler callbackHandler = new FactoryConfigSample.CallbackHandler();
/* 265 */       String callbackHandleObject = "myCallbackHandleObject";
/* 266 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 268 */       client.disconnect();
/* 269 */       callbackConnector.stop();
/* 270 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 274 */       log.error(t);
/* 275 */       t.printStackTrace();
/* 276 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testFactoriesFromSSLParameters()
/*     */   {
/*     */     try
/*     */     {
/* 298 */       HashMap sconfig = new HashMap();
/*     */ 
/* 301 */       sconfig.put("force_remote", "true");
/*     */ 
/* 304 */       sconfig.put("org.jboss.remoting.serversocket.useClientMode", "false");
/* 305 */       sconfig.put("org.jboss.remoting.keyStoreType", "JKS");
/* 306 */       String keyStoreFilePath = getKeystoreFilePath();
/* 307 */       sconfig.put("org.jboss.remoting.keyStore", keyStoreFilePath);
/* 308 */       sconfig.put("org.jboss.remoting.keyStorePassword", "unit-tests-server");
/*     */ 
/* 311 */       int freeport = PortUtil.findFreePort(getHostName());
/* 312 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 313 */       Connector connector = new Connector(locator, sconfig);
/* 314 */       connector.create();
/* 315 */       connector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
/* 316 */       connector.start();
/*     */ 
/* 322 */       HashMap cconfig = new HashMap();
/*     */ 
/* 325 */       cconfig.put("force_remote", "true");
/*     */ 
/* 328 */       cconfig.put("org.jboss.remoting.socket.useClientMode", "true");
/* 329 */       cconfig.put("org.jboss.remoting.trustStoreType", "JKS");
/* 330 */       String trustStoreFilePath = getTruststoreFilePath();
/* 331 */       cconfig.put("org.jboss.remoting.trustStore", trustStoreFilePath);
/* 332 */       cconfig.put("org.jboss.remoting.trustStorePassword", "unit-tests-client");
/*     */ 
/* 335 */       Client client = new Client(locator, cconfig);
/* 336 */       client.connect();
/* 337 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 345 */       HashMap cbconfig = new HashMap();
/*     */ 
/* 348 */       cbconfig.put("org.jboss.remoting.serversocket.useClientMode", "true");
/* 349 */       cbconfig.put("org.jboss.remoting.trustStoreType", "JKS");
/* 350 */       cbconfig.put("org.jboss.remoting.trustStore", trustStoreFilePath);
/* 351 */       cbconfig.put("org.jboss.remoting.trustStorePassword", "unit-tests-client");
/*     */ 
/* 353 */       freeport = PortUtil.findFreePort(getHostName());
/* 354 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 355 */       Connector callbackConnector = new Connector(callbackLocator.getLocatorURI(), cbconfig);
/* 356 */       callbackConnector.create();
/* 357 */       callbackConnector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
/* 358 */       callbackConnector.start();
/*     */ 
/* 361 */       FactoryConfigSample.CallbackHandler callbackHandler = new FactoryConfigSample.CallbackHandler();
/* 362 */       String callbackHandleObject = "myCallbackHandleObject";
/* 363 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 365 */       client.disconnect();
/* 366 */       callbackConnector.stop();
/* 367 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 371 */       log.error(t);
/* 372 */       t.printStackTrace();
/* 373 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void testFactoriesFromSystemSSLParameters()
/*     */   {
/*     */     try
/*     */     {
/* 395 */       HashMap sconfig = new HashMap();
/*     */ 
/* 398 */       sconfig.put("force_remote", "true");
/*     */ 
/* 401 */       System.setProperty("javax.net.ssl.keyStoreType", "JKS");
/* 402 */       String keyStoreFilePath = getKeystoreFilePath();
/* 403 */       System.setProperty("javax.net.ssl.keyStore", keyStoreFilePath);
/* 404 */       System.setProperty("javax.net.ssl.keyStorePassword", "unit-tests-server");
/* 405 */       System.setProperty("javax.net.ssl.trustStoreType", "JKS");
/* 406 */       String trustStoreFilePath = getTruststoreFilePath();
/* 407 */       System.setProperty("javax.net.ssl.trustStore", trustStoreFilePath);
/* 408 */       System.setProperty("javax.net.ssl.trustStorePassword", "unit-tests-client");
/*     */ 
/* 411 */       int freeport = PortUtil.findFreePort(getHostName());
/* 412 */       InvokerLocator locator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 413 */       Connector connector = new Connector(locator, sconfig);
/* 414 */       connector.create();
/* 415 */       connector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
/* 416 */       connector.start();
/*     */ 
/* 422 */       HashMap cconfig = new HashMap();
/*     */ 
/* 425 */       cconfig.put("force_remote", "true");
/*     */ 
/* 428 */       Client client = new Client(locator, cconfig);
/* 429 */       client.connect();
/* 430 */       System.out.println(getName() + ": " + client.invoke("test invoke()"));
/*     */ 
/* 438 */       HashMap cbconfig = new HashMap();
/*     */ 
/* 441 */       cbconfig.put("org.jboss.remoting.serversocket.useClientMode", "true");
/*     */ 
/* 443 */       freeport = PortUtil.findFreePort(getHostName());
/* 444 */       InvokerLocator callbackLocator = new InvokerLocator(getTransport() + "://" + getHostName() + ":" + freeport);
/* 445 */       Connector callbackConnector = new Connector(callbackLocator.getLocatorURI(), cbconfig);
/* 446 */       callbackConnector.create();
/* 447 */       callbackConnector.addInvocationHandler("sample", new FactoryConfigSample.SampleInvocationHandler());
/* 448 */       callbackConnector.start();
/*     */ 
/* 451 */       FactoryConfigSample.CallbackHandler callbackHandler = new FactoryConfigSample.CallbackHandler();
/* 452 */       String callbackHandleObject = "myCallbackHandleObject";
/* 453 */       client.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 455 */       client.disconnect();
/* 456 */       callbackConnector.stop();
/* 457 */       connector.stop();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 461 */       log.error(t);
/* 462 */       t.printStackTrace();
/* 463 */       fail();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getHostName()
/*     */   {
/* 470 */     return "localhost";
/*     */   }
/*     */ 
/*     */   protected String getTransport()
/*     */   {
/* 476 */     return "sslsocket";
/*     */   }
/*     */ 
/*     */   protected String getKeystoreFilePath()
/*     */   {
/* 482 */     File file = new File(FactoryConfigSSLSample.class.getResource("keystore").getFile());
/* 483 */     return file.getPath();
/*     */   }
/*     */ 
/*     */   protected static String getTruststoreFilePath()
/*     */   {
/* 489 */     File file = new File(FactoryConfigSSLSample.class.getResource("truststore").getFile());
/* 490 */     return file.getPath();
/*     */   }
/*     */ 
/*     */   protected ServerSocketFactory getDefaultServerSocketFactory()
/*     */     throws Exception
/*     */   {
/* 496 */     HashMap config = new HashMap();
/* 497 */     config.put("org.jboss.remoting.keyStoreType", "JKS");
/* 498 */     String keyStoreFilePath = getKeystoreFilePath();
/* 499 */     config.put("org.jboss.remoting.keyStore", keyStoreFilePath);
/* 500 */     config.put("org.jboss.remoting.keyStorePassword", "unit-tests-server");
/* 501 */     config.put("org.jboss.remoting.sslProtocol", "SSL");
/* 502 */     SSLSocketBuilder builder = new SSLSocketBuilder(config);
/* 503 */     builder.setUseSSLServerSocketFactory(false);
/* 504 */     SSLServerSocketFactoryService service = new SSLServerSocketFactoryService();
/* 505 */     service.setSSLSocketBuilder(builder);
/* 506 */     service.start();
/* 507 */     return service;
/*     */   }
/*     */ 
/*     */   protected SocketFactory getDefaultSocketFactory() throws Exception
/*     */   {
/* 512 */     HashMap config = new HashMap();
/* 513 */     config.put("org.jboss.remoting.trustStoreType", "JKS");
/* 514 */     String trustStoreFilePath = getTruststoreFilePath();
/* 515 */     config.put("org.jboss.remoting.trustStore", trustStoreFilePath);
/* 516 */     config.put("org.jboss.remoting.trustStorePassword", "unit-tests-client");
/* 517 */     config.put("org.jboss.remoting.sslProtocol", "SSL");
/* 518 */     SSLSocketBuilder builder = new SSLSocketBuilder(config);
/* 519 */     builder.setUseSSLSocketFactory(false);
/* 520 */     SSLSocketFactoryService service = new SSLSocketFactoryService();
/* 521 */     service.setSSLSocketBuilder(builder);
/* 522 */     service.start();
/* 523 */     return service;
/*     */   }
/*     */ 
/*     */   protected ServerSocketFactory getDefaultCallbackServerSocketFactory() throws Exception
/*     */   {
/* 528 */     HashMap config = new HashMap();
/* 529 */     config.put("org.jboss.remoting.serversocket.useClientMode", "true");
/* 530 */     config.put("org.jboss.remoting.trustStoreType", "JKS");
/* 531 */     String trustStoreFilePath = getTruststoreFilePath();
/* 532 */     config.put("org.jboss.remoting.trustStore", trustStoreFilePath);
/* 533 */     config.put("org.jboss.remoting.trustStorePassword", "unit-tests-client");
/* 534 */     config.put("org.jboss.remoting.sslProtocol", "SSL");
/* 535 */     SSLSocketBuilder builder = new SSLSocketBuilder(config);
/* 536 */     builder.setUseSSLServerSocketFactory(false);
/* 537 */     SSLServerSocketFactoryService service = new SSLServerSocketFactoryService();
/* 538 */     service.setSSLSocketBuilder(builder);
/* 539 */     service.start();
/* 540 */     return service;
/*     */   }
/*     */ 
/*     */   protected SocketFactory getDefaultCallbackSocketFactory() throws Exception
/*     */   {
/* 545 */     HashMap config = new HashMap();
/* 546 */     config.put("org.jboss.remoting.socket.useClientMode", "false");
/* 547 */     config.put("org.jboss.remoting.keyStoreType", "JKS");
/* 548 */     String keyStoreFilePath = getKeystoreFilePath();
/* 549 */     config.put("org.jboss.remoting.keyStore", keyStoreFilePath);
/* 550 */     config.put("org.jboss.remoting.keyStorePassword", "unit-tests-server");
/* 551 */     config.put("org.jboss.remoting.sslProtocol", "SSL");
/* 552 */     SSLSocketBuilder builder = new SSLSocketBuilder(config);
/* 553 */     builder.setUseSSLSocketFactory(false);
/* 554 */     SSLSocketFactoryService service = new SSLSocketFactoryService();
/* 555 */     service.setSSLSocketBuilder(builder);
/* 556 */     service.start();
/* 557 */     return builder.createSSLSocketFactory();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.config.factories.FactoryConfigSSLSample
 * JD-Core Version:    0.6.0
 */