/*     */ package org.jboss.remoting.samples.chat.server;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Iterator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.samples.chat.client.ChatInfo;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
/*     */ import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
/*     */ import org.jboss.remoting.samples.chat.utility.ShutDownGate;
/*     */ 
/*     */ public class ChatStore
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  26 */   protected static final Logger log = Logger.getLogger(ChatStore.class);
/*     */   private Hashtable extendedChatInfoMap;
/*     */   private ShutDownGate shutDownGate;
/*     */ 
/*     */   public ChatStore()
/*     */   {
/*  33 */     this.extendedChatInfoMap = new Hashtable();
/*  34 */     this.shutDownGate = new ShutDownGate();
/*     */   }
/*     */ 
/*     */   public ShutDownGate getShutDownGate()
/*     */   {
/*  61 */     return this.shutDownGate;
/*     */   }
/*     */ 
/*     */   public void addChat(ExtendedChatInfo eci) throws ShuttingDownException
/*     */   {
/*  66 */     this.shutDownGate.enter();
/*  67 */     String key = eci.getChatInfo().get_key();
/*  68 */     this.extendedChatInfoMap.put(key, eci);
/*  69 */     log.info("adding chat " + key);
/*  70 */     this.shutDownGate.leave();
/*     */   }
/*     */ 
/*     */   ArrayList listChats()
/*     */     throws ShuttingDownException
/*     */   {
/*  77 */     this.shutDownGate.check();
/*  78 */     Collection c = this.extendedChatInfoMap.values();
/*  79 */     ArrayList chatArrayList = new ArrayList();
/*     */ 
/*  81 */     Iterator it = c.iterator();
/*  82 */     while (it.hasNext())
/*     */     {
/*  84 */       ExtendedChatInfo eci = (ExtendedChatInfo)it.next();
/*  85 */       ChatInfo ci = eci.getChatInfo();
/*  86 */       ci.set_currentMembers(eci.getMembers().size());
/*  87 */       ci.set_size(eci.getMessages().size());
/*  88 */       chatArrayList.add(ci);
/*  89 */       log.debug("eci.getMembers(): " + eci.getMembers());
/*     */     }
/*     */ 
/*  92 */     return chatArrayList;
/*     */   }
/*     */ 
/*     */   public ExtendedChatInfo getChat(String key)
/*     */     throws ShuttingDownException
/*     */   {
/*  98 */     this.shutDownGate.check();
/*  99 */     ExtendedChatInfo eci = (ExtendedChatInfo)this.extendedChatInfoMap.get(key);
/* 100 */     return eci;
/*     */   }
/*     */ 
/*     */   public Collection getChatKeySet()
/*     */   {
/* 105 */     return this.extendedChatInfoMap.keySet();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.server.ChatStore
 * JD-Core Version:    0.6.0
 */