/*     */ package org.jboss.remoting.samples.chat.server;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.invocation.RemoteInvocation;
/*     */ import org.jboss.remoting.samples.chat.client.ChatInfo;
/*     */ import org.jboss.remoting.samples.chat.client.ChatMember;
/*     */ import org.jboss.remoting.samples.chat.client.ChatMessage;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
/*     */ import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
/*     */ import org.jboss.remoting.samples.chat.utility.ShutDownGate;
/*     */ 
/*     */ public class ChatServer_Impl
/*     */   implements ServerInvocationHandler
/*     */ {
/*  35 */   protected static final Logger log = Logger.getLogger(ChatServer_Impl.class);
/*     */   private ExtendedChatInfo extendedChatInfo;
/*  38 */   private Map callbackThreadMap = new HashMap();
/*     */   private ShutDownGate shutDownGate;
/*  40 */   private boolean shuttingDown = false;
/*     */ 
/*     */   public ChatServer_Impl(ExtendedChatInfo eci, ShutDownGate sdg)
/*     */   {
/*  45 */     this.extendedChatInfo = eci;
/*  46 */     this.shutDownGate = sdg;
/*     */   }
/*     */ 
/*     */   public Object invoke(InvocationRequest invocation)
/*     */     throws Throwable
/*     */   {
/*  52 */     if (!(invocation.getParameter() instanceof RemoteInvocation)) {
/*  53 */       throw new Exception("invalid request format: expecting NameBasedInvocation");
/*     */     }
/*  55 */     RemoteInvocation request = (RemoteInvocation)invocation.getParameter();
/*  56 */     String methodName = request.getMethodName();
/*  57 */     Object[] args = request.getParameters();
/*     */ 
/*  59 */     if (methodName.equals("getBackChat")) {
/*  60 */       return getBackChat(args);
/*     */     }
/*  62 */     if (methodName.equals("getChatInfo")) {
/*  63 */       return getChatInfo(args);
/*     */     }
/*  65 */     if (methodName.equals("leave"))
/*     */     {
/*  67 */       leave(args);
/*  68 */       return null;
/*     */     }
/*     */ 
/*  71 */     if (methodName.equals("send"))
/*     */     {
/*  73 */       send(args);
/*  74 */       return null;
/*     */     }
/*     */ 
/*  77 */     log.error("unrecognized method name: " + methodName);
/*  78 */     throw new Exception("unrecognized method name: " + methodName);
/*     */   }
/*     */ 
/*     */   protected ArrayList getBackChat(Object[] args)
/*     */     throws ShuttingDownException
/*     */   {
/*  84 */     this.shutDownGate.enter();
/*  85 */     ReadWriteArrayList messages = this.extendedChatInfo.getMessages();
/*     */ 
/*  87 */     if (messages == null)
/*     */     {
/*  89 */       System.out.println("messages == null");
/*  90 */       messages = new ReadWriteArrayList();
/*     */     }
/*     */ 
/*  93 */     ArrayList returnMessages = messages.toArrayList();
/*  94 */     this.shutDownGate.leave();
/*  95 */     return returnMessages;
/*     */   }
/*     */ 
/*     */   protected ChatInfo getChatInfo(Object[] args)
/*     */     throws ShuttingDownException
/*     */   {
/* 101 */     this.shutDownGate.check();
/* 102 */     ChatInfo chatInfo = this.extendedChatInfo.getChatInfo();
/* 103 */     chatInfo.set_currentMembers(this.extendedChatInfo.getMembers().size());
/* 104 */     chatInfo.set_size(this.extendedChatInfo.getMessages().size());
/* 105 */     return chatInfo;
/*     */   }
/*     */ 
/*     */   protected void leave(Object[] args)
/*     */     throws ShuttingDownException
/*     */   {
/* 111 */     ChatMember member = (ChatMember)args[0];
/* 112 */     this.shutDownGate.enter();
/* 113 */     System.out.println("ChatServer.leave(): member leaving: " + member.get_name());
/* 114 */     this.extendedChatInfo.removeMember(member);
/* 115 */     this.shutDownGate.leave();
/*     */   }
/*     */ 
/*     */   protected void send(Object[] args)
/*     */     throws ShuttingDownException
/*     */   {
/* 121 */     ChatMessage mesg = (ChatMessage)args[0];
/* 122 */     this.shutDownGate.enter();
/* 123 */     ReadWriteArrayList messages = this.extendedChatInfo.getMessages();
/* 124 */     messages.add(mesg);
/* 125 */     this.shutDownGate.leave();
/*     */   }
/*     */ 
/*     */   public void setMBeanServer(MBeanServer server)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setInvoker(ServerInvoker invoker)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void addListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/* 139 */     CallbackThread t = new CallbackThread(callbackHandler, this.shutDownGate, this.extendedChatInfo.getMessages());
/* 140 */     this.callbackThreadMap.put(callbackHandler, t);
/* 141 */     t.start();
/*     */   }
/*     */ 
/*     */   public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/* 146 */     CallbackThread t = (CallbackThread)this.callbackThreadMap.remove(callbackHandler);
/*     */ 
/* 148 */     if (t != null)
/* 149 */       t.setMemberLeaving();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.server.ChatServer_Impl
 * JD-Core Version:    0.6.0
 */