/*     */ package org.jboss.remoting.samples.chat.server;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Date;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.invocation.RemoteInvocation;
/*     */ import org.jboss.remoting.samples.chat.client.ChatInfo;
/*     */ import org.jboss.remoting.samples.chat.client.ChatMember;
/*     */ import org.jboss.remoting.samples.chat.exceptions.InitializeException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.NameInUseException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.RemoteConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
/*     */ import org.jboss.remoting.samples.chat.utility.ShutDownGate;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class ChatManager
/*     */   implements ServerInvocationHandler
/*     */ {
/*  33 */   protected static final Logger log = Logger.getLogger(ChatManager.class);
/*     */   private static final String chatServerLocator = "socket://localhost";
/*     */   private ChatStore chatStore;
/*  37 */   private final File chatStoreFile = new File("chatStore.ser");
/*  38 */   private boolean chatStoreSaved = false;
/*  39 */   private boolean shuttingDown = false;
/*     */ 
/*     */   public ChatManager()
/*     */   {
/*     */     try
/*     */     {
/*  46 */       initialize();
/*     */     }
/*     */     catch (InitializeException ie)
/*     */     {
/*  50 */       log.error("ChatManager_Impl: cannot initialize: " + ie);
/*  51 */       System.exit(1);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initialize()
/*     */     throws InitializeException
/*     */   {
/*  59 */     if (this.chatStoreFile.exists())
/*     */     {
/*     */       try
/*     */       {
/*  63 */         log.info("ChatManager_Impl: reading existing ChatStore");
/*  64 */         FileInputStream file = new FileInputStream(this.chatStoreFile);
/*  65 */         ObjectInputStream input = new ObjectInputStream(file);
/*  66 */         this.chatStore = ((ChatStore)input.readObject());
/*  67 */         this.chatStore.getShutDownGate().reset();
/*  68 */         log.info("ChatManager_Impl: read existing ChatStore");
/*     */       }
/*     */       catch (IOException ioe) {
/*  71 */         log.error("ChatManager_Impl: i/o error reading chatStore: " + ioe);
/*  72 */         System.exit(1);
/*     */       }
/*     */       catch (ClassNotFoundException cnfe) {
/*  75 */         log.error("ChatManager_Impl: ChatStore class not found: " + cnfe);
/*  76 */         System.exit(2);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  81 */       this.chatStore = new ChatStore();
/*  82 */       log.info("ChatManager_Impl: created new ChatStore");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shutdown()
/*     */   {
/*  98 */     log.info("shutdown(): shutting down");
/*     */ 
/* 100 */     if (this.chatStoreSaved)
/*     */     {
/* 102 */       log.info("shutdown(): chatStore already saved");
/* 103 */       return;
/*     */     }
/*     */ 
/* 106 */     this.chatStore.getShutDownGate().shutDown();
/*     */ 
/* 108 */     ObjectOutputStream out = null;
/*     */     try
/*     */     {
/* 111 */       out = new ObjectOutputStream(new FileOutputStream(this.chatStoreFile));
/* 112 */       out.writeObject(this.chatStore);
/* 113 */       out.flush();
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 117 */       log.error("ChatManager_Impl: i/o error writing chatStore" + ioe);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 123 */         out.close();
/*     */       }
/*     */       catch (IOException ioe)
/*     */       {
/* 127 */         log.error("ChatManager_Impl: i/o error closing chatStore" + ioe);
/*     */       }
/*     */     }
/*     */ 
/* 131 */     this.chatStoreSaved = true;
/* 132 */     log.info("shutdown(): shut down");
/*     */   }
/*     */ 
/*     */   public Object invoke(InvocationRequest invocation)
/*     */     throws Throwable
/*     */   {
/* 138 */     if (!(invocation.getParameter() instanceof RemoteInvocation)) {
/* 139 */       throw new Exception("invalid request format: expecting RemoteInvocation");
/*     */     }
/* 141 */     RemoteInvocation request = (RemoteInvocation)invocation.getParameter();
/* 142 */     String methodName = request.getMethodName();
/* 143 */     Object[] args = request.getParameters();
/*     */ 
/* 145 */     if (methodName.equals("createChat")) {
/* 146 */       return createChat(args);
/*     */     }
/* 148 */     if (methodName.equals("join"))
/*     */     {
/* 150 */       join(args);
/* 151 */       return null;
/*     */     }
/*     */ 
/* 154 */     if (methodName.equals("leave"))
/*     */     {
/* 156 */       leave(args);
/* 157 */       return null;
/*     */     }
/*     */ 
/* 160 */     if (methodName.equals("list")) {
/* 161 */       return list(args);
/*     */     }
/*     */ 
/* 164 */     throw new Exception("unrecognized method name: " + methodName);
/*     */   }
/*     */ 
/*     */   protected ArrayList list(Object[] args)
/*     */     throws RemoteConnectionException, ShuttingDownException
/*     */   {
/* 170 */     return this.chatStore.listChats();
/*     */   }
/*     */ 
/*     */   protected InvokerLocator createChat(Object[] args)
/*     */     throws Exception
/*     */   {
/* 176 */     String description = (String)args[0];
/* 177 */     ChatMember owner = (ChatMember)args[1];
/*     */ 
/* 179 */     ChatInfo chatInfo = new ChatInfo();
/* 180 */     ExtendedChatInfo extendedChatInfo = new ExtendedChatInfo(chatInfo);
/*     */ 
/* 182 */     Connector connector = new Connector();
/* 183 */     connector.setInvokerLocator("socket://localhost");
/* 184 */     connector.create();
/* 185 */     connector.addInvocationHandler("chatServer", new ChatServer_Impl(extendedChatInfo, this.chatStore.getShutDownGate()));
/* 186 */     connector.start();
/*     */ 
/* 188 */     InvokerLocator chatLocator = connector.getLocator();
/* 189 */     String key = chatLocator.getLocatorURI();
/* 190 */     chatInfo.set_key(key);
/* 191 */     chatInfo.set_description(description);
/* 192 */     chatInfo.set_owner(owner);
/* 193 */     chatInfo.set_origin(new Date());
/* 194 */     extendedChatInfo.addMember(owner);
/* 195 */     this.chatStore.addChat(extendedChatInfo);
/* 196 */     return chatLocator;
/*     */   }
/*     */ 
/*     */   protected void join(Object[] args)
/*     */     throws NameInUseException, ShuttingDownException
/*     */   {
/* 203 */     String key = (String)args[0];
/* 204 */     ChatMember newMember = (ChatMember)args[1];
/* 205 */     ExtendedChatInfo eci = this.chatStore.getChat(key);
/* 206 */     eci.addMember(newMember);
/*     */   }
/*     */ 
/*     */   protected void leave(Object[] args)
/*     */     throws ShuttingDownException
/*     */   {
/* 212 */     String key = (String)args[0];
/* 213 */     ChatMember member = (ChatMember)args[1];
/* 214 */     ExtendedChatInfo eci = this.chatStore.getChat(key);
/* 215 */     eci.getMembers().remove(member);
/*     */   }
/*     */ 
/*     */   public void setMBeanServer(MBeanServer server)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setInvoker(ServerInvoker invoker)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void addListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.server.ChatManager
 * JD-Core Version:    0.6.0
 */