/*     */ package org.jboss.remoting.samples.chat.client;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.invocation.RemoteInvocation;
/*     */ import org.jboss.remoting.samples.chat.exceptions.NameInUseException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.RemoteConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
/*     */ import org.jboss.remoting.samples.chat.server.ChatServer;
/*     */ import org.jboss.remoting.samples.chat.utility.Parameters;
/*     */ import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class RemoteStrategyRemoting
/*     */   implements RemoteStrategy
/*     */ {
/*  57 */   protected static final Logger log = Logger.getLogger(RemoteStrategyRemoting.class);
/*  58 */   private static String chatClientLocatorDefault = "socket://localhost:0";
/*  59 */   private static String chatManagerLocatorDefault = "socket://localhost:1969";
/*     */   private Client managerClient;
/*     */   private Connector receiverConnector;
/*  63 */   private boolean locallyShuttingDown = false;
/*  64 */   private boolean remotelyShuttingDown = false;
/*     */ 
/*     */   public RemoteStrategyRemoting()
/*     */     throws Exception
/*     */   {
/*  69 */     String chatManagerUriString = Parameters.getParameter("chatManagerUri");
/*     */ 
/*  71 */     if (chatManagerUriString == null) {
/*  72 */       chatManagerUriString = chatManagerLocatorDefault;
/*     */     }
/*  74 */     InvokerLocator chatManagerLocator = new InvokerLocator(chatManagerUriString);
/*  75 */     this.managerClient = new Client(chatManagerLocator);
/*  76 */     this.managerClient.connect();
/*     */   }
/*     */ 
/*     */   public ArrayList list()
/*     */     throws RemoteConnectionException, ShuttingDownException
/*     */   {
/*  82 */     RemoteInvocation invocation = new RemoteInvocation("list", null);
/*     */     try
/*     */     {
/*  86 */       return (ArrayList)this.managerClient.invoke(invocation);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  90 */       log.error(t);
/*  91 */       t.printStackTrace();
/*  92 */     }throw new RemoteConnectionException();
/*     */   }
/*     */ 
/*     */   public ChatServer createChat(String description, ChatMember owner, TalkFrame talkFrame, ReadWriteArrayList outgoingLines)
/*     */     throws NameInUseException, RemoteConnectionException, ShuttingDownException
/*     */   {
/* 103 */     Client serverClient = null;
/*     */     try
/*     */     {
/* 108 */       Object[] args = { description, owner };
/* 109 */       RemoteInvocation invocation = new RemoteInvocation("createChat", args);
/* 110 */       InvokerLocator serverLocator = (InvokerLocator)this.managerClient.invoke(invocation);
/* 111 */       serverClient = new Client(serverLocator);
/* 112 */       serverClient.connect();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 116 */       log.error(e);
/* 117 */       e.printStackTrace();
/* 118 */       throw new RemoteConnectionException();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 124 */       this.receiverConnector = new Connector();
/* 125 */       String receiverLocatorString = Parameters.getParameter("clientUriString", chatClientLocatorDefault);
/* 126 */       InvokerLocator receiverLocator = new InvokerLocator(receiverLocatorString);
/* 127 */       this.receiverConnector.setInvokerLocator(receiverLocator.getLocatorURI());
/* 128 */       log.info(receiverLocator.getLocatorURI());
/* 129 */       this.receiverConnector.start();
/* 130 */       receiverLocator = this.receiverConnector.getLocator();
/* 131 */       log.info(this.receiverConnector.getInvokerLocator());
/* 132 */       InvokerCallbackHandler receiverHandler = new ChatReceiverHandler(talkFrame);
/* 133 */       serverClient.addListener(receiverHandler, receiverLocator, owner);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 137 */       log.error(e);
/* 138 */       e.printStackTrace();
/* 139 */       throw new RemoteConnectionException();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 143 */       log.error(e);
/* 144 */       e.printStackTrace();
/* 145 */       throw new RemoteConnectionException();
/*     */     }
/*     */ 
/* 149 */     ChatServer chatServer = new ChatServerStub(serverClient);
/*     */ 
/* 152 */     SendThread sendThread = new SendThread(chatServer, outgoingLines);
/* 153 */     sendThread.start();
/*     */ 
/* 155 */     return chatServer;
/*     */   }
/*     */ 
/*     */   public ChatServer join(String key, ChatMember newMember, TalkFrame talkFrame, ReadWriteArrayList outgoingLines)
/*     */     throws NameInUseException, RemoteConnectionException, ShuttingDownException
/*     */   {
/* 162 */     Client serverClient = null;
/*     */     try
/*     */     {
/* 167 */       Object[] args = { key, newMember };
/* 168 */       RemoteInvocation invocation = new RemoteInvocation("join", args);
/* 169 */       this.managerClient.invoke(invocation);
/* 170 */       InvokerLocator serverLocator = new InvokerLocator(key);
/* 171 */       serverClient = new Client(serverLocator);
/* 172 */       serverClient.connect();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 176 */       log.error(e);
/* 177 */       e.printStackTrace();
/* 178 */       throw new RemoteConnectionException();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 184 */       this.receiverConnector = new Connector();
/* 185 */       String receiverLocatorString = Parameters.getParameter("clientUriString", chatClientLocatorDefault);
/* 186 */       InvokerLocator receiverLocator = new InvokerLocator(receiverLocatorString);
/* 187 */       this.receiverConnector.setInvokerLocator(receiverLocator.getLocatorURI());
/* 188 */       log.info(receiverLocator.getLocatorURI());
/* 189 */       this.receiverConnector.start();
/* 190 */       receiverLocator = this.receiverConnector.getLocator();
/* 191 */       InvokerCallbackHandler receiverHandler = new ChatReceiverHandler(talkFrame);
/* 192 */       serverClient.addListener(receiverHandler, receiverLocator, newMember);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 196 */       log.error(e);
/* 197 */       e.printStackTrace();
/* 198 */       throw new RemoteConnectionException();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 202 */       log.error(e);
/* 203 */       e.printStackTrace();
/* 204 */       throw new RemoteConnectionException();
/*     */     }
/*     */ 
/* 209 */     ChatServer chatServer = new ChatServerStub(serverClient);
/*     */ 
/* 212 */     SendThread sendThread = new SendThread(chatServer, outgoingLines);
/* 213 */     sendThread.start();
/*     */ 
/* 215 */     return chatServer;
/*     */   }
/*     */ 
/*     */   public void setShuttingDown()
/*     */   {
/* 221 */     this.locallyShuttingDown = true;
/*     */   }
/*     */ 
/*     */   class ChatServerStub
/*     */     implements ChatServer
/*     */   {
/*     */     private Client serverClient;
/*     */ 
/*     */     public ChatServerStub(Client serverClient)
/*     */     {
/* 261 */       this.serverClient = serverClient;
/*     */     }
/*     */ 
/*     */     public ArrayList getBackChat() throws RemoteConnectionException, ShuttingDownException
/*     */     {
/* 266 */       RemoteInvocation invocation = new RemoteInvocation("getBackChat", null);
/*     */       try
/*     */       {
/* 270 */         return (ArrayList)this.serverClient.invoke(invocation);
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 274 */         RemoteStrategyRemoting.log.error(e);
/* 275 */       }throw new RemoteConnectionException();
/*     */     }
/*     */ 
/*     */     public ChatInfo getChatInfo()
/*     */       throws RemoteConnectionException, ShuttingDownException
/*     */     {
/* 281 */       RemoteInvocation invocation = new RemoteInvocation("getChatInfo", null);
/*     */       try
/*     */       {
/* 285 */         return (ChatInfo)this.serverClient.invoke(invocation);
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 289 */         RemoteStrategyRemoting.log.error(e);
/* 290 */       }throw new RemoteConnectionException();
/*     */     }
/*     */ 
/*     */     public void leave(ChatMember member)
/*     */       throws RemoteConnectionException, ShuttingDownException
/*     */     {
/* 296 */       RemoteInvocation invocation = new RemoteInvocation("leave", new Object[] { member });
/*     */       try
/*     */       {
/* 300 */         this.serverClient.invoke(invocation);
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 304 */         RemoteStrategyRemoting.log.error(e);
/* 305 */         throw new RemoteConnectionException();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void send(ChatMessage mesg) throws RemoteConnectionException, ShuttingDownException
/*     */     {
/* 311 */       RemoteInvocation invocation = new RemoteInvocation("send", new Object[] { mesg });
/*     */       try
/*     */       {
/* 315 */         this.serverClient.invoke(invocation);
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 319 */         RemoteStrategyRemoting.log.error(e);
/* 320 */         throw new RemoteConnectionException();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   class SendThread extends Thread
/*     */   {
/*     */     private ChatServer chatServer;
/*     */     private ReadWriteArrayList outgoingLines;
/*     */ 
/*     */     SendThread(ChatServer chatServer, ReadWriteArrayList outgoingLines)
/*     */     {
/* 232 */       this.chatServer = chatServer;
/* 233 */       this.outgoingLines = outgoingLines;
/*     */     }
/*     */ 
/*     */     public void run() {
/* 237 */       while ((!RemoteStrategyRemoting.this.locallyShuttingDown) && (!RemoteStrategyRemoting.this.remotelyShuttingDown))
/*     */         try
/*     */         {
/* 240 */           this.chatServer.send((ChatMessage)this.outgoingLines.firstElement());
/* 241 */           this.outgoingLines.remove(0);
/*     */         }
/*     */         catch (RemoteConnectionException re) {
/* 244 */           System.out.println("RemoteStrategyImpl.createChat(): unable to send next line:");
/*     */         }
/*     */         catch (ShuttingDownException sde) {
/* 247 */           System.out.println("RemoteStrategyImpl.createChat(): ChatServer is shutting down");
/* 248 */           RemoteStrategyRemoting.access$102(RemoteStrategyRemoting.this, true);
/*     */         }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.RemoteStrategyRemoting
 * JD-Core Version:    0.6.0
 */