/*     */ package org.jboss.remoting.samples.chat.client;
/*     */ 
/*     */ import java.awt.Component;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import javax.swing.SwingUtilities;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.CreateConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.JoinConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ListConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.NameInUseException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.RemoteConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.TalkConnectionException;
/*     */ import org.jboss.remoting.samples.chat.server.ChatServer;
/*     */ import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
/*     */ 
/*     */ public class LocalStrategy
/*     */   implements ConnectionStrategy, CreateConnectionStrategy, InfoConnectionStrategy, JoinConnectionStrategy, ListConnectionStrategy
/*     */ {
/*  49 */   protected static final Logger log = Logger.getLogger(LocalStrategy.class);
/*     */   private RemoteStrategy remoteStrategy;
/*     */   private CloseableFrame parent;
/*     */   private CreateFrame createFrame;
/*     */   private InfoFrame infoFrame;
/*     */   private JoinFrame joinFrame;
/*     */   private ListFrame listFrame;
/*     */   private TalkFrame talkFrame;
/*     */   private Thread readThread;
/*     */   private boolean isChatting;
/*  60 */   private ShutDownDialog shuttingDownDialog = new ShutDownDialog();
/*     */ 
/* 318 */   private Runnable shuttingDownDialogRunnable = new Runnable()
/*     */   {
/*     */     public void run()
/*     */     {
/* 322 */       LocalStrategy.this.shuttingDownDialog.show();
/*     */     }
/* 318 */   };
/*     */ 
/*     */   public LocalStrategy(CloseableFrame parent, RemoteStrategy remoteStrategy)
/*     */   {
/*  65 */     this.parent = parent;
/*  66 */     this.remoteStrategy = remoteStrategy;
/*     */   }
/*     */ 
/*     */   public void list()
/*     */   {
/*  74 */     Wrapper chatRoomDescriptions = new Wrapper();
/*     */ 
/*  76 */     Thread t = new Thread(chatRoomDescriptions) {
/*     */       private final Wrapper val$chatRoomDescriptions;
/*     */ 
/*     */       public void run() {
/*     */         try {
/*  82 */           this.val$chatRoomDescriptions.set(LocalStrategy.this.remoteStrategy.list());
/*     */         }
/*     */         catch (ShuttingDownException e)
/*     */         {
/*  86 */           SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
/*     */         }
/*     */         catch (RemoteConnectionException e)
/*     */         {
/*  90 */           LocalStrategy.log.error(e);
/*     */         }
/*     */ 
/*  93 */         Runnable r = new LocalStrategy.2(this);
/*     */ 
/* 101 */         SwingUtilities.invokeLater(r);
/*     */       }
/*     */     };
/* 105 */     t.start();
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws ConnectionException
/*     */   {
/* 111 */     this.createFrame = new CreateFrame(this, this.parent);
/* 112 */     this.createFrame.show();
/*     */   }
/*     */ 
/*     */   public void createChat(String description, ChatMember owner)
/*     */     throws CreateConnectionException
/*     */   {
/* 120 */     Thread t = new Thread(description, owner) { TalkFrame talkFrame = new TalkFrame(this.val$description, this.val$owner.get_name(), LocalStrategy.this.parent);
/* 123 */       ReadWriteArrayList outgoingLines = new ReadWriteArrayList();
/* 124 */       ChatServer chatServer = null;
/*     */       private final String val$description;
/*     */       private final ChatMember val$owner;
/*     */ 
/*     */       public void run() { try { this.chatServer = LocalStrategy.this.remoteStrategy.createChat(this.val$description, this.val$owner, this.talkFrame, this.outgoingLines);
/*     */         }
/*     */         catch (ShuttingDownException sde)
/*     */         {
/* 134 */           SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
/*     */         }
/*     */         catch (RemoteConnectionException e)
/*     */         {
/* 138 */           LocalStrategy.log.error("Cannot create chat room: " + this.val$description);
/* 139 */           LocalStrategy.log.error(e);
/*     */         }
/*     */         catch (NameInUseException e)
/*     */         {
/* 143 */           System.out.println("Pick a new name");
/*     */         }
/*     */ 
/* 146 */         Runnable r = new LocalStrategy.4(this);
/*     */ 
/* 155 */         SwingUtilities.invokeLater(r);
/*     */       }
/*     */     };
/* 159 */     t.start();
/*     */   }
/*     */ 
/*     */   public void join(ChatInfo chatInfo, ChatMember newMember)
/*     */     throws JoinConnectionException
/*     */   {
/* 167 */     Thread t = new Thread(chatInfo, newMember) { TalkFrame talkFrame = new TalkFrame(this.val$chatInfo.get_description(), this.val$newMember.get_name(), LocalStrategy.this.parent);
/* 170 */       ReadWriteArrayList outgoingLines = new ReadWriteArrayList();
/* 171 */       Wrapper remoteChatServerWrapper = new Wrapper();
/* 172 */       ChatServer chatServer = null;
/*     */       private final ChatInfo val$chatInfo;
/*     */       private final ChatMember val$newMember;
/*     */ 
/*     */       public void run() { try { this.chatServer = LocalStrategy.this.remoteStrategy.join(this.val$chatInfo.get_key(), this.val$newMember, this.talkFrame, this.outgoingLines);
/*     */         }
/*     */         catch (ShuttingDownException sde)
/*     */         {
/* 182 */           SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
/*     */         }
/*     */         catch (RemoteConnectionException e)
/*     */         {
/* 186 */           LocalStrategy.log.error("Cannot join chat room: " + this.val$chatInfo.get_description());
/* 187 */           LocalStrategy.log.error(e);
/*     */         }
/*     */         catch (NameInUseException niue)
/*     */         {
/* 191 */           System.out.println("Pick a new name");
/*     */         }
/*     */ 
/* 194 */         Runnable r = new LocalStrategy.6(this);
/*     */ 
/* 204 */         SwingUtilities.invokeLater(r);
/*     */       }
/*     */     };
/* 208 */     t.start();
/*     */   }
/*     */ 
/*     */   public void getId(ChatInfo chatInfo)
/*     */   {
/* 216 */     this.joinFrame = new JoinFrame(chatInfo, this, this.parent);
/* 217 */     this.joinFrame.show();
/*     */   }
/*     */ 
/*     */   public void getInfo(ArrayList chatInfoList, int key) throws ListConnectionException
/*     */   {
/* 222 */     this.infoFrame = new InfoFrame(this, (ChatInfo)chatInfoList.get(key), this.parent);
/* 223 */     this.infoFrame.show();
/*     */   }
/*     */ 
/*     */   public void notifyOnClose(Component c)
/*     */   {
/* 303 */     c.setVisible(false);
/*     */   }
/*     */ 
/*     */   protected boolean isChatting()
/*     */   {
/* 308 */     return this.isChatting;
/*     */   }
/*     */ 
/*     */   protected void setIsChatting(boolean b)
/*     */   {
/* 313 */     this.isChatting = b;
/*     */   }
/*     */ 
/*     */   class TalkConnectionStrategyImpl
/*     */     implements TalkConnectionStrategy
/*     */   {
/*     */     private ChatServer chatServer;
/*     */     private ChatMember member;
/*     */     private ReadWriteArrayList outgoingLines;
/*     */ 
/*     */     public TalkConnectionStrategyImpl(ChatMember member, ChatServer cs, ReadWriteArrayList outgoingLines)
/*     */     {
/* 237 */       this.chatServer = cs;
/* 238 */       this.member = member;
/* 239 */       this.outgoingLines = outgoingLines;
/*     */     }
/*     */ 
/*     */     public void send(ChatMessage message)
/*     */       throws TalkConnectionException
/*     */     {
/* 269 */       this.outgoingLines.add(message);
/*     */     }
/*     */ 
/*     */     public void leave()
/*     */     {
/* 274 */       Thread t = new LocalStrategy.7(this);
/*     */ 
/* 296 */       t.start();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.LocalStrategy
 * JD-Core Version:    0.6.0
 */