/*     */ package org.jboss.remoting.samples.chat.client;
/*     */ 
/*     */ import java.awt.Container;
/*     */ import java.awt.Font;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Date;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JTextField;
/*     */ import org.jboss.remoting.samples.chat.exceptions.JoinConnectionException;
/*     */ 
/*     */ public class JoinFrame extends CloseableFrame
/*     */ {
/*  32 */   JLabel jLabel1 = new JLabel();
/*  33 */   JTextField IDField = new JTextField();
/*  34 */   JButton OKButton = new JButton();
/*  35 */   JButton CancelButton = new JButton();
/*     */   private ChatInfo chatInfo;
/*     */   private JoinConnectionStrategy jcs;
/*  39 */   GridBagLayout gridBagLayout1 = new GridBagLayout();
/*     */ 
/*     */   public JoinFrame(ChatInfo chatInfo, JoinConnectionStrategy jcs, Closeable parent)
/*     */   {
/*  47 */     super(parent);
/*  48 */     this.chatInfo = chatInfo;
/*  49 */     this.jcs = jcs;
/*     */     try
/*     */     {
/*  52 */       jbInit();
/*     */     }
/*     */     catch (Exception e) {
/*  55 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void jbInit() throws Exception
/*     */   {
/*  61 */     this.jLabel1.setFont(new Font("SansSerif", 1, 12));
/*  62 */     this.jLabel1.setText("Your ID:");
/*  63 */     getContentPane().setLayout(this.gridBagLayout1);
/*  64 */     this.IDField.setText("");
/*  65 */     this.OKButton.setFont(new Font("SansSerif", 1, 12));
/*  66 */     this.OKButton.setText("OK");
/*  67 */     this.OKButton.addActionListener(new JoinFrame_OKButton_actionAdapter(this));
/*  68 */     this.CancelButton.setFont(new Font("SansSerif", 1, 12));
/*  69 */     this.CancelButton.setText("Cancel");
/*  70 */     this.CancelButton.addActionListener(new JoinFrame_CancelButton_actionAdapter(this));
/*  71 */     setTitle("Join a Chat Room");
/*  72 */     getContentPane().add(this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0D, 0.0D, 17, 0, new Insets(96, 82, 0, 0), 22, 5));
/*     */ 
/*  74 */     getContentPane().add(this.IDField, new GridBagConstraints(1, 0, 2, 1, 1.0D, 0.0D, 17, 2, new Insets(96, 0, 0, 39), 215, 0));
/*     */ 
/*  76 */     getContentPane().add(this.CancelButton, new GridBagConstraints(2, 1, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(47, 16, 43, 139), 0, 0));
/*     */ 
/*  78 */     getContentPane().add(this.OKButton, new GridBagConstraints(0, 1, 2, 1, 0.0D, 0.0D, 10, 0, new Insets(49, 108, 43, 0), 22, 0));
/*     */ 
/*  81 */     pack();
/*  82 */     center();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/*  90 */       ChatMember chatMember = new ChatMember();
/*  91 */       chatMember.set_name("xyz");
/*  92 */       ChatInfo chatInfo = new ChatInfo();
/*  93 */       chatInfo.set_currentMembers(3);
/*  94 */       chatInfo.set_description("abc");
/*  95 */       chatInfo.set_origin(new Date());
/*  96 */       JoinFrame joinFrame = new JoinFrame(chatInfo, new DummyJoinConnectionStrategy(), null);
/*     */ 
/* 100 */       joinFrame.show();
/*     */     }
/*     */     catch (JoinConnectionException ce)
/*     */     {
/* 104 */       System.out.println("unable to create chat frame");
/*     */     }
/*     */   }
/*     */ 
/*     */   void OKButton_actionPerformed(ActionEvent e)
/*     */   {
/*     */     try {
/* 111 */       notifyOnClose(this);
/* 112 */       ChatMember chatMember = new ChatMember();
/* 113 */       chatMember.set_name(this.IDField.getText());
/* 114 */       this.jcs.join(this.chatInfo, chatMember);
/*     */     }
/*     */     catch (JoinConnectionException jce)
/*     */     {
/* 118 */       System.out.println("OK button catches exception:");
/* 119 */       System.out.println(jce);
/*     */     }
/*     */   }
/*     */ 
/*     */   void CancelButton_actionPerformed(ActionEvent e) {
/* 124 */     notifyOnClose(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.JoinFrame
 * JD-Core Version:    0.6.0
 */