/*     */ package org.jboss.remoting.samples.callback;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class CallbackClient
/*     */ {
/*  45 */   private static String transport = "socket";
/*  46 */   private static String host = "localhost";
/*  47 */   private static int port = 5400;
/*     */   private Client remotingClient;
/*     */   private Connector callbackServerConnector;
/*     */ 
/*     */   public void createRemotingClient(String locatorURI)
/*     */     throws Exception
/*     */   {
/*  62 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  63 */     System.out.println("Calling remoting server with locator uri of: " + locatorURI);
/*     */ 
/*  65 */     this.remotingClient = new Client(locator);
/*  66 */     this.remotingClient.connect();
/*     */   }
/*     */ 
/*     */   public void makeInvocation()
/*     */     throws Throwable
/*     */   {
/*  76 */     Object response = this.remotingClient.invoke("Do something", null);
/*  77 */     System.out.println("Invocation response: " + response);
/*     */   }
/*     */ 
/*     */   public void testPullCallback()
/*     */     throws Throwable
/*     */   {
/*  90 */     CallbackHandler callbackHandler = new CallbackHandler();
/*     */ 
/*  92 */     this.remotingClient.addListener(callbackHandler);
/*     */ 
/*  96 */     Thread.currentThread(); Thread.sleep(2000L);
/*     */ 
/*  99 */     makeInvocation();
/*     */ 
/* 102 */     List callbacks = this.remotingClient.getCallbacks(callbackHandler);
/* 103 */     Iterator itr = callbacks.iterator();
/* 104 */     while (itr.hasNext())
/*     */     {
/* 106 */       Callback callbackObject = (Callback)itr.next();
/* 107 */       System.out.println("Pull Callback value = " + callbackObject.getCallbackObject());
/*     */     }
/*     */ 
/* 111 */     this.remotingClient.removeListener(callbackHandler);
/*     */   }
/*     */ 
/*     */   public void testPushCallback()
/*     */     throws Throwable
/*     */   {
/* 124 */     String callbackLocatorURI = transport + "://" + host + ":" + (port + 1);
/* 125 */     InvokerLocator callbackLocator = new InvokerLocator(callbackLocatorURI);
/*     */ 
/* 129 */     setupServer(callbackLocator);
/*     */ 
/* 131 */     CallbackHandler callbackHandler = new CallbackHandler();
/*     */ 
/* 134 */     String callbackHandleObject = "myCallbackHandleObject";
/*     */ 
/* 138 */     this.remotingClient.addListener(callbackHandler, callbackLocator, callbackHandleObject);
/*     */ 
/* 141 */     Thread.sleep(2000L);
/*     */ 
/* 144 */     this.remotingClient.removeListener(callbackHandler);
/*     */ 
/* 147 */     this.callbackServerConnector.stop();
/* 148 */     this.callbackServerConnector.destroy();
/*     */   }
/*     */ 
/*     */   public void setupServer(InvokerLocator locator)
/*     */     throws Exception
/*     */   {
/* 160 */     System.out.println("Starting remoting server with locator uri of: " + locator);
/* 161 */     this.callbackServerConnector = new Connector();
/* 162 */     this.callbackServerConnector.setInvokerLocator(locator.getLocatorURI());
/* 163 */     this.callbackServerConnector.start();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 175 */     if ((args != null) && (args.length == 2))
/*     */     {
/* 177 */       transport = args[0];
/* 178 */       port = Integer.parseInt(args[1]);
/*     */     }
/* 180 */     String locatorURI = transport + "://" + host + ":" + port;
/* 181 */     CallbackClient client = new CallbackClient();
/*     */     try
/*     */     {
/* 184 */       client.createRemotingClient(locatorURI);
/*     */ 
/* 187 */       client.testPullCallback();
/*     */ 
/* 190 */       client.testPushCallback();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 194 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public class CallbackHandler
/*     */     implements InvokerCallbackHandler
/*     */   {
/*     */     public CallbackHandler()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void handleCallback(Callback callback)
/*     */       throws HandleCallbackException
/*     */     {
/* 213 */       System.out.println("Received push callback.");
/* 214 */       System.out.println("Received callback value of: " + callback.getCallbackObject());
/* 215 */       System.out.println("Received callback handle object of: " + callback.getCallbackHandleObject());
/* 216 */       System.out.println("Received callback server invoker of: " + callback.getServerLocator());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.callback.CallbackClient
 * JD-Core Version:    0.6.0
 */