/*     */ package org.jboss.remoting.marshal.serializable;
/*     */ 
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.util.Map;
/*     */ import org.jboss.remoting.Version;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.PreferredStreamMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ 
/*     */ public class SerializableMarshaller
/*     */   implements PreferredStreamMarshaller, VersionedMarshaller
/*     */ {
/*     */   static final long serialVersionUID = -5553685435323600244L;
/*     */   public static final String DATATYPE = "serializable";
/*     */   String serializationType;
/*     */ 
/*     */   public void setSerializationType(String serializationType)
/*     */   {
/*  55 */     this.serializationType = serializationType;
/*     */   }
/*     */ 
/*     */   public String getSerializationType()
/*     */   {
/*  60 */     if (this.serializationType == null)
/*     */     {
/*  62 */       return "java";
/*     */     }
/*     */ 
/*  66 */     return this.serializationType;
/*     */   }
/*     */ 
/*     */   public OutputStream getMarshallingStream(OutputStream outputStream)
/*     */     throws IOException
/*     */   {
/*  72 */     return getMarshallingStream(outputStream, null);
/*     */   }
/*     */ 
/*     */   public OutputStream getMarshallingStream(OutputStream outputStream, Map config)
/*     */     throws IOException
/*     */   {
/*  81 */     if ((outputStream instanceof ObjectOutputStream))
/*     */     {
/*  83 */       return outputStream;
/*     */     }
/*     */ 
/*  87 */     BufferedOutputStream bos = new BufferedOutputStream(outputStream);
/*  88 */     SerializationManager manager = SerializationStreamFactory.getManagerInstance(getSerializationType());
/*  89 */     ObjectOutputStream oos = manager.createOutput(bos);
/*  90 */     oos.flush();
/*  91 */     return oos;
/*     */   }
/*     */ 
/*     */   public void write(Object dataObject, OutputStream output)
/*     */     throws IOException
/*     */   {
/* 105 */     int version = Version.getDefaultVersion();
/* 106 */     write(dataObject, output, version);
/*     */   }
/*     */ 
/*     */   public void write(Object dataObject, OutputStream output, int version)
/*     */     throws IOException
/*     */   {
/* 119 */     ObjectOutputStream oos = (ObjectOutputStream)getMarshallingStream(output, null);
/* 120 */     SerializationStreamFactory.getManagerInstance(getSerializationType()).sendObject(oos, dataObject, version);
/*     */   }
/*     */ 
/*     */   public Marshaller cloneMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 126 */     return new SerializableMarshaller();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.serializable.SerializableMarshaller
 * JD-Core Version:    0.6.0
 */