/*     */ package org.jboss.remoting.marshal.encryption;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.security.Key;
/*     */ import java.util.Map;
/*     */ import javax.crypto.Cipher;
/*     */ import javax.crypto.spec.IvParameterSpec;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class EncryptionManager
/*     */ {
/*  55 */   private static Logger log = Logger.getLogger(EncryptionManager.class);
/*  56 */   private static Map keys = new ConcurrentHashMap();
/*     */ 
/*  58 */   private static byte[] salt8 = { 126, -18, -56, -57, -103, 115, 33, -116 };
/*     */ 
/*  62 */   private static byte[] salt16 = { 126, -18, -56, -57, -103, 115, 33, -116, 126, -18, -56, -57, -103, 115, 33, -116 };
/*     */ 
/*  68 */   private static IvParameterSpec iv8 = new IvParameterSpec(salt8);
/*     */ 
/*  70 */   private static IvParameterSpec iv16 = new IvParameterSpec(salt16);
/*     */   public static final String TRIPLEDES = "DESede";
/*     */   public static final String DES = "DES";
/*     */   public static final String AES = "AES";
/*     */   public static final String BLOWFISH = "Blowfish";
/*     */   public static final String RC4 = "RC4";
/*     */   public static final String DEFAULT_CIPHER_ALGORITHM = "DES";
/*     */ 
/*     */   public static Cipher getCipher(int mode, String algo)
/*     */   {
/* 107 */     if (algo == null)
/* 108 */       algo = "DES";
/* 109 */     Cipher cipher = null;
/* 110 */     boolean correctMode = (mode == 1) || (mode == 2);
/*     */ 
/* 112 */     if (!correctMode) {
/* 113 */       throw new IllegalArgumentException("Cipher Mode is wrong");
/*     */     }
/*     */     try
/*     */     {
/* 117 */       cipher = Cipher.getInstance(algo);
/* 118 */       Key key = (Key)keys.get(canonicalize(algo));
/* 119 */       if (key == null)
/* 120 */         throw new IllegalStateException("Key is null for algo=" + algo);
/* 121 */       initializeCipher(cipher, key, algo, mode);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 125 */       log.error("getCipher failed", e);
/*     */     }
/* 127 */     return cipher;
/*     */   }
/*     */ 
/*     */   public static Cipher getCipher(int mode, String algo, Key key)
/*     */   {
/* 140 */     Cipher cipher = null;
/* 141 */     boolean correctMode = (mode == 1) || (mode == 2);
/*     */ 
/* 143 */     if (!correctMode) {
/* 144 */       throw new IllegalArgumentException("Cipher Mode is wrong");
/*     */     }
/*     */     try
/*     */     {
/* 148 */       cipher = Cipher.getInstance(algo);
/* 149 */       initializeCipher(cipher, key, algo, mode);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 153 */       if (log.isTraceEnabled())
/* 154 */         log.trace("getCipher failed:", e);
/*     */     }
/* 156 */     return cipher;
/*     */   }
/*     */ 
/*     */   private static Key loadKey(String algo)
/*     */     throws Exception
/*     */   {
/* 167 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 168 */     String file = "org/jboss/remoting/marshall/encryption/" + algo + ".key";
/* 169 */     InputStream is = tcl.getResourceAsStream(file);
/* 170 */     if (is == null)
/* 171 */       throw new IllegalStateException("Key file is not locatable");
/* 172 */     ObjectInput out = new ObjectInputStream(is);
/* 173 */     Key key = (Key)out.readObject();
/* 174 */     out.close();
/* 175 */     return key;
/*     */   }
/*     */ 
/*     */   private static String canonicalize(String algo)
/*     */   {
/* 181 */     if (algo == null)
/* 182 */       throw new IllegalArgumentException("Null algorithm passed");
/* 183 */     String result = algo;
/* 184 */     if (algo.indexOf("/") > 0)
/*     */     {
/* 186 */       result = algo.substring(0, algo.indexOf("/"));
/*     */     }
/* 188 */     return result;
/*     */   }
/*     */ 
/*     */   private static void initializeCipher(Cipher cipher, Key key, String algo, int mode)
/*     */     throws Exception
/*     */   {
/* 203 */     if ((algo.equals("AES")) || (algo.equals("DES")) || (algo.equals("DESede")) || (algo.equals("RC4")) || (algo.equals("Blowfish")))
/*     */     {
/* 205 */       cipher.init(mode, key);
/*     */     }
/* 207 */     else if ((algo.indexOf("AES") == 0) && (algo.indexOf("AES/ECB") < 0)) {
/* 208 */       cipher.init(mode, key, iv16);
/*     */     }
/* 210 */     else if ((algo.indexOf("/CBC/") > 0) || (algo.indexOf("/OFB/") > 0) || (algo.indexOf("/PCBC/") > 0) || (algo.indexOf("/CFB/") > 0))
/*     */     {
/* 212 */       cipher.init(mode, key, iv8);
/*     */     }
/* 214 */     else cipher.init(mode, key);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  86 */       keys.put("AES", loadKey("AES"));
/*  87 */       keys.put("DES", loadKey("DES"));
/*  88 */       keys.put("DESede", loadKey("DESede"));
/*  89 */       keys.put("Blowfish", loadKey("Blowfish"));
/*  90 */       keys.put("RC4", loadKey("RC4"));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  94 */       if (log.isTraceEnabled())
/*  95 */         log.trace("Exception in loading key", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.encryption.EncryptionManager
 * JD-Core Version:    0.6.0
 */