/*     */ package org.jboss.remoting.marshal.compress;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.util.Map;
/*     */ import java.util.zip.GZIPInputStream;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.remoting.marshal.VersionedUnMarshaller;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ 
/*     */ public class CompressingUnMarshaller extends SerializableUnMarshaller
/*     */ {
/*     */   public static final String DATATYPE = "compressible";
/*     */   private UnMarshaller wrappedUnMarshaller;
/*     */   private static final long serialVersionUID = 3843451434770746776L;
/*     */ 
/*     */   public CompressingUnMarshaller()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CompressingUnMarshaller(UnMarshaller unMarshaller)
/*     */   {
/*  81 */     this.wrappedUnMarshaller = unMarshaller;
/*     */   }
/*     */ 
/*     */   public Object read(InputStream inputStream, Map metadata, int version)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  97 */     GZIPInputStream gzis = new GZIPInputStream(inputStream);
/*  98 */     ObjectInputStream ois = SerializationStreamFactory.getManagerInstance(getSerializationType()).createRegularInput(gzis);
/*     */ 
/* 100 */     if (this.wrappedUnMarshaller != null)
/*     */     {
/* 102 */       if ((this.wrappedUnMarshaller instanceof VersionedUnMarshaller)) {
/* 103 */         return ((VersionedUnMarshaller)this.wrappedUnMarshaller).read(ois, metadata, version);
/*     */       }
/* 105 */       return this.wrappedUnMarshaller.read(ois, metadata);
/*     */     }
/*     */ 
/* 109 */     return super.read(ois, metadata, version);
/*     */   }
/*     */ 
/*     */   public UnMarshaller cloneUnMarshaller()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 122 */     return new CompressingUnMarshaller(this.wrappedUnMarshaller);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.marshal.compress.CompressingUnMarshaller
 * JD-Core Version:    0.6.0
 */