/*    */ package org.jboss.remoting.loading;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*    */ 
/*    */ public class RemotingClassLoader extends ClassLoader
/*    */ {
/* 33 */   private ClassLoader userClassLoader = null;
/*    */ 
/* 35 */   protected static final Logger log = Logger.getLogger(RemotingClassLoader.class);
/* 36 */   protected static final boolean isTrace = log.isTraceEnabled();
/*    */ 
/*    */   public RemotingClassLoader(ClassLoader remotingClassLoader, ClassLoader userClassLoader)
/*    */   {
/* 40 */     super(remotingClassLoader);
/* 41 */     this.userClassLoader = userClassLoader;
/*    */   }
/*    */ 
/*    */   public Class loadClass(String name) throws ClassNotFoundException
/*    */   {
/* 46 */     Class loadedClass = null;
/*    */     try
/*    */     {
/* 50 */       loadedClass = Class.forName(name, false, getParent());
/*    */     }
/*    */     catch (ClassNotFoundException e)
/*    */     {
/* 54 */       if (isTrace)
/*    */       {
/* 56 */         log.trace("Could not load class (" + name + ") using parent remoting class loader (" + getParent() + ")");
/*    */       }
/* 58 */       if (this.userClassLoader != null)
/*    */       {
/*    */         try
/*    */         {
/* 62 */           loadedClass = Class.forName(name, false, this.userClassLoader);
/*    */         }
/*    */         catch (ClassNotFoundException e1)
/*    */         {
/* 66 */           if (isTrace)
/*    */           {
/* 68 */             log.trace("Could not load class (" + name + ") using parent remoting class loader (" + getParent() + ")");
/*    */           }
/*    */         }
/*    */       }
/*    */     }
/*    */ 
/* 74 */     if (loadedClass == null)
/*    */     {
/* 76 */       loadedClass = ClassLoaderUtility.loadClass(name, getClass());
/*    */     }
/*    */ 
/* 79 */     return loadedClass;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.loading.RemotingClassLoader
 * JD-Core Version:    0.6.0
 */