/*    */ package org.jboss.remoting.invocation;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ 
/*    */ public class NameBasedInvocation extends RemoteInvocation
/*    */ {
/*    */   static final long serialVersionUID = -6507163932605308471L;
/*    */   private final String[] sig;
/*    */ 
/*    */   public NameBasedInvocation(Method method, Object[] params)
/*    */   {
/* 47 */     super(method.getName(), params);
/* 48 */     this.sig = generateSignatureFromMethod(method);
/*    */   }
/*    */ 
/*    */   private String[] generateSignatureFromMethod(Method method)
/*    */   {
/* 53 */     Class[] parameterTypes = method.getParameterTypes();
/* 54 */     String[] signature = new String[parameterTypes.length];
/* 55 */     for (int i = 0; i < parameterTypes.length; i++)
/*    */     {
/* 57 */       Class parameterType = parameterTypes[i];
/* 58 */       signature[i] = parameterType.getName();
/*    */     }
/* 60 */     return signature;
/*    */   }
/*    */ 
/*    */   public NameBasedInvocation(String methodName, Object[] params, String[] sig)
/*    */   {
/* 65 */     super(methodName, params);
/* 66 */     this.sig = sig;
/*    */   }
/*    */ 
/*    */   public String[] getSignature()
/*    */   {
/* 71 */     return this.sig;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 76 */     return "NameBasedInvocation[" + this.methodName + "]";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.invocation.NameBasedInvocation
 * JD-Core Version:    0.6.0
 */