/*     */ package org.jboss.remoting.detection.multicast;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InvalidClassException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.net.DatagramPacket;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.MulticastSocket;
/*     */ import java.net.SocketAddress;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.detection.AbstractDetector;
/*     */ import org.jboss.remoting.detection.Detection;
/*     */ 
/*     */ public class MulticastDetector extends AbstractDetector
/*     */   implements MulticastDetectorMBean
/*     */ {
/*  49 */   private static int threadCounter = 0;
/*     */   private String defaultIP;
/*     */   private InetAddress addr;
/*     */   private InetAddress bindAddr;
/*     */   private int port;
/*     */   private MulticastSocket socket;
/*     */   private Listener listener;
/*     */ 
/*     */   public MulticastDetector()
/*     */   {
/*  51 */     this.defaultIP = "224.1.9.1";
/*     */ 
/*  55 */     this.port = 2410;
/*     */ 
/*  57 */     this.listener = new Listener("Remoting Multicast Detector - Listener Thread: " + threadCounter++);
/*     */   }
/*     */ 
/*     */   public String getDefaultIP()
/*     */   {
/*  65 */     return this.defaultIP;
/*     */   }
/*     */ 
/*     */   public void setDefaultIP(String defaultIP)
/*     */   {
/*  73 */     this.defaultIP = defaultIP;
/*     */   }
/*     */ 
/*     */   public InetAddress getAddress()
/*     */   {
/*  83 */     return this.addr;
/*     */   }
/*     */ 
/*     */   public void setAddress(InetAddress ip)
/*     */   {
/*  93 */     this.addr = ip;
/*     */   }
/*     */ 
/*     */   public InetAddress getBindAddress()
/*     */   {
/* 103 */     return this.bindAddr;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(InetAddress ip)
/*     */   {
/* 113 */     this.bindAddr = ip;
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 123 */     return this.port;
/*     */   }
/*     */ 
/*     */   public void setPort(int port)
/*     */   {
/* 133 */     this.port = port;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 143 */     if (this.addr == null)
/*     */     {
/* 145 */       this.addr = InetAddress.getByName(this.defaultIP);
/*     */     }
/*     */ 
/* 148 */     InetAddress localHost = InetAddress.getLocalHost();
/* 149 */     if ((this.bindAddr == null) && (localHost.getHostAddress().equals("127.0.0.1")))
/*     */     {
/* 152 */       this.bindAddr = localHost;
/*     */     }
/* 154 */     SocketAddress saddr = new InetSocketAddress(this.bindAddr, this.port);
/* 155 */     this.socket = new MulticastSocket(saddr);
/* 156 */     this.socket.joinGroup(this.addr);
/*     */ 
/* 158 */     super.start();
/*     */ 
/* 160 */     if (this.listener == null)
/*     */     {
/* 162 */       this.listener = new Listener("Remoting Multicast Detector - Listener Thread: " + threadCounter++);
/*     */     }
/* 164 */     this.listener.start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 174 */     super.stop();
/* 175 */     if (this.listener != null)
/*     */     {
/*     */       try
/*     */       {
/* 179 */         this.listener.running = false;
/* 180 */         this.listener.interrupt();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 185 */         this.log.warn("Error stopping multicast detector.  " + e.getMessage());
/*     */       }
/* 187 */       this.listener = null;
/*     */     }
/* 189 */     if (this.socket != null)
/*     */     {
/*     */       try
/*     */       {
/* 193 */         this.socket.leaveGroup(this.addr);
/* 194 */         this.socket.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 198 */         this.log.warn("Error stopping multicast detector.  " + e.getMessage());
/*     */       }
/* 200 */       this.socket = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void heartbeat()
/*     */   {
/* 210 */     if (this.socket != null)
/*     */     {
/* 212 */       Detection msg = createDetection();
/*     */       try
/*     */       {
/* 215 */         if (this.log.isTraceEnabled())
/*     */         {
/* 217 */           this.log.trace("sending heartbeat: " + msg);
/*     */         }
/* 219 */         ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
/* 220 */         ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
/* 221 */         objectOut.writeObject(msg);
/* 222 */         objectOut.flush();
/* 223 */         byteOut.flush();
/* 224 */         byte[] buf = byteOut.toByteArray();
/* 225 */         DatagramPacket p = new DatagramPacket(buf, buf.length, this.addr, this.port);
/* 226 */         this.socket.send(p);
/*     */       }
/*     */       catch (Throwable ex)
/*     */       {
/* 231 */         this.log.debug("heartbeat failed", ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void forceHeartbeat()
/*     */   {
/* 238 */     if (this.socket != null)
/*     */     {
/* 240 */       String msg = "Send heartbeat";
/*     */       try
/*     */       {
/* 243 */         ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
/* 244 */         ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
/* 245 */         objectOut.writeObject(msg);
/* 246 */         objectOut.flush();
/* 247 */         byteOut.flush();
/* 248 */         byte[] buf = byteOut.toByteArray();
/* 249 */         DatagramPacket p = new DatagramPacket(buf, buf.length, this.addr, this.port);
/* 250 */         this.socket.send(p);
/*     */ 
/* 260 */         Thread.currentThread(); Thread.sleep(2000L);
/*     */       }
/*     */       catch (Throwable ex)
/*     */       {
/* 266 */         this.log.debug("forced heartbeat failed", ex);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void listen(DatagramPacket p, byte[] buf)
/*     */   {
/* 273 */     if (this.socket != null)
/*     */     {
/*     */       try
/*     */       {
/* 278 */         this.socket.receive(p);
/*     */ 
/* 281 */         ByteArrayInputStream byteInput = new ByteArrayInputStream(buf);
/* 282 */         ObjectInputStream objectInput = new ObjectInputStream(byteInput);
/* 283 */         Object obj = objectInput.readObject();
/* 284 */         if ((obj instanceof Detection))
/*     */         {
/* 286 */           Detection msg = (Detection)obj;
/* 287 */           if (this.log.isTraceEnabled())
/*     */           {
/* 289 */             this.log.trace("received detection: " + msg);
/*     */           }
/*     */ 
/* 293 */           detect(msg);
/*     */         }
/*     */         else
/*     */         {
/* 299 */           heartbeat();
/*     */         }
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 304 */         if ((e instanceof InvalidClassException))
/*     */         {
/* 306 */           return;
/*     */         }
/* 308 */         if (this.socket != null)
/*     */         {
/* 310 */           this.log.debug("Error receiving detection", e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class Listener extends Thread
/*     */   {
/* 318 */     boolean running = true;
/*     */ 
/*     */     public Listener(String name)
/*     */     {
/* 322 */       super();
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 327 */       byte[] buf = new byte[4000];
/* 328 */       DatagramPacket p = new DatagramPacket(buf, 0, buf.length);
/*     */ 
/* 331 */       while (this.running)
/*     */       {
/* 333 */         MulticastDetector.this.listen(p, buf);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.detection.multicast.MulticastDetector
 * JD-Core Version:    0.6.0
 */