/*     */ package org.jboss.remoting.detection;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ident.Identity;
/*     */ 
/*     */ public class Detection
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = -7560953564286960592L;
/*     */   private final ServerInvokerMetadata[] serverInvokers;
/*     */   private final Identity identity;
/*     */   private final int hashCode;
/*     */ 
/*     */   public Detection(Identity identity, ServerInvokerMetadata[] serverInvokers)
/*     */   {
/*  46 */     this.serverInvokers = serverInvokers;
/*  47 */     this.identity = identity;
/*  48 */     this.hashCode = identity.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  53 */     if ((obj instanceof Detection))
/*     */     {
/*  55 */       return this.hashCode == obj.hashCode();
/*     */     }
/*  57 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  62 */     return this.hashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  67 */     String serverInvokersInfo = "";
/*  68 */     if (this.serverInvokers != null)
/*     */     {
/*  70 */       for (int x = 0; x < this.serverInvokers.length; x++)
/*     */       {
/*  72 */         serverInvokersInfo = serverInvokersInfo + this.serverInvokers[x] + "\n";
/*     */       }
/*  74 */       serverInvokersInfo = serverInvokersInfo.substring(0, serverInvokersInfo.length());
/*     */     }
/*     */ 
/*  77 */     return "Detection (" + super.toString() + ")\n\tidentity:" + this.identity + "\n\tlocators:" + (this.serverInvokers == null ? " null" : serverInvokersInfo);
/*     */   }
/*     */ 
/*     */   public final Identity getIdentity()
/*     */   {
/*  87 */     return this.identity;
/*     */   }
/*     */ 
/*     */   public final InvokerLocator[] getLocators()
/*     */   {
/*  97 */     InvokerLocator[] locators = new InvokerLocator[this.serverInvokers == null ? 0 : this.serverInvokers.length];
/*  98 */     for (int x = 0; x < this.serverInvokers.length; x++)
/*     */     {
/* 100 */       locators[x] = this.serverInvokers[x].getInvokerLocator();
/*     */     }
/* 102 */     return locators;
/*     */   }
/*     */ 
/*     */   public final ServerInvokerMetadata[] getServerInvokers()
/*     */   {
/* 114 */     return this.serverInvokers;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.detection.Detection
 * JD-Core Version:    0.6.0
 */