/*      */ package org.jboss.remoting.callback;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.MBeanServerInvocationHandler;
/*      */ import javax.management.MalformedObjectNameException;
/*      */ import javax.management.ObjectName;
/*      */ import javax.net.SocketFactory;
/*      */ import javax.net.ssl.SSLServerSocketFactory;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.remoting.Client;
/*      */ import org.jboss.remoting.InvocationRequest;
/*      */ import org.jboss.remoting.InvokerLocator;
/*      */ import org.jboss.remoting.SerializableStore;
/*      */ import org.jboss.remoting.ServerInvoker;
/*      */ import org.jboss.remoting.invocation.InternalInvocation;
/*      */ import org.jboss.remoting.security.SSLServerSocketFactoryServiceMBean;
/*      */ import org.jboss.remoting.security.SSLSocketBuilder;
/*      */ import org.jboss.remoting.security.SSLSocketBuilderMBean;
/*      */ import org.jboss.remoting.security.SSLSocketFactoryService;
/*      */ 
/*      */ public class ServerInvokerCallbackHandler
/*      */   implements AsynchInvokerCallbackHandler
/*      */ {
/*   65 */   private static final Logger log = Logger.getLogger(ServerInvokerCallbackHandler.class);
/*      */ 
/*   67 */   private static boolean trace = log.isTraceEnabled();
/*      */   private InvocationRequest invocation;
/*      */   private Client callBackClient;
/*   71 */   private ArrayList callbacks = new ArrayList();
/*      */   private String sessionId;
/*      */   private String listenerId;
/*      */   private String clientSessionId;
/*      */   private InvokerLocator serverLocator;
/*   76 */   private int blockingTimeout = 5000;
/*      */ 
/*   79 */   private SerializableStore callbackStore = null;
/*   80 */   private CallbackErrorHandler callbackErrorHandler = null;
/*      */   public static final String CALLBACK_STORE_KEY = "callbackStore";
/*      */   public static final String CALLBACK_ERROR_HANDLER_KEY = "callbackErrorHandler";
/*      */   public static final String CALLBACK_MEM_CEILING = "callbackMemCeiling";
/*      */   public static final String CALLBACK_LISTENER = "callbackListener";
/*      */   public static final String REMOTING_ACKNOWLEDGES_PUSH_CALLBACKS = "remotingAcknowledgesPushCallbacks";
/*      */   public static final String CALLBACK_ID = "callbackId";
/*      */   public static final String CALLBACK_TIMEOUT = "callbackTimeout";
/*  127 */   private double memPercentCeiling = 20.0D;
/*      */ 
/*  132 */   private Map idToListenerMap = Collections.synchronizedMap(new HashMap());
/*      */ 
/*      */   public ServerInvokerCallbackHandler(InvocationRequest invocation, InvokerLocator serverLocator, ServerInvoker owner)
/*      */     throws Exception
/*      */   {
/*  138 */     if (invocation == null)
/*      */     {
/*  140 */       throw new Exception("Can not construct ServerInvokerCallbackHandler with null InvocationRequest.");
/*      */     }
/*  142 */     this.invocation = invocation;
/*  143 */     this.serverLocator = serverLocator;
/*  144 */     init(invocation, owner);
/*      */   }
/*      */ 
/*      */   public void connect() throws Exception
/*      */   {
/*  149 */     if (this.callBackClient != null)
/*      */     {
/*  151 */       if (this.callBackClient.isConnected())
/*  152 */         return;
/*  153 */       this.callBackClient.connect();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void init(InvocationRequest invocation, ServerInvoker owner)
/*      */     throws Exception
/*      */   {
/*  160 */     this.clientSessionId = invocation.getSessionId();
/*  161 */     this.sessionId = invocation.getSessionId();
/*      */ 
/*  163 */     Map metadata = null;
/*  164 */     if (owner.getConfiguration() == null)
/*      */     {
/*  166 */       metadata = new HashMap();
/*      */     }
/*      */     else
/*      */     {
/*  170 */       metadata = new HashMap(owner.getConfiguration());
/*      */     }
/*  172 */     if (invocation.getRequestPayload() != null)
/*      */     {
/*  174 */       metadata.putAll(invocation.getRequestPayload());
/*      */     }
/*      */ 
/*  177 */     this.listenerId = ((String)metadata.get("listenerId"));
/*  178 */     if (this.listenerId != null)
/*      */     {
/*  180 */       this.sessionId = (this.sessionId + "+" + this.listenerId);
/*      */     }
/*  182 */     log.debug("Session id for callback handler is " + this.sessionId);
/*      */ 
/*  184 */     if (invocation.getLocator() != null)
/*      */     {
/*  186 */       Object val = metadata.get("callbackTimeout");
/*  187 */       if ((val instanceof String))
/*      */       {
/*      */         try
/*      */         {
/*  191 */           Integer.parseInt((String)val);
/*  192 */           metadata.put("timeout", val);
/*  193 */           log.debug(this + " using callbackTimeout value " + val);
/*      */         }
/*      */         catch (NumberFormatException e)
/*      */         {
/*  197 */           log.warn("callbackTimeout value must have valid numeric format: " + val);
/*      */         }
/*      */       }
/*  200 */       else if (val != null)
/*      */       {
/*  202 */         log.warn("callbackTimeout value must be a String: " + val);
/*      */       }
/*      */ 
/*  206 */       configureSocketFactory(metadata, owner);
/*      */ 
/*  208 */       this.callBackClient = new Client(invocation.getLocator(), invocation.getSubsystem(), metadata);
/*  209 */       createCallbackErrorHandler(owner, invocation.getSubsystem());
/*      */     }
/*      */     else
/*      */     {
/*  213 */       createCallbackStore(owner, this.sessionId);
/*      */     }
/*      */ 
/*  216 */     Object val = metadata.get("blockingTimeout");
/*  217 */     if (val != null)
/*      */     {
/*  219 */       if ((val instanceof String))
/*      */       {
/*      */         try
/*      */         {
/*  223 */           this.blockingTimeout = Integer.parseInt((String)val);
/*      */         }
/*      */         catch (NumberFormatException e)
/*      */         {
/*  227 */           log.warn("Error converting blockingTimeout to type long.  " + e.getMessage());
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  232 */         log.warn("Value for blockingTimeout configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void configureSocketFactory(Map clientConfig, ServerInvoker serverInvoker)
/*      */     throws Exception
/*      */   {
/*  248 */     if (serverInvoker.getSocketFactory() != null)
/*      */     {
/*  250 */       clientConfig.put("customSocketFactory", serverInvoker.getSocketFactory());
/*  251 */       return;
/*      */     }
/*      */ 
/*  254 */     if (clientConfig == null) {
/*  255 */       clientConfig = new HashMap();
/*      */     }
/*      */ 
/*  259 */     if (clientConfig.containsKey("customSocketFactory"))
/*      */     {
/*  261 */       serverInvoker.setSocketFactory((SocketFactory)clientConfig.get("customSocketFactory"));
/*  262 */       return;
/*      */     }
/*      */ 
/*  269 */     String serverSocketFactoryString = (String)clientConfig.get("serverSocketFactory");
/*  270 */     if ((serverSocketFactoryString != null) && (serverSocketFactoryString.length() > 0))
/*      */     {
/*  272 */       MBeanServer server = serverInvoker.getMBeanServer();
/*      */       try
/*      */       {
/*  275 */         ObjectName serverSocketFactoryObjName = new ObjectName(serverSocketFactoryString);
/*  276 */         if (server != null)
/*      */         {
/*  278 */           boolean isCorrectType = server.isInstanceOf(serverSocketFactoryObjName, SSLServerSocketFactoryServiceMBean.class.getName());
/*  279 */           if (isCorrectType)
/*      */           {
/*  281 */             SSLSocketBuilderMBean sslSocketBuilder = (SSLSocketBuilderMBean)server.getAttribute(serverSocketFactoryObjName, "SSLSocketBuilder");
/*      */ 
/*  283 */             if (sslSocketBuilder != null)
/*      */             {
/*  285 */               SSLSocketBuilder clonedSSLSocketBuilder = (SSLSocketBuilder)sslSocketBuilder.clone();
/*  286 */               boolean shouldUseDefault = sslSocketBuilder.getUseSSLServerSocketFactory();
/*  287 */               clonedSSLSocketBuilder.setUseSSLSocketFactory(shouldUseDefault);
/*  288 */               boolean useClientMode = sslSocketBuilder.isServerSocketUseClientMode();
/*  289 */               clonedSSLSocketBuilder.setSocketUseClientMode(useClientMode);
/*  290 */               SSLSocketFactoryService sslSocketFactoryService = new SSLSocketFactoryService();
/*  291 */               sslSocketFactoryService.setSSLSocketBuilder(clonedSSLSocketBuilder);
/*  292 */               sslSocketFactoryService.start();
/*  293 */               clientConfig.put("customSocketFactory", sslSocketFactoryService);
/*  294 */               clientConfig.put("org.jboss.remoting.socket.useClientMode", "false");
/*      */ 
/*  296 */               clientConfig.put("hostnameVerifier", "org.jboss.test.remoting.transport.http.ssl.config.SelfIdentifyingHostnameVerifier");
/*  297 */               serverInvoker.setSocketFactory(sslSocketFactoryService);
/*  298 */               return;
/*      */             }
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (MalformedObjectNameException ignored)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  311 */     if ((serverInvoker.getServerSocketFactory() instanceof SSLServerSocketFactory))
/*      */     {
/*  313 */       if (!clientConfig.containsKey("org.jboss.remoting.socket.useClientMode"))
/*  314 */         clientConfig.put("org.jboss.remoting.socket.useClientMode", "false");
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getCallbackSessionId()
/*      */   {
/*  320 */     return this.sessionId;
/*      */   }
/*      */ 
/*      */   public String getClientSessionId()
/*      */   {
/*  325 */     return this.clientSessionId;
/*      */   }
/*      */ 
/*      */   public String getSubsystem()
/*      */   {
/*  330 */     return this.invocation.getSubsystem();
/*      */   }
/*      */ 
/*      */   public void setMemPercentCeiling(Double ceiling)
/*      */   {
/*  335 */     if (ceiling != null)
/*      */     {
/*  337 */       this.memPercentCeiling = ceiling.doubleValue();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Double getMemPercentCeiling()
/*      */   {
/*  343 */     return new Double(this.memPercentCeiling);
/*      */   }
/*      */ 
/*      */   private void createCallbackStore(ServerInvoker owner, String sessionId) throws Exception
/*      */   {
/*  348 */     Map config = owner.getConfiguration();
/*  349 */     if (config != null)
/*      */     {
/*  352 */       String storeName = (String)config.get("callbackStore");
/*  353 */       if (storeName != null)
/*      */       {
/*      */         try
/*      */         {
/*  358 */           MBeanServer server = owner.getMBeanServer();
/*  359 */           ObjectName storeObjectName = new ObjectName(storeName);
/*  360 */           if (server != null)
/*      */           {
/*  362 */             this.callbackStore = ((SerializableStore)MBeanServerInvocationHandler.newProxyInstance(server, storeObjectName, SerializableStore.class, false));
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (Exception ex)
/*      */         {
/*  371 */           log.debug("Could not create callback store from the configration value given (" + storeName + ") as an MBean.");
/*  372 */           if (trace) log.trace("Error is: " + ex.getMessage(), ex);
/*      */ 
/*  374 */           this.callbackStore = null;
/*      */         }
/*      */ 
/*  378 */         if (this.callbackStore == null)
/*      */         {
/*      */           try
/*      */           {
/*  382 */             Class storeClass = Class.forName(storeName);
/*  383 */             this.callbackStore = ((SerializableStore)storeClass.newInstance());
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  387 */             log.debug("Could not create callback store from the configuration value given (" + storeName + ") as a fully qualified class name.");
/*  388 */             if (trace) log.trace("Error is: " + e.getMessage(), e);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  395 */     if (this.callbackStore == null)
/*      */     {
/*  397 */       this.callbackStore = new NullCallbackStore();
/*      */     }
/*      */     else
/*      */     {
/*  402 */       Map storeConfig = new HashMap();
/*  403 */       storeConfig.putAll(owner.getConfiguration());
/*      */ 
/*  405 */       String newFilePath = null;
/*      */ 
/*  407 */       String filePath = (String)storeConfig.get("StoreFilePath");
/*  408 */       if (filePath == null)
/*      */       {
/*  410 */         newFilePath = System.getProperty("jboss.server.data.dir", "data");
/*      */       }
/*  412 */       newFilePath = newFilePath + System.getProperty("file.separator") + "remoting" + System.getProperty("file.separator") + sessionId;
/*      */ 
/*  415 */       storeConfig.put("StoreFilePath", newFilePath);
/*      */ 
/*  417 */       this.callbackStore.setConfig(storeConfig);
/*      */     }
/*      */ 
/*  420 */     this.callbackStore.create();
/*  421 */     this.callbackStore.start();
/*      */ 
/*  423 */     configureMemCeiling(owner.getConfiguration());
/*      */   }
/*      */ 
/*      */   private void createCallbackErrorHandler(ServerInvoker owner, String subsystem) throws Exception
/*      */   {
/*  428 */     Map config = owner.getConfiguration();
/*  429 */     if (config != null)
/*      */     {
/*  432 */       String errorHandlerName = (String)config.get("callbackErrorHandler");
/*  433 */       if (errorHandlerName != null)
/*      */       {
/*      */         try
/*      */         {
/*  438 */           MBeanServer server = owner.getMBeanServer();
/*  439 */           ObjectName errorHandlerObjectName = new ObjectName(errorHandlerName);
/*  440 */           if (server != null)
/*      */           {
/*  442 */             this.callbackErrorHandler = ((CallbackErrorHandler)MBeanServerInvocationHandler.newProxyInstance(server, errorHandlerObjectName, CallbackErrorHandler.class, false));
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (Exception ex)
/*      */         {
/*  451 */           log.debug("Could not create callback error handler from the configration value given (" + errorHandlerName + ") as an MBean.");
/*      */ 
/*  453 */           if (trace) log.trace("Error is: " + ex.getMessage(), ex);
/*  454 */           this.callbackErrorHandler = null;
/*      */         }
/*      */ 
/*  458 */         if (this.callbackStore == null)
/*      */         {
/*      */           try
/*      */           {
/*  462 */             Class errorHandlerClass = Class.forName(errorHandlerName);
/*  463 */             this.callbackErrorHandler = ((CallbackErrorHandler)errorHandlerClass.newInstance());
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  467 */             log.debug("Could not create callback error handler from the configuration value given (" + errorHandlerName + ") as a fully qualified class name.");
/*      */ 
/*  469 */             if (trace) log.trace("Error is: " + e.getMessage(), e);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  476 */     if (this.callbackErrorHandler == null)
/*      */     {
/*  478 */       this.callbackErrorHandler = new DefaultCallbackErrorHandler();
/*      */     }
/*      */ 
/*  482 */     Map errorHandlerConfig = new HashMap();
/*  483 */     errorHandlerConfig.putAll(owner.getConfiguration());
/*  484 */     errorHandlerConfig.put("handlerSubsystem", subsystem);
/*  485 */     this.callbackErrorHandler.setConfig(errorHandlerConfig);
/*  486 */     this.callbackErrorHandler.setServerInvoker(owner);
/*  487 */     this.callbackErrorHandler.setCallbackHandler(this);
/*      */   }
/*      */ 
/*      */   private void configureMemCeiling(Map configuration)
/*      */   {
/*  493 */     if (configuration != null)
/*      */     {
/*  495 */       String ceiling = (String)configuration.get("callbackMemCeiling");
/*  496 */       if (ceiling != null)
/*      */       {
/*      */         try
/*      */         {
/*  500 */           double newCeiling = Double.parseDouble(ceiling);
/*  501 */           setMemPercentCeiling(new Double(newCeiling));
/*      */         }
/*      */         catch (NumberFormatException e)
/*      */         {
/*  505 */           log.warn("Found new store memory ceiling seting (" + ceiling + "), but can not convert to type double.", e);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Client getCallbackClient()
/*      */   {
/*  513 */     return this.callBackClient;
/*      */   }
/*      */ 
/*      */   public static String getId(InvocationRequest invocation)
/*      */   {
/*  524 */     String sessionId = invocation.getSessionId();
/*  525 */     Map metadata = invocation.getRequestPayload();
/*  526 */     if (metadata != null)
/*      */     {
/*  528 */       String listenerId = (String)metadata.get("listenerId");
/*  529 */       if (listenerId != null)
/*      */       {
/*  531 */         sessionId = sessionId + "+" + listenerId;
/*      */       }
/*      */     }
/*  534 */     return sessionId;
/*      */   }
/*      */ 
/*      */   public String getId()
/*      */   {
/*  543 */     return this.sessionId;
/*      */   }
/*      */ 
/*      */   public List getCallbacks(Map metadata)
/*      */   {
/*  548 */     log.trace("entering getCallbacks()");
/*      */ 
/*  550 */     boolean blocking = false;
/*  551 */     int currentBlockingTimeout = this.blockingTimeout;
/*      */ 
/*  553 */     if (metadata != null)
/*      */     {
/*  555 */       Object val = metadata.get("blockingMode");
/*  556 */       if ("blocking".equals(val)) {
/*  557 */         blocking = true;
/*      */       }
/*  559 */       val = metadata.get("blockingTimeout");
/*  560 */       if (val != null)
/*      */       {
/*  562 */         if ((val instanceof String))
/*      */         {
/*      */           try
/*      */           {
/*  566 */             currentBlockingTimeout = Integer.parseInt((String)val);
/*      */           }
/*      */           catch (NumberFormatException e)
/*      */           {
/*  570 */             log.warn("Error converting blockingTimeout to type long.  " + e.getMessage());
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/*  575 */           log.warn("Value for blockingTimeout configuration must be of type " + String.class.getName() + " and is " + val.getClass().getName());
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  581 */     if (trace)
/*      */     {
/*  583 */       log.trace("block: " + blocking);
/*  584 */       log.trace("blocking timeout: " + currentBlockingTimeout);
/*      */     }
/*      */ 
/*  587 */     synchronized (this.callbacks)
/*      */     {
/*  589 */       List callbackList = constructCallbackList();
/*  590 */       if ((blocking) && (callbackList.isEmpty()))
/*      */       {
/*      */         try
/*      */         {
/*  594 */           this.callbacks.wait(currentBlockingTimeout);
/*  595 */           callbackList = constructCallbackList();
/*      */         }
/*      */         catch (InterruptedException e)
/*      */         {
/*  599 */           log.debug("unexpected interrupt");
/*      */         }
/*      */       }
/*      */ 
/*  603 */       if (trace) log.trace("callbackList.size(): " + callbackList.size());
/*  604 */       return callbackList;
/*      */     }
/*      */   }
/*      */ 
/*      */   private List constructCallbackList()
/*      */   {
/*  610 */     List callbackList = null;
/*  611 */     synchronized (this.callbacks)
/*      */     {
/*  613 */       callbackList = (List)this.callbacks.clone();
/*  614 */       this.callbacks.clear();
/*      */     }
/*      */ 
/*  618 */     List persistedCallbacks = null;
/*      */     try
/*      */     {
/*  621 */       persistedCallbacks = getPersistedCallbacks();
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  625 */       log.error("Can not get persisted callbacks.", e);
/*  626 */       throw new RuntimeException("Error getting callbacks", e);
/*      */     }
/*  628 */     callbackList.addAll(persistedCallbacks);
/*  629 */     return callbackList;
/*      */   }
/*      */ 
/*      */   private List getPersistedCallbacks() throws IOException
/*      */   {
/*  634 */     List callbacks = new ArrayList();
/*      */ 
/*  636 */     int size = this.callbackStore.size();
/*  637 */     for (int x = 0; x < size; x++)
/*      */     {
/*  639 */       callbacks.add(this.callbackStore.getNext());
/*      */ 
/*  642 */       if (!isMemLow())
/*      */         continue;
/*  644 */       new Thread()
/*      */       {
/*      */         public void run()
/*      */         {
/*  648 */           System.gc();
/*      */         }
/*      */       }
/*  644 */       .start();
/*      */ 
/*  651 */       break;
/*      */     }
/*      */ 
/*  655 */     return callbacks;
/*      */   }
/*      */ 
/*      */   public boolean isPullCallbackHandler()
/*      */   {
/*  660 */     return this.callBackClient == null;
/*      */   }
/*      */ 
/*      */   public void handleCallback(Callback callback)
/*      */     throws HandleCallbackException
/*      */   {
/*  672 */     handleCallback(callback, false, false);
/*      */   }
/*      */ 
/*      */   public void handleCallbackOneway(Callback callback)
/*      */     throws HandleCallbackException
/*      */   {
/*  686 */     handleCallback(callback, true, false);
/*      */   }
/*      */ 
/*      */   public void handleCallbackOneway(Callback callback, boolean serverSide)
/*      */     throws HandleCallbackException
/*      */   {
/*  706 */     handleCallback(callback, true, serverSide);
/*      */   }
/*      */ 
/*      */   public void handleCallback(Callback callback, boolean asynch, boolean serverSide)
/*      */     throws HandleCallbackException
/*      */   {
/*      */     try
/*      */     {
/*  729 */       Object callbackId = checkForCallbackListener(callback);
/*      */ 
/*  731 */       if (this.callBackClient == null)
/*      */       {
/*  734 */         if (shouldPersist())
/*      */         {
/*      */           try
/*      */           {
/*  738 */             synchronized (this.callbacks)
/*      */             {
/*  740 */               persistCallback(callback);
/*  741 */               this.callbacks.notify();
/*      */             }
/*      */ 
/*  744 */             callback = null;
/*      */ 
/*  746 */             new Thread()
/*      */             {
/*      */               public void run()
/*      */               {
/*  750 */                 System.gc();
/*      */               }
/*      */             }
/*  746 */             .start();
/*      */           }
/*      */           catch (IOException e)
/*      */           {
/*  756 */             log.error("Unable to persist callback", e);
/*  757 */             throw new HandleCallbackException("Unable to persist callback and will not be able to deliver.", e);
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  763 */           synchronized (this.callbacks)
/*      */           {
/*  765 */             if (trace) log.debug(this + " got PULL callback. Adding to callback list ...");
/*  766 */             this.callbacks.add(callback);
/*  767 */             this.callbacks.notify();
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/*  777 */           if (trace) log.debug(this + " got PUSH callback " + callback);
/*      */ 
/*  779 */           boolean handleAcknowledgement = false;
/*      */ 
/*  781 */           if (callback != null)
/*      */           {
/*  783 */             Object returnPayload = callback.getReturnPayload();
/*      */ 
/*  785 */             if (returnPayload == null)
/*      */             {
/*  787 */               returnPayload = new HashMap();
/*      */             }
/*      */             else
/*      */             {
/*  791 */               Object o = ((Map)returnPayload).remove("remotingAcknowledgesPushCallbacks");
/*  792 */               if (!asynch)
/*      */               {
/*  794 */                 if ((((o instanceof String)) && (Boolean.valueOf((String)o).booleanValue())) || (((o instanceof Boolean)) && (((Boolean)o).booleanValue())))
/*      */                 {
/*  796 */                   handleAcknowledgement = true;
/*      */                 }
/*      */               }
/*      */             }
/*  800 */             ((Map)returnPayload).put("server_locator", this.serverLocator);
/*  801 */             callback.setReturnPayload((Map)returnPayload);
/*      */           }
/*      */ 
/*  807 */           InternalInvocation internalInvocation = new InternalInvocation("handleCallback", new Object[] { callback });
/*      */ 
/*  810 */           this.callBackClient.setSessionId(this.sessionId);
/*      */ 
/*  812 */           if (asynch)
/*      */           {
/*  814 */             if (trace) log.debug(this + " sending ASYNCHRONOUSLY the callback to the client");
/*  815 */             this.callBackClient.invokeOneway(internalInvocation, callback.getRequestPayload(), serverSide);
/*      */           }
/*      */           else
/*      */           {
/*  820 */             if (trace) log.debug(this + " sending SYNCHRONOUSLY the callback to the client");
/*  821 */             this.callBackClient.invoke(internalInvocation, callback.getRequestPayload());
/*      */           }
/*      */ 
/*  824 */           handlePushCallbackAcknowledgement(callbackId, handleAcknowledgement);
/*      */         }
/*      */         catch (Throwable ex)
/*      */         {
/*  828 */           if (this.callbackErrorHandler == null)
/*      */           {
/*  831 */             throw ex;
/*      */           }
/*      */ 
/*  834 */           if (trace) log.trace(this + " handing the error over to " + this.callbackErrorHandler);
/*      */ 
/*  839 */           this.callbackErrorHandler.handleError(ex);
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  845 */       log.error("Error handling callback", t);
/*  846 */       throw new HandleCallbackException("Error handling callback", t);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void persistCallback(InvocationRequest callback) throws IOException
/*      */   {
/*  852 */     this.callbackStore.add(callback);
/*      */   }
/*      */ 
/*      */   private boolean shouldPersist()
/*      */   {
/*  866 */     return isMemLow();
/*      */   }
/*      */ 
/*      */   private boolean isMemLow()
/*      */   {
/*  871 */     Runtime runtime = Runtime.getRuntime();
/*  872 */     long max = runtime.maxMemory();
/*  873 */     long total = runtime.totalMemory();
/*  874 */     long free = runtime.freeMemory();
/*  875 */     float percentage = (float)(100L * free / total);
/*      */ 
/*  878 */     return (max == total) && (this.memPercentCeiling >= percentage);
/*      */   }
/*      */ 
/*      */   Object checkForCallbackListener(Callback callback)
/*      */   {
/*  888 */     Map returnPayload = callback.getReturnPayload();
/*  889 */     if (returnPayload == null) {
/*  890 */       return null;
/*      */     }
/*  892 */     Object listenerObject = returnPayload.remove("callbackListener");
/*  893 */     if (listenerObject == null) {
/*  894 */       return null;
/*      */     }
/*  896 */     Object callbackId = returnPayload.get("callbackId");
/*  897 */     if (callbackId == null)
/*      */     {
/*  899 */       log.error("CALLBACK_ID is null: unable to acknowledge callback");
/*  900 */       return null;
/*      */     }
/*      */ 
/*  903 */     if ((listenerObject instanceof CallbackListener))
/*      */     {
/*  905 */       if (this.listenerId != null)
/*      */       {
/*  907 */         returnPayload.put("listenerId", this.listenerId);
/*  908 */         this.idToListenerMap.put(callbackId, listenerObject);
/*  909 */         return callbackId;
/*      */       }
/*      */ 
/*  913 */       log.error("LISTENER_ID_KEY is null: unable to acknowledge callback");
/*  914 */       return null;
/*      */     }
/*      */ 
/*  919 */     log.error("callback preprocess listener has wrong type: " + listenerObject);
/*  920 */     return null;
/*      */   }
/*      */ 
/*      */   private void handlePushCallbackAcknowledgement(Object callbackId, boolean handleAck)
/*      */   {
/*  926 */     if (!handleAck) {
/*  927 */       return;
/*      */     }
/*  929 */     if (callbackId == null)
/*      */     {
/*  931 */       log.error("Unable to acknowledge push callback: callback id is null");
/*  932 */       return;
/*      */     }
/*      */ 
/*  935 */     CallbackListener listener = (CallbackListener)this.idToListenerMap.get(callbackId);
/*  936 */     if (listener == null)
/*      */     {
/*  938 */       log.error("Unable to acknowledge push callback: listener is null");
/*  939 */       return;
/*      */     }
/*      */ 
/*  942 */     listener.acknowledgeCallback(this, callbackId, null);
/*      */   }
/*      */ 
/*      */   public void acknowledgeCallbacks(InternalInvocation invocation)
/*      */     throws Exception
/*      */   {
/*  952 */     Object[] params = invocation.getParameters();
/*  953 */     if (params == null) {
/*  954 */       return;
/*      */     }
/*  956 */     List callbackIds = (List)params[0];
/*  957 */     List responses = (List)params[1];
/*  958 */     if ((callbackIds == null) || (callbackIds.size() == 0)) {
/*  959 */       return;
/*      */     }
/*  961 */     Iterator idsIterator = callbackIds.iterator();
/*  962 */     Iterator responseIterator = null;
/*  963 */     if (responses != null) {
/*  964 */       responseIterator = responses.iterator();
/*      */     }
/*  966 */     Object callbackId = null;
/*  967 */     Object response = null;
/*  968 */     while (idsIterator.hasNext())
/*      */     {
/*  970 */       callbackId = idsIterator.next();
/*  971 */       if (responseIterator != null) {
/*  972 */         response = responseIterator.next();
/*      */       }
/*  974 */       CallbackListener listener = (CallbackListener)this.idToListenerMap.remove(callbackId);
/*      */ 
/*  976 */       if (listener == null)
/*      */       {
/*  978 */         log.warn("Cannot acknowledge callback: unrecognized id: " + callbackId);
/*  979 */         continue;
/*      */       }
/*      */ 
/*  982 */       listener.acknowledgeCallback(this, callbackId, response);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  988 */     return "ServerInvokerCallbackHandler[" + getId() + "]";
/*      */   }
/*      */ 
/*      */   public void destroy()
/*      */   {
/*  998 */     if (this.callBackClient != null)
/*      */     {
/* 1000 */       this.callBackClient.disconnect();
/* 1001 */       this.callBackClient = null;
/*      */     }
/*      */ 
/* 1004 */     if (this.callbackStore != null)
/*      */     {
/* 1006 */       this.callbackStore.purgeFiles();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.callback.ServerInvokerCallbackHandler
 * JD-Core Version:    0.6.0
 */