/*     */ package org.jboss.remoting.callback;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.FilenameFilter;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.Arrays;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ 
/*     */ public class CallbackStore
/*     */   implements CallbackStoreMBean
/*     */ {
/*     */   private static long previousTimestamp;
/*     */   private static int timestampCounter;
/*  62 */   private String filePath = null;
/*  63 */   private String fileSuffix = "ser";
/*     */ 
/*  65 */   private boolean isStarted = false;
/*  66 */   private boolean purgeOnShutdown = false;
/*     */ 
/*  68 */   private String serializationType = "java";
/*     */   public static final String FILE_PATH_KEY = "StoreFilePath";
/*     */   public static final String FILE_SUFFIX_KEY = "StoreFileSuffix";
/*  83 */   private static final Logger log = Logger.getLogger(CallbackStore.class);
/*     */ 
/*     */   public CallbackStore()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CallbackStore(boolean purgeOnDestroy)
/*     */   {
/* 101 */     this.purgeOnShutdown = purgeOnDestroy;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 113 */     if (!this.isStarted)
/*     */     {
/* 116 */       if (this.filePath == null)
/*     */       {
/* 118 */         this.filePath = System.getProperty("jboss.server.data.dir", "data");
/*     */       }
/* 120 */       File storeFile = new File(this.filePath);
/* 121 */       if (!storeFile.exists())
/*     */       {
/* 123 */         boolean madeDir = storeFile.mkdirs();
/* 124 */         if (!madeDir)
/*     */         {
/* 126 */           throw new IOException("Can not create directory for store.  Path given: " + this.filePath);
/*     */         }
/*     */       }
/* 129 */       this.isStarted = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setPurgeOnShutdown(boolean purgeOnShutdown)
/*     */   {
/* 140 */     this.purgeOnShutdown = purgeOnShutdown;
/*     */   }
/*     */ 
/*     */   public boolean getPurgeOnShutdown()
/*     */   {
/* 150 */     return this.purgeOnShutdown;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 169 */     this.isStarted = false;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 177 */     if (this.purgeOnShutdown)
/*     */     {
/* 179 */       purgeFiles();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void purgeFiles()
/*     */   {
/* 185 */     String[] fileList = getObjectFileList();
/* 186 */     String fileToDelete = null;
/* 187 */     for (int x = 0; x < fileList.length; x++)
/*     */     {
/*     */       try
/*     */       {
/* 191 */         fileToDelete = this.filePath + System.getProperty("file.separator") + fileList[x];
/* 192 */         File currentFile = new File(fileToDelete);
/* 193 */         boolean deleted = currentFile.delete();
/* 194 */         if (!deleted)
/*     */         {
/* 196 */           log.warn("Error purging file " + fileToDelete);
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 201 */         log.warn("Error purging file " + fileToDelete);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setConfig(Map config)
/*     */   {
/* 215 */     if (config != null)
/*     */     {
/* 217 */       String newFilePath = (String)config.get("StoreFilePath");
/* 218 */       if (newFilePath != null)
/*     */       {
/* 220 */         this.filePath = newFilePath;
/*     */       }
/* 222 */       String newFileSuffix = (String)config.get("StoreFileSuffix");
/* 223 */       if (newFileSuffix != null)
/*     */       {
/* 225 */         this.fileSuffix = newFileSuffix;
/*     */       }
/* 227 */       String newSerializationType = (String)config.get("serializationtype");
/* 228 */       if (newSerializationType != null)
/*     */       {
/* 230 */         this.serializationType = newSerializationType;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getStoreFilePath()
/*     */   {
/* 243 */     return this.filePath;
/*     */   }
/*     */ 
/*     */   public void setStoreFilePath(String filePath)
/*     */   {
/* 253 */     this.filePath = filePath;
/*     */   }
/*     */ 
/*     */   public String getStoreFileSuffix()
/*     */   {
/* 263 */     return this.fileSuffix;
/*     */   }
/*     */ 
/*     */   public void setStoreFileSuffix(String fileSuffix)
/*     */   {
/* 273 */     this.fileSuffix = fileSuffix;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 284 */     verifyStarted();
/* 285 */     String[] objectFileList = getObjectFileList();
/* 286 */     if (objectFileList != null)
/*     */     {
/* 288 */       return objectFileList.length;
/*     */     }
/*     */ 
/* 292 */     return 0;
/*     */   }
/*     */ 
/*     */   private void verifyStarted()
/*     */   {
/* 298 */     if (!this.isStarted)
/*     */     {
/* 300 */       throw new RuntimeException("Can not call upon this store method before it has been started.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getNext()
/*     */     throws IOException
/*     */   {
/* 315 */     verifyStarted();
/*     */ 
/* 317 */     Object obj = null;
/* 318 */     String objectFilePath = null;
/*     */ 
/* 320 */     synchronized (this.filePath)
/*     */     {
/* 322 */       String[] objectFileList = getObjectFileList();
/* 323 */       FileInputStream inFile = null;
/* 324 */       ObjectInputStream in = null;
/*     */ 
/* 326 */       if ((objectFileList != null) && (objectFileList.length > 0))
/*     */       {
/*     */         try
/*     */         {
/* 332 */           objectFilePath = this.filePath + System.getProperty("file.separator") + objectFileList[0];
/* 333 */           inFile = new FileInputStream(objectFilePath);
/* 334 */           in = SerializationStreamFactory.getManagerInstance(this.serializationType).createRegularInput(inFile);
/*     */           try
/*     */           {
/* 338 */             obj = in.readObject();
/*     */           }
/*     */           catch (ClassNotFoundException e)
/*     */           {
/* 342 */             throw new IOException("Error loading persisted object.  Could not load class (" + e.getMessage() + ").");
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/* 347 */           if (inFile != null)
/*     */           {
/*     */             try
/*     */             {
/* 351 */               inFile.close();
/*     */             }
/*     */             catch (IOException ioe)
/*     */             {
/* 355 */               log.debug("Error closing FileInputStream.", ioe);
/*     */             }
/*     */           }
/* 358 */           if (in != null)
/*     */           {
/*     */             try
/*     */             {
/* 362 */               in.close();
/*     */             }
/*     */             catch (IOException ioe)
/*     */             {
/* 366 */               log.debug("Error closing ObjectInputStream.", ioe);
/*     */             }
/*     */           }
/* 369 */           if (objectFilePath != null)
/*     */           {
/* 372 */             File objectFile = new File(objectFilePath);
/* 373 */             boolean isDeleted = objectFile.delete();
/* 374 */             if (log.isTraceEnabled())
/*     */             {
/* 376 */               log.trace("object file (" + objectFilePath + ") has been deleted - " + isDeleted);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 383 */     return obj;
/*     */   }
/*     */ 
/*     */   private String[] getObjectFileList()
/*     */   {
/* 388 */     File storePath = new File(this.filePath);
/* 389 */     String[] objectFileList = storePath.list(new StoreFileFilter());
/* 390 */     Arrays.sort(objectFileList);
/* 391 */     return objectFileList;
/*     */   }
/*     */ 
/*     */   public void add(Serializable object)
/*     */     throws IOException
/*     */   {
/* 404 */     verifyStarted();
/*     */ 
/* 406 */     synchronized (this.filePath)
/*     */     {
/* 408 */       long currentTimestamp = System.currentTimeMillis();
/*     */ 
/* 410 */       if (previousTimestamp == currentTimestamp)
/*     */       {
/* 412 */         timestampCounter += 1;
/*     */       }
/*     */       else
/*     */       {
/* 416 */         previousTimestamp = currentTimestamp;
/* 417 */         timestampCounter = 0;
/*     */       }
/*     */ 
/* 420 */       StringBuffer path = new StringBuffer(this.filePath);
/* 421 */       path.append(System.getProperty("file.separator")).append(String.valueOf(currentTimestamp));
/* 422 */       path.append("-").append(timestampCounter).append(".").append(this.fileSuffix);
/* 423 */       File storeFile = new File(path.toString());
/* 424 */       FileOutputStream outFile = null;
/* 425 */       ObjectOutputStream out = null;
/*     */       try
/*     */       {
/* 429 */         outFile = new FileOutputStream(storeFile, false);
/* 430 */         out = SerializationStreamFactory.getManagerInstance(this.serializationType).createOutput(outFile);
/* 431 */         out.writeObject(object);
/* 432 */         out.flush();
/*     */       }
/*     */       finally
/*     */       {
/* 436 */         if (outFile != null)
/*     */         {
/*     */           try
/*     */           {
/* 440 */             outFile.close();
/*     */           }
/*     */           catch (IOException ioe)
/*     */           {
/* 444 */             log.debug("Error closing FileInputStream.", ioe);
/*     */           }
/*     */         }
/* 447 */         if (out != null)
/*     */         {
/*     */           try
/*     */           {
/* 451 */             out.close();
/*     */           }
/*     */           catch (IOException ioe)
/*     */           {
/* 455 */             log.debug("Error closing ObjectInputStream.", ioe);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public class StoreFileFilter
/*     */     implements FilenameFilter
/*     */   {
/*     */     public StoreFileFilter()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean accept(File dir, String name)
/*     */     {
/* 477 */       return name.endsWith(CallbackStore.this.fileSuffix);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.callback.CallbackStore
 * JD-Core Version:    0.6.0
 */