/*     */ package org.jboss.remoting;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.TimerTask;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.util.TimerUtil;
/*     */ 
/*     */ public class Lease
/*     */ {
/*  42 */   private ConnectionNotifier notifier = null;
/*  43 */   private String clientSessionId = null;
/*  44 */   private long leasePeriod = -1L;
/*  45 */   private String locatorURL = null;
/*  46 */   private Map requestPayload = null;
/*  47 */   private LeaseTimerTask leaseTimerTask = null;
/*  48 */   private long leaseWindow = -1L;
/*  49 */   private long pingStart = -1L;
/*  50 */   private Map clientLeases = null;
/*     */ 
/*  52 */   private boolean leaseUpdated = false;
/*     */ 
/*  54 */   private static final Logger log = Logger.getLogger(Lease.class);
/*  55 */   private static final boolean isTraceEnabled = log.isTraceEnabled();
/*     */ 
/*     */   public Lease(String clientSessionId, long leasePeriod, String locatorurl, Map requestPayload, ConnectionNotifier notifier, Map clientLeases)
/*     */   {
/*  60 */     this.clientSessionId = clientSessionId;
/*  61 */     this.leasePeriod = leasePeriod;
/*  62 */     this.notifier = notifier;
/*  63 */     this.locatorURL = locatorurl;
/*  64 */     if (requestPayload != null)
/*     */     {
/*  66 */       this.requestPayload = ((Map)requestPayload.get("ClientHolderKey"));
/*     */     }
/*  68 */     this.leaseWindow = (leasePeriod * 2L);
/*  69 */     this.clientLeases = clientLeases;
/*     */   }
/*     */ 
/*     */   public void startLease()
/*     */   {
/*  75 */     if (isTraceEnabled)
/*     */     {
/*  77 */       log.trace("Starting lease for client invoker (session id = " + this.clientSessionId + ") with lease window time of " + this.leaseWindow);
/*     */     }
/*  79 */     this.leaseTimerTask = new LeaseTimerTask(null);
/*  80 */     TimerUtil.schedule(this.leaseTimerTask, this.leaseWindow);
/*     */   }
/*     */ 
/*     */   public void updateLease(long leasePeriod, Map requestMap)
/*     */   {
/*  85 */     if (requestMap != null)
/*     */     {
/*  87 */       this.requestPayload = ((Map)requestMap.get("ClientHolderKey"));
/*     */     }
/*  89 */     updateLease(leasePeriod);
/*     */   }
/*     */ 
/*     */   public void updateLease(long leasePeriod)
/*     */   {
/*  94 */     this.leaseUpdated = true;
/*  95 */     if (leasePeriod != this.leasePeriod)
/*     */     {
/*  97 */       this.leasePeriod = leasePeriod;
/*  98 */       this.leaseWindow = (leasePeriod * 2L);
/*  99 */       stopLease();
/* 100 */       startLease();
/* 101 */       if (isTraceEnabled)
/*     */       {
/* 103 */         log.trace("Lease for client invoker (session id = " + this.clientSessionId + ") updated with new lease window of " + this.leaseWindow + ".  Resetting timer.");
/*     */       }
/*     */ 
/*     */     }
/* 108 */     else if (this.pingStart != -1L)
/*     */     {
/* 110 */       long pingDuration = System.currentTimeMillis() - this.pingStart;
/* 111 */       if (pingDuration > 0.75D * this.leaseWindow)
/*     */       {
/* 113 */         this.leaseWindow = (pingDuration * 2L);
/*     */ 
/* 115 */         stopLease();
/* 116 */         this.leaseTimerTask = new LeaseTimerTask(null);
/* 117 */         TimerUtil.schedule(this.leaseTimerTask, this.leaseWindow);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 122 */     this.pingStart = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public void terminateLease(String sessionId)
/*     */   {
/* 127 */     if (isTraceEnabled)
/*     */     {
/* 129 */       log.trace("Terminating lease for session id " + sessionId);
/*     */     }
/*     */ 
/* 132 */     if (this.clientSessionId.equals(sessionId))
/*     */     {
/* 134 */       stopLease();
/*     */ 
/* 139 */       notifyClientTermination(null);
/*     */     }
/*     */     else
/*     */     {
/* 143 */       notifyClientTermination(sessionId);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void notifyClientTermination(String sessionId)
/*     */   {
/* 150 */     if (this.requestPayload != null)
/*     */     {
/* 153 */       if (sessionId != null)
/*     */       {
/* 155 */         Object clientHolderObj = this.requestPayload.remove(sessionId);
/* 156 */         if ((clientHolderObj != null) && ((clientHolderObj instanceof ClientHolder)))
/*     */         {
/* 158 */           ClientHolder clientHolder = (ClientHolder)clientHolderObj;
/* 159 */           this.notifier.connectionTerminated(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
/* 160 */           if (isTraceEnabled)
/*     */           {
/* 162 */             log.trace("Notified connection listener of lease termination due to disconnect from client (client session id = " + clientHolder.getSessionId());
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 169 */         Collection clientHoldersCol = this.requestPayload.values();
/* 170 */         if ((clientHoldersCol != null) && (clientHoldersCol.size() > 0))
/*     */         {
/* 172 */           Iterator itr = clientHoldersCol.iterator();
/* 173 */           while (itr.hasNext())
/*     */           {
/* 175 */             Object val = itr.next();
/* 176 */             if ((val != null) && ((val instanceof ClientHolder)))
/*     */             {
/* 178 */               ClientHolder clientHolder = (ClientHolder)val;
/* 179 */               this.notifier.connectionTerminated(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
/* 180 */               if (isTraceEnabled)
/*     */               {
/* 182 */                 log.trace("Notified connection listener of lease termination due to disconnect from client (client session id = " + clientHolder.getSessionId());
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 191 */       log.warn("Tried to terminate lease for session id " + sessionId + ", but no collection of clients have been set.");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void notifyClientLost()
/*     */   {
/* 198 */     if (this.requestPayload != null)
/*     */     {
/* 201 */       Collection clientHoldersCol = this.requestPayload.values();
/* 202 */       if ((clientHoldersCol != null) && (clientHoldersCol.size() > 0))
/*     */       {
/* 204 */         Iterator itr = clientHoldersCol.iterator();
/* 205 */         while (itr.hasNext())
/*     */         {
/* 207 */           Object val = itr.next();
/* 208 */           if ((val != null) && ((val instanceof ClientHolder)))
/*     */           {
/* 210 */             ClientHolder clientHolder = (ClientHolder)val;
/* 211 */             this.notifier.connectionLost(this.locatorURL, clientHolder.getSessionId(), clientHolder.getConfig());
/* 212 */             if (isTraceEnabled)
/*     */             {
/* 214 */               log.trace("Notified connection listener of lease expired due to lost connection from client (client session id = " + clientHolder.getSessionId());
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 222 */       this.notifier.connectionTerminated(this.locatorURL, this.clientSessionId, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void stopLease()
/*     */   {
/* 228 */     this.leaseTimerTask.cancel();
/*     */   }
/*     */ 
/*     */   private class LeaseTimerTask extends TimerTask {
/*     */     private final Lease this$0;
/*     */ 
/*     */     private LeaseTimerTask() {
/*     */     }
/*     */ 
/*     */     public void run() {
/* 239 */       if (this.this$0.leaseUpdated)
/*     */       {
/* 241 */         Lease.access$102(this.this$0, false);
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 247 */           if (Lease.log.isTraceEnabled()) Lease.log.trace("did not receive ping: " + this.this$0.clientSessionId);
/* 248 */           this.this$0.stopLease();
/* 249 */           this.this$0.notifyClientLost();
/* 250 */           if (this.this$0.clientLeases != null)
/*     */           {
/* 252 */             this.this$0.clientLeases.remove(this.this$0.clientSessionId);
/*     */           }
/* 254 */           if (Lease.log.isTraceEnabled()) Lease.log.trace("removed lease:" + this.this$0.clientSessionId);
/*     */         }
/*     */         catch (Throwable thr)
/*     */         {
/* 258 */           Lease.log.error("Error terminating client lease and sending notification of lost client.", thr);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     LeaseTimerTask(Lease.1 x1)
/*     */     {
/* 231 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.Lease
 * JD-Core Version:    0.6.0
 */