/*     */ package org.jboss.remoting;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.Map;
/*     */ import java.util.TimerTask;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ import org.jboss.remoting.util.StoppableTimerTask;
/*     */ import org.jboss.remoting.util.TimerUtil;
/*     */ 
/*     */ public class ConnectionValidator extends TimerTask
/*     */   implements StoppableTimerTask
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(ConnectionValidator.class.getName());
/*     */   public static final String VALIDATOR_PING_PERIOD = "validatorPingPeriod";
/*     */   public static final long DEFAULT_PING_PERIOD = 2000L;
/*     */   public static final String VALIDATOR_PING_TIMEOUT = "validatorPingTimeout";
/*     */   public static final String DEFAULT_PING_TIMEOUT = "1000";
/*     */   public static final String DEFAULT_NUMBER_OF_PING_RETRIES = "1";
/*     */   public static final String DEFAULT_NUMBER_OF_CONNECTION_RETRIES = "1";
/*  73 */   private static boolean trace = log.isTraceEnabled();
/*     */   private Client client;
/*     */   private long pingPeriod;
/*     */   private Map metadata;
/*     */   private InvokerLocator locator;
/*     */   private Map configMap;
/*     */   private List listeners;
/*     */   private ClientInvoker clientInvoker;
/* 198 */   private Object lock = new Object();
/*     */   private volatile boolean stopped;
/*     */ 
/*     */   public static boolean checkConnection(InvokerLocator locator, Map config)
/*     */     throws Throwable
/*     */   {
/*  85 */     boolean pingWorked = false;
/*  86 */     Map configMap = createPingConfig(config, null);
/*  87 */     ClientInvoker innerClientInvoker = null;
/*     */     try
/*     */     {
/*  91 */       innerClientInvoker = InvokerRegistry.createClientInvoker(locator, configMap);
/*     */ 
/*  93 */       if (!innerClientInvoker.isConnected())
/*     */       {
/*  95 */         if (trace) log.trace("inner client invoker not connected, connecting ...");
/*  96 */         innerClientInvoker.connect();
/*     */       }
/*     */ 
/*  99 */       pingWorked = doCheckConnection(innerClientInvoker);
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 103 */       log.debug("ConnectionValidator to connect to server " + innerClientInvoker.getLocator().getProtocol() + "://" + innerClientInvoker.getLocator().getHost() + ":" + innerClientInvoker.getLocator().getPort(), throwable);
/*     */     }
/*     */     finally
/*     */     {
/* 110 */       if (innerClientInvoker != null)
/*     */       {
/* 112 */         InvokerRegistry.destroyClientInvoker(locator, configMap);
/*     */       }
/*     */     }
/*     */ 
/* 116 */     return pingWorked;
/*     */   }
/*     */ 
/*     */   private static boolean doCheckConnection(ClientInvoker clientInvoker) throws Throwable
/*     */   {
/* 121 */     boolean pingWorked = false;
/*     */     try
/*     */     {
/* 128 */       InvocationRequest ir = new InvocationRequest(null, "self", "$PING$", null, null, null);
/*     */ 
/* 131 */       if (trace) log.trace("pinging, sending " + ir + " over " + clientInvoker);
/*     */ 
/* 133 */       clientInvoker.invoke(ir);
/*     */ 
/* 135 */       if (trace) log.trace("ConnectionValidator got successful ping using " + clientInvoker);
/*     */ 
/* 137 */       pingWorked = true;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 141 */       log.debug("ConnectionValidator failed to ping via " + clientInvoker, t);
/*     */     }
/*     */ 
/* 144 */     return pingWorked;
/*     */   }
/*     */ 
/*     */   private static Map createPingConfig(Map config, Map metadata)
/*     */   {
/* 149 */     Map localConfig = new HashMap();
/* 150 */     localConfig.put("connection_checker", "true");
/*     */ 
/* 152 */     if (config != null)
/*     */     {
/* 154 */       Object o = config.get("validatorPingTimeout");
/* 155 */       log.trace("config timeout: " + o);
/* 156 */       if (o != null) {
/* 157 */         localConfig.put("timeout", o);
/*     */       }
/* 159 */       o = config.get("NumberOfCallRetries");
/* 160 */       if (o != null) {
/* 161 */         localConfig.put("NumberOfCallRetries", o);
/*     */       }
/* 163 */       o = config.get("NumberOfRetries");
/* 164 */       if (o != null) {
/* 165 */         localConfig.put("NumberOfRetries", o);
/*     */       }
/*     */     }
/* 168 */     if (metadata != null)
/*     */     {
/* 170 */       metadata.remove("timeout");
/* 171 */       localConfig.putAll(metadata);
/* 172 */       Object o = metadata.get("validatorPingTimeout");
/* 173 */       if (o != null) {
/* 174 */         localConfig.put("timeout", o);
/*     */       }
/*     */     }
/* 177 */     if (localConfig.get("timeout") == null) {
/* 178 */       localConfig.put("timeout", "1000");
/*     */     }
/* 180 */     if (localConfig.get("NumberOfCallRetries") == null) {
/* 181 */       localConfig.put("NumberOfCallRetries", "1");
/*     */     }
/* 183 */     if (localConfig.get("NumberOfRetries") == null) {
/* 184 */       localConfig.put("NumberOfRetries", "1");
/*     */     }
/* 186 */     return localConfig;
/*     */   }
/*     */ 
/*     */   public ConnectionValidator(Client client)
/*     */   {
/* 205 */     this(client, 2000L);
/*     */   }
/*     */ 
/*     */   public ConnectionValidator(Client client, long pingPeriod)
/*     */   {
/* 210 */     this.client = client;
/* 211 */     this.pingPeriod = pingPeriod;
/* 212 */     this.listeners = new ArrayList();
/* 213 */     this.stopped = false;
/*     */ 
/* 215 */     log.debug(this + " created");
/*     */   }
/*     */ 
/*     */   public ConnectionValidator(Client client, Map metadata)
/*     */   {
/* 220 */     this.client = client;
/* 221 */     this.pingPeriod = 2000L;
/* 222 */     this.listeners = new ArrayList();
/* 223 */     this.stopped = false;
/*     */ 
/* 225 */     Map config = client.getConfiguration();
/* 226 */     if (config != null)
/*     */     {
/* 228 */       Object o = config.get("validatorPingPeriod");
/* 229 */       if (o != null)
/*     */       {
/* 231 */         if ((o instanceof String))
/*     */         {
/*     */           try
/*     */           {
/* 235 */             this.pingPeriod = Long.parseLong((String)o);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 239 */             log.warn(this + " could not convert " + "validatorPingPeriod" + " value of " + o + " to a long value");
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 245 */           log.warn(this + " could not convert " + "validatorPingPeriod" + " value of " + o + " to a long value: must be a String");
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 251 */     if (metadata != null)
/*     */     {
/* 253 */       this.metadata = new HashMap(metadata);
/*     */ 
/* 255 */       Object o = metadata.get("validatorPingPeriod");
/* 256 */       if (o != null)
/*     */       {
/* 258 */         if ((o instanceof String))
/*     */         {
/*     */           try
/*     */           {
/* 262 */             this.pingPeriod = Long.parseLong((String)o);
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 266 */             log.warn(this + " could not convert " + "validatorPingPeriod" + " value of " + o + " to a long value");
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 272 */           log.warn(this + " could not convert " + "validatorPingPeriod" + " value of " + o + " to a long value: must be a String");
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 278 */     log.debug(this + " created");
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 285 */     if (this.stopped)
/*     */     {
/* 287 */       return;
/*     */     }
/*     */ 
/* 290 */     doStop();
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 300 */     synchronized (this.lock)
/*     */     {
/* 302 */       if (!this.stopped)
/*     */       {
/*     */         try
/*     */         {
/* 306 */           if (trace) log.trace(this + " pinging ...");
/*     */ 
/* 308 */           boolean isValid = doCheckConnection(this.clientInvoker);
/*     */ 
/* 310 */           if (!isValid)
/*     */           {
/* 312 */             log.debug(this + "'s connections is invalid");
/*     */ 
/* 314 */             notifyListeners(new Exception("Could not connect to server!"));
/*     */           }
/*     */         }
/*     */         catch (Throwable thr)
/*     */         {
/* 319 */           log.debug(this + " got throwable while pinging", thr);
/* 320 */           notifyListeners(thr);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean cancel()
/*     */   {
/* 328 */     return doStop();
/*     */   }
/*     */ 
/*     */   public void addConnectionListener(ConnectionListener listener)
/*     */   {
/* 335 */     if (listener != null)
/*     */     {
/* 337 */       synchronized (this.listeners)
/*     */       {
/* 339 */         if (this.listeners.size() == 0)
/*     */         {
/* 341 */           start();
/*     */         }
/* 343 */         this.listeners.add(listener);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean removeConnectionListener(ConnectionListener listener)
/*     */   {
/* 350 */     boolean isRemoved = false;
/* 351 */     if (listener != null)
/*     */     {
/* 353 */       synchronized (this.listeners)
/*     */       {
/* 355 */         isRemoved = this.listeners.remove(listener);
/* 356 */         if (this.listeners.size() == 0)
/*     */         {
/* 358 */           stop();
/*     */         }
/*     */       }
/*     */     }
/* 362 */     return isRemoved;
/*     */   }
/*     */ 
/*     */   public long getPingPeriod()
/*     */   {
/* 367 */     if (this.stopped)
/*     */     {
/* 369 */       return -1L;
/*     */     }
/*     */ 
/* 372 */     return this.pingPeriod;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 377 */     return "ConnectionValidator[" + this.clientInvoker + ", pingPeriod=" + this.pingPeriod + " ms]";
/*     */   }
/*     */ 
/*     */   private void start()
/*     */   {
/* 388 */     this.configMap = createPingConfig(this.client.getConfiguration(), this.metadata);
/* 389 */     log.debug(this + " timeout: " + this.configMap.get("timeout"));
/* 390 */     log.debug(this + " ping retries: " + this.configMap.get("NumberOfCallRetries"));
/* 391 */     log.debug(this + " connection retries: " + this.configMap.get("NumberOfRetries"));
/* 392 */     this.locator = this.client.getInvoker().getLocator();
/*     */     try
/*     */     {
/* 396 */       this.clientInvoker = InvokerRegistry.createClientInvoker(this.locator, this.configMap);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 400 */       log.error("Unable to create client invoker for locator: " + this.locator);
/* 401 */       throw new RuntimeException("Unable to create client invoker for locator: " + this.locator, e);
/*     */     }
/*     */ 
/* 404 */     if (!this.clientInvoker.isConnected())
/*     */     {
/* 406 */       if (trace) log.trace("inner client invoker not connected, connecting ...");
/* 407 */       this.clientInvoker.connect();
/*     */     }
/*     */ 
/* 410 */     TimerUtil.schedule(this, this.pingPeriod);
/* 411 */     this.stopped = false;
/*     */ 
/* 413 */     log.debug(this + " started");
/*     */   }
/*     */ 
/*     */   private boolean doStop()
/*     */   {
/* 418 */     synchronized (this.lock)
/*     */     {
/* 420 */       if (!this.listeners.isEmpty())
/*     */       {
/* 422 */         this.listeners.clear();
/*     */       }
/* 424 */       this.stopped = true;
/*     */     }
/*     */ 
/* 427 */     if (this.clientInvoker != null)
/*     */     {
/* 429 */       InvokerRegistry.destroyClientInvoker(this.locator, this.configMap);
/*     */     }
/*     */ 
/* 432 */     TimerUtil.unschedule(this);
/*     */ 
/* 434 */     boolean result = super.cancel();
/* 435 */     log.debug(this + " stopped, returning " + result);
/* 436 */     return result;
/*     */   }
/*     */ 
/*     */   private void notifyListeners(Throwable thr)
/*     */   {
/* 441 */     Throwable t = thr;
/* 442 */     synchronized (this.listeners)
/*     */     {
/* 444 */       ListIterator itr = this.listeners.listIterator();
/* 445 */       while (itr.hasNext())
/*     */       {
/* 447 */         ConnectionListener listener = (ConnectionListener)itr.next();
/* 448 */         new Thread(listener, t) { private final ConnectionListener val$listener;
/*     */           private final Throwable val$t;
/*     */ 
/* 452 */           public void run() { this.val$listener.handleConnectionException(this.val$t, ConnectionValidator.this.client);
/*     */           }
/*     */         }
/* 448 */         .start();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 457 */     stop();
/* 458 */     this.listeners.clear();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.ConnectionValidator
 * JD-Core Version:    0.6.0
 */