/*    */ package org.jboss.remoting;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import java.util.Map;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ConnectionNotifier
/*    */ {
/* 16 */   private List listeners = new ArrayList();
/*    */ 
/* 18 */   private static final Logger log = Logger.getLogger(ConnectionNotifier.class);
/*    */ 
/*    */   public void addListener(ConnectionListener listener)
/*    */   {
/* 22 */     this.listeners.add(listener);
/*    */   }
/*    */ 
/*    */   public void removeListener(ConnectionListener listener)
/*    */   {
/* 27 */     this.listeners.remove(listener);
/*    */   }
/*    */ 
/*    */   public int size()
/*    */   {
/* 32 */     return this.listeners.size();
/*    */   }
/*    */ 
/*    */   public void connectionLost(String locatorurl, String clientSessionId, Map requestPayload)
/*    */   {
/*    */     try
/*    */     {
/* 39 */       log.debug("Server connection lost to client (session id = " + clientSessionId);
/* 40 */       Client client = new Client(new InvokerLocator(locatorurl), requestPayload);
/* 41 */       client.setSessionId(clientSessionId);
/* 42 */       ConnectionListener[] list = (ConnectionListener[])this.listeners.toArray(new ConnectionListener[this.listeners.size()]);
/* 43 */       for (int x = 0; x < list.length; x++)
/*    */       {
/* 45 */         list[x].handleConnectionException(null, client);
/*    */       }
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 50 */       log.error("Error notifying connection listeners of lost client connection.", e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void connectionTerminated(String locatorURL, String clientSessionId, Map requestPayload)
/*    */   {
/*    */     try
/*    */     {
/* 58 */       if (log.isTraceEnabled())
/*    */       {
/* 60 */         log.trace("Client disconnected (session id = " + clientSessionId);
/*    */       }
/* 62 */       Client client = new Client(new InvokerLocator(locatorURL), requestPayload);
/* 63 */       client.setSessionId(clientSessionId);
/* 64 */       ClientDisconnectedException ex = new ClientDisconnectedException();
/*    */ 
/* 66 */       ConnectionListener[] list = (ConnectionListener[])this.listeners.toArray(new ConnectionListener[this.listeners.size()]);
/* 67 */       for (int x = 0; x < list.length; x++)
/*    */       {
/* 69 */         list[x].handleConnectionException(ex, client);
/*    */       }
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 74 */       log.error("Error notifying connection listeners of disconnected client connection.", e);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.ConnectionNotifier
 * JD-Core Version:    0.6.0
 */