/*     */ package org.jboss.remoting;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.net.SocketFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.loading.ClassByteClassLoader;
/*     */ import org.jboss.remoting.marshal.MarshallLoaderFactory;
/*     */ import org.jboss.remoting.security.SSLSocketBuilder;
/*     */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*     */ import org.jboss.remoting.socketfactory.CreationListenerSocketFactory;
/*     */ import org.jboss.remoting.socketfactory.SocketCreationListener;
/*     */ import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public abstract class AbstractInvoker
/*     */   implements Invoker
/*     */ {
/*  61 */   protected static final Logger log = Logger.getLogger(AbstractInvoker.class);
/*     */   protected ClassByteClassLoader classbyteloader;
/*     */   protected InvokerLocator locator;
/*  64 */   protected Map localServerLocators = new HashMap();
/*     */   protected String serializationType;
/*  66 */   protected Map configuration = new HashMap();
/*     */   protected SocketFactory socketFactory;
/*     */   protected boolean socketFactoryCreatedFromSSLParameters;
/*     */ 
/*     */   public AbstractInvoker(InvokerLocator locator)
/*     */   {
/*  74 */     this(locator, null);
/*     */   }
/*     */ 
/*     */   public AbstractInvoker(InvokerLocator locator, Map configuration)
/*     */   {
/*     */     try
/*     */     {
/*  81 */       this.classbyteloader = ((ClassByteClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/*  85 */           return new ClassByteClassLoader(getClass().getClassLoader());
/*     */         }
/*     */       }));
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/*  91 */       log.error(e.toString(), e);
/*  92 */       throw new RuntimeException("Can't create a ClassLoader", e);
/*     */     }
/*  94 */     this.locator = locator;
/*     */ 
/*  96 */     if (configuration != null) {
/*  97 */       this.configuration.putAll(configuration);
/*     */     }
/*  99 */     if (locator.getParameters() != null) {
/* 100 */       this.configuration.putAll(locator.getParameters());
/*     */     }
/*     */     try
/*     */     {
/* 104 */       InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
/* 105 */       if (loaderLocator != null)
/*     */       {
/* 107 */         this.classbyteloader.setClientInvoker(new Client(loaderLocator));
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 112 */       log.error("Could not create remote class loading for invoker.", e);
/*     */     }
/*     */ 
/* 115 */     if ((locator == null) || (locator.getParameters() == null))
/*     */     {
/* 117 */       setSerializationType("java");
/*     */     }
/*     */     else
/*     */     {
/* 121 */       setSerializationType(locator.findSerializationType());
/*     */     }
/*     */   }
/*     */ 
/*     */   public InvokerLocator getLocator()
/*     */   {
/* 130 */     return this.locator;
/*     */   }
/*     */ 
/*     */   public String addClientLocator(String sessionId, InvokerCallbackHandler callbackhandler, InvokerLocator locator)
/*     */   {
/* 140 */     String listenerId = null;
/* 141 */     synchronized (this.localServerLocators)
/*     */     {
/* 143 */       Collection holders = this.localServerLocators.values();
/* 144 */       Iterator itr = holders.iterator();
/* 145 */       while (itr.hasNext())
/*     */       {
/* 147 */         CallbackHandlerHolder holder = (CallbackHandlerHolder)itr.next();
/* 148 */         InvokerCallbackHandler holderhandler = holder.getHandler();
/* 149 */         boolean handlersEqual = holderhandler.equals(callbackhandler);
/* 150 */         InvokerLocator handlerLocator = holder.getLocator();
/* 151 */         boolean locatorsEqual = handlerLocator.equals(locator);
/* 152 */         if ((handlersEqual) && (locatorsEqual))
/*     */         {
/* 155 */           return null;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 160 */       CallbackHandlerHolder holder = new CallbackHandlerHolder(callbackhandler, locator, null);
/* 161 */       listenerId = new GUID().toString();
/* 162 */       String key = listenerId;
/* 163 */       if (sessionId != null)
/* 164 */         key = sessionId + "+" + listenerId;
/* 165 */       this.localServerLocators.put(key, holder);
/*     */     }
/*     */ 
/* 168 */     return listenerId;
/*     */   }
/*     */ 
/*     */   public InvokerLocator getClientLocator(String listenerId)
/*     */   {
/* 177 */     InvokerLocator locator = null;
/* 178 */     if (listenerId != null)
/*     */     {
/* 180 */       CallbackHandlerHolder holder = (CallbackHandlerHolder)this.localServerLocators.get(listenerId);
/* 181 */       if (holder != null)
/*     */       {
/* 183 */         locator = holder.getLocator();
/*     */       }
/*     */     }
/* 186 */     return locator;
/*     */   }
/*     */ 
/*     */   public List getClientLocators(String sessionId, InvokerCallbackHandler handler)
/*     */   {
/* 191 */     List holderList = new ArrayList();
/* 192 */     if (handler != null)
/*     */     {
/* 194 */       synchronized (this.localServerLocators)
/*     */       {
/* 196 */         Set entries = this.localServerLocators.entrySet();
/* 197 */         Iterator itr = entries.iterator();
/* 198 */         while (itr.hasNext())
/*     */         {
/* 200 */           Map.Entry entry = (Map.Entry)itr.next();
/* 201 */           String listenerId = (String)entry.getKey();
/* 202 */           int index = listenerId.indexOf('+');
/* 203 */           String prefix = listenerId.substring(0, index);
/* 204 */           if (!sessionId.equals(prefix))
/*     */             continue;
/* 206 */           if (index >= 0)
/* 207 */             listenerId = listenerId.substring(index + 1);
/* 208 */           CallbackHandlerHolder holder = (CallbackHandlerHolder)entry.getValue();
/* 209 */           InvokerCallbackHandler holderHandler = holder.getHandler();
/* 210 */           if (holderHandler.equals(handler))
/*     */           {
/* 212 */             CallbackLocatorHolder locatorHolder = new CallbackLocatorHolder(listenerId, holder.getLocator());
/* 213 */             holderList.add(locatorHolder);
/*     */           }
/*     */         }
/*     */ 
/* 217 */         if (holderList.size() > 0)
/*     */         {
/* 219 */           for (int x = 0; x < holderList.size(); x++)
/*     */           {
/* 221 */             String listenerId = ((CallbackLocatorHolder)holderList.get(x)).getListenerId();
/* 222 */             String key = sessionId + "+" + listenerId;
/* 223 */             this.localServerLocators.remove(key);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 228 */     return holderList;
/*     */   }
/*     */ 
/*     */   public synchronized void setClassLoader(ClassLoader classloader)
/*     */   {
/*     */     try
/*     */     {
/* 240 */       this.classbyteloader = ((ClassByteClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/* 244 */           return new ClassByteClassLoader(getClass().getClassLoader());
/*     */         }
/*     */       }));
/*     */     }
/*     */     catch (PrivilegedActionException e) {
/* 250 */       log.error(e.toString(), e);
/* 251 */       throw new RuntimeException("Can't create a ClassLoader", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized ClassLoader getClassLoader()
/*     */   {
/* 257 */     return this.classbyteloader;
/*     */   }
/*     */ 
/*     */   public String getSerializationType()
/*     */   {
/* 262 */     return this.serializationType;
/*     */   }
/*     */ 
/*     */   public void setSerializationType(String serializationType)
/*     */   {
/* 267 */     this.serializationType = serializationType;
/*     */   }
/*     */ 
/*     */   public SocketFactory getSocketFactory()
/*     */   {
/* 272 */     return this.socketFactory;
/*     */   }
/*     */ 
/*     */   public void setSocketFactory(SocketFactory socketFactory)
/*     */   {
/* 277 */     this.socketFactory = socketFactory;
/*     */   }
/*     */ 
/*     */   public boolean isSocketFactoryCreatedFromSSLParameters()
/*     */   {
/* 282 */     return this.socketFactoryCreatedFromSSLParameters;
/*     */   }
/*     */ 
/*     */   protected SocketFactory createSocketFactory(Map configuration)
/*     */   {
/* 290 */     if (configuration == null) {
/* 291 */       return null;
/*     */     }
/* 293 */     if (this.socketFactory != null) {
/* 294 */       return this.socketFactory;
/*     */     }
/* 296 */     SocketFactory factory = null;
/*     */ 
/* 298 */     Object obj = configuration.get("customSocketFactory");
/* 299 */     if (obj != null)
/*     */     {
/* 301 */       if ((obj instanceof SocketFactory))
/*     */       {
/* 303 */         factory = (SocketFactory)obj;
/*     */       }
/*     */       else
/*     */       {
/* 307 */         throw new RuntimeException("Can not set custom socket factory (" + obj + ") as is not of type javax.net.SocketFactory");
/*     */       }
/*     */     }
/*     */ 
/* 311 */     if (factory == null)
/*     */     {
/* 313 */       String socketFactoryString = (String)configuration.get("socketFactory");
/* 314 */       if ((socketFactoryString != null) && (socketFactoryString.length() > 0))
/*     */       {
/*     */         try
/*     */         {
/* 318 */           Class cl = ClassLoaderUtility.loadClass(socketFactoryString, getClass());
/*     */ 
/* 320 */           Constructor socketFactoryConstructor = null;
/* 321 */           socketFactoryConstructor = cl.getConstructor(new Class[0]);
/* 322 */           factory = (SocketFactory)socketFactoryConstructor.newInstance(new Object[0]);
/* 323 */           log.trace("SocketFactory (" + socketFactoryString + ") loaded");
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 327 */           log.debug("Could not create socket factory by classname (" + socketFactoryString + ").  Error message: " + e.getMessage());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 332 */     if ((factory == null) && (needsCustomSSLConfiguration(configuration)))
/*     */     {
/*     */       try
/*     */       {
/* 336 */         SSLSocketBuilder socketBuilder = new SSLSocketBuilder(configuration);
/* 337 */         socketBuilder.setUseSSLSocketFactory(false);
/* 338 */         factory = socketBuilder.createSSLSocketFactory();
/* 339 */         this.socketFactoryCreatedFromSSLParameters = true;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 343 */         throw new RuntimeException("Unable to create customized SSL socket factory", e);
/*     */       }
/*     */     }
/*     */ 
/* 347 */     return wrapSocketFactory(factory, configuration);
/*     */   }
/*     */ 
/*     */   public static SocketFactory wrapSocketFactory(SocketFactory socketFactory, Map config)
/*     */   {
/* 353 */     if (config == null) {
/* 354 */       return socketFactory;
/*     */     }
/* 356 */     Object o = config.get("socketCreationClientListener");
/*     */ 
/* 358 */     if (o == null) {
/* 359 */       return socketFactory;
/*     */     }
/* 361 */     if ((o instanceof SocketCreationListener))
/*     */     {
/* 363 */       SocketCreationListener listener = (SocketCreationListener)o;
/* 364 */       return new CreationListenerSocketFactory(socketFactory, listener);
/*     */     }
/* 366 */     if ((o instanceof String))
/*     */     {
/*     */       try
/*     */       {
/* 370 */         Class c = ClassLoaderUtility.loadClass((String)o, AbstractInvoker.class);
/* 371 */         SocketCreationListener listener = (SocketCreationListener)c.newInstance();
/* 372 */         return new CreationListenerSocketFactory(socketFactory, listener);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 376 */         log.error("unable to instantiate class: " + o, e);
/* 377 */         return socketFactory;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 382 */     log.error("unrecognized type for socket creation client listener: " + o);
/* 383 */     return socketFactory;
/*     */   }
/*     */ 
/*     */   public static boolean isCompleteSocketFactory(SocketFactory sf)
/*     */   {
/* 390 */     if (sf != null)
/*     */     {
/* 392 */       if ((!(sf instanceof SocketFactoryWrapper)) || (((SocketFactoryWrapper)sf).getSocketFactory() != null))
/*     */       {
/* 394 */         return true;
/*     */       }
/*     */     }
/* 396 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean needsCustomSSLConfiguration(Map configuration)
/*     */   {
/* 419 */     return (configuration.get("org.jboss.remoting.keyAlias") != null) || (configuration.get("org.jboss.remoting.clientAuthMode") != null) || (configuration.get("org.jboss.remoting.serverAuthMode") != null) || (configuration.get("org.jboss.remoting.sslProtocol") != null) || (configuration.get("org.jboss.remoting.sslProviderName") != null) || (configuration.get("org.jboss.remoting.serversocket.useClientMode") != null) || (configuration.get("org.jboss.remoting.socket.useClientMode") != null) || (configuration.get("org.jboss.remoting.keyPassword") != null) || (configuration.get("org.jboss.remoting.keyStoreAlgorithm") != null) || (configuration.get("org.jboss.remoting.keyStore") != null) || (configuration.get("org.jboss.remoting.keyStorePassword") != null) || (configuration.get("org.jboss.remoting.keyStoreType") != null) || (configuration.get("org.jboss.remoting.trustStoreAlgorithm") != null) || (configuration.get("org.jboss.remoting.trustStore") != null) || (configuration.get("org.jboss.remoting.trustStorePassword") != null) || (configuration.get("org.jboss.remoting.trustStoreType") != null);
/*     */   }
/*     */ 
/*     */   public class CallbackLocatorHolder
/*     */   {
/*     */     private InvokerLocator locator;
/*     */     private String listenerId;
/*     */ 
/*     */     public CallbackLocatorHolder(String listenerId, InvokerLocator locator)
/*     */     {
/* 453 */       this.listenerId = listenerId;
/* 454 */       this.locator = locator;
/*     */     }
/*     */ 
/*     */     public String getListenerId()
/*     */     {
/* 459 */       return this.listenerId;
/*     */     }
/*     */ 
/*     */     public InvokerLocator getLocator()
/*     */     {
/* 464 */       return this.locator;
/*     */     }
/*     */   }
/*     */ 
/*     */   private class CallbackHandlerHolder
/*     */   {
/*     */     private InvokerCallbackHandler handler;
/*     */     private InvokerLocator locator;
/*     */     private final AbstractInvoker this$0;
/*     */ 
/*     */     private CallbackHandlerHolder(InvokerCallbackHandler handler, InvokerLocator locator)
/*     */     {
/* 431 */       this.handler = handler;
/* 432 */       this.locator = locator;
/*     */     }
/*     */ 
/*     */     public InvokerCallbackHandler getHandler()
/*     */     {
/* 437 */       return this.handler;
/*     */     }
/*     */ 
/*     */     public InvokerLocator getLocator()
/*     */     {
/* 442 */       return this.locator;
/*     */     }
/*     */ 
/*     */     CallbackHandlerHolder(InvokerCallbackHandler x1, InvokerLocator x2, AbstractInvoker.1 x3)
/*     */     {
/* 424 */       this(x1, x2);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.AbstractInvoker
 * JD-Core Version:    0.6.0
 */