/*     */ package org.jboss.reflect.spi;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.reflect.plugins.ClassInfoImpl;
/*     */ import org.jboss.reflect.plugins.ValueConvertor;
/*     */ import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
/*     */ 
/*     */ public class PrimitiveInfo extends AbstractTypeInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3256718498443835449L;
/*  44 */   public static final PrimitiveInfo BOOLEAN = new PrimitiveInfo("boolean", 0, Boolean.TYPE);
/*     */ 
/*  47 */   public static final PrimitiveInfo BYTE = new PrimitiveInfo("byte", 1, Byte.TYPE);
/*     */ 
/*  50 */   public static final PrimitiveInfo CHAR = new PrimitiveInfo("char", 2, Character.TYPE);
/*     */ 
/*  53 */   public static final PrimitiveInfo DOUBLE = new PrimitiveInfo("double", 3, Double.TYPE);
/*     */ 
/*  56 */   public static final PrimitiveInfo FLOAT = new PrimitiveInfo("float", 4, Float.TYPE);
/*     */ 
/*  59 */   public static final PrimitiveInfo INT = new PrimitiveInfo("int", 5, Integer.TYPE);
/*     */ 
/*  62 */   public static final PrimitiveInfo LONG = new PrimitiveInfo("long", 6, Long.TYPE);
/*     */ 
/*  65 */   public static final PrimitiveInfo SHORT = new PrimitiveInfo("short", 7, Short.TYPE);
/*     */ 
/*  68 */   public static final PrimitiveInfo VOID = new PrimitiveInfo("void", 8, Void.TYPE);
/*     */ 
/*  71 */   private static final PrimitiveInfo[] values = { BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, VOID };
/*     */ 
/*  74 */   protected static final TypeInfoFactory typeInfoFactory = new IntrospectionTypeInfoFactory();
/*     */   protected final transient String name;
/*     */   protected final int ordinal;
/*     */   protected final transient Class<? extends Object> type;
/*  86 */   private static final HashMap<String, PrimitiveInfo> map = new HashMap();
/*     */ 
/*     */   public static PrimitiveInfo valueOf(String name)
/*     */   {
/* 109 */     return (PrimitiveInfo)map.get(name);
/*     */   }
/*     */ 
/*     */   protected PrimitiveInfo(String name, int ordinal, Class<? extends Object> type)
/*     */   {
/* 121 */     this.name = name;
/* 122 */     this.ordinal = ordinal;
/* 123 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public int ordinal()
/*     */   {
/* 133 */     return this.ordinal;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 138 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */   {
/* 143 */     return this.type.getSimpleName();
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public Class<?> getType() {
/* 149 */     return this.type;
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value) throws Throwable
/*     */   {
/* 154 */     Object progressResult = ValueConvertor.progressValue(this.type, value);
/* 155 */     if (progressResult != null)
/*     */     {
/* 157 */       return progressResult;
/*     */     }
/* 159 */     return ValueConvertor.convertValue(this.type, value);
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value, boolean replaceProperties) throws Throwable
/*     */   {
/* 164 */     Object progressResult = ValueConvertor.progressValue(this.type, value);
/* 165 */     if (progressResult != null)
/*     */     {
/* 167 */       return progressResult;
/*     */     }
/* 169 */     return ValueConvertor.convertValue(this.type, value, replaceProperties);
/*     */   }
/*     */ 
/*     */   public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable
/*     */   {
/* 174 */     Object progressResult = ValueConvertor.progressValue(this.type, value);
/* 175 */     if (progressResult != null)
/*     */     {
/* 177 */       return progressResult;
/*     */     }
/* 179 */     return ValueConvertor.convertValue(this.type, value, replaceProperties, trim);
/*     */   }
/*     */ 
/*     */   public boolean isPrimitive()
/*     */   {
/* 185 */     return true;
/*     */   }
/*     */ 
/*     */   public TypeInfo getArrayType()
/*     */   {
/* 190 */     Class arrayClass = ClassInfoImpl.getArrayClass(getType());
/* 191 */     return typeInfoFactory.getTypeInfo(arrayClass);
/*     */   }
/*     */ 
/*     */   public Object newArrayInstance(int size) throws Throwable
/*     */   {
/* 196 */     throw new UnsupportedOperationException("Not an array " + this.name);
/*     */   }
/*     */ 
/*     */   public boolean isAssignableFrom(TypeInfo info)
/*     */   {
/* 202 */     if (info == this) {
/* 203 */       return true;
/*     */     }
/*     */     try
/*     */     {
/* 207 */       ProgressionConvertor pc = ProgressionConvertorFactory.getInstance().getConvertor();
/* 208 */       return pc.canProgress(getType(), info.getType());
/*     */     }
/*     */     catch (Throwable throwable) {
/*     */     }
/* 212 */     return false;
/*     */   }
/*     */ 
/*     */   public TypeInfoFactory getTypeInfoFactory()
/*     */   {
/* 219 */     return typeInfoFactory;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 225 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String toShortString()
/*     */   {
/* 231 */     return this.name;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 237 */     if (obj == this)
/* 238 */       return true;
/* 239 */     if (obj == null)
/* 240 */       return false;
/* 241 */     if (!(obj instanceof PrimitiveInfo))
/* 242 */       return false;
/* 243 */     if (!obj.getClass().equals(getClass()))
/* 244 */       return false;
/* 245 */     PrimitiveInfo other = (PrimitiveInfo)obj;
/* 246 */     return other.ordinal == this.ordinal;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 252 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   Object readResolve() throws ObjectStreamException
/*     */   {
/* 257 */     return values[this.ordinal];
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  90 */     map.put("boolean", BOOLEAN);
/*  91 */     map.put("byte", BYTE);
/*  92 */     map.put("char", CHAR);
/*  93 */     map.put("double", DOUBLE);
/*  94 */     map.put("float", FLOAT);
/*  95 */     map.put("int", INT);
/*  96 */     map.put("long", LONG);
/*  97 */     map.put("short", SHORT);
/*  98 */     map.put("void", VOID);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.spi.PrimitiveInfo
 * JD-Core Version:    0.6.0
 */