/*     */ package org.jboss.reflect.plugins.javassist;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ class SignatureKey
/*     */ {
/*     */   String name;
/*     */   String[] params;
/*  45 */   private transient int cachedHashCode = -2147483648;
/*     */ 
/*     */   public SignatureKey(String name, TypeInfo[] typeInfos)
/*     */   {
/*  55 */     this.name = name;
/*  56 */     if ((typeInfos != null) && (typeInfos.length > 0))
/*     */     {
/*  58 */       this.params = new String[typeInfos.length];
/*  59 */       for (int i = 0; i < typeInfos.length; i++)
/*  60 */         this.params[i] = typeInfos[i].getName();
/*     */     }
/*     */   }
/*     */ 
/*     */   public SignatureKey(String name, String[] params)
/*     */   {
/*  72 */     this.name = name;
/*  73 */     if ((params != null) && (params.length > 0))
/*  74 */       this.params = params;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  79 */     if (obj == this)
/*  80 */       return true;
/*  81 */     if ((obj == null) || (!(obj instanceof SignatureKey))) {
/*  82 */       return false;
/*     */     }
/*  84 */     SignatureKey other = (SignatureKey)obj;
/*     */ 
/*  86 */     if ((this.name == null) && (other.name != null))
/*  87 */       return false;
/*  88 */     if ((this.name != null) && (other.name == null))
/*  89 */       return false;
/*  90 */     if ((this.name != null) && (!this.name.equals(other.name))) {
/*  91 */       return false;
/*     */     }
/*  93 */     if ((this.params == null) && (other.params == null))
/*  94 */       return true;
/*  95 */     if ((this.params == null) && (other.params != null))
/*  96 */       return false;
/*  97 */     if ((this.params != null) && (other.params == null)) {
/*  98 */       return false;
/*     */     }
/* 100 */     if (this.params.length != other.params.length) {
/* 101 */       return false;
/*     */     }
/* 103 */     for (int i = 0; i < this.params.length; i++)
/*     */     {
/* 105 */       if (!this.params[i].equals(other.params[i]))
/* 106 */         return false;
/*     */     }
/* 108 */     return true;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 113 */     if (this.cachedHashCode == -2147483648)
/*     */     {
/* 115 */       JBossStringBuilder builder = new JBossStringBuilder();
/* 116 */       if (this.name != null)
/* 117 */         builder.append(this.name);
/* 118 */       if (this.params != null)
/*     */       {
/* 120 */         for (int i = 0; i < this.params.length; i++)
/* 121 */           builder.append(this.params[i]);
/*     */       }
/* 123 */       this.cachedHashCode = builder.toString().hashCode();
/*     */     }
/* 125 */     return this.cachedHashCode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 130 */     if (this.params == null)
/* 131 */       return this.name + "[]";
/* 132 */     return this.name + Arrays.asList(this.params);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.javassist.SignatureKey
 * JD-Core Version:    0.6.0
 */