/*     */ package org.jboss.reflect.plugins.introspection;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public class ReflectionUtils
/*     */ {
/*     */   public static Object invoke(Method method, Object target, Object[] arguments)
/*     */     throws Throwable
/*     */   {
/*  52 */     if (method == null)
/*  53 */       throw new IllegalArgumentException("Null method");
/*     */     try
/*     */     {
/*  56 */       return method.invoke(target, arguments);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  60 */     throw handleErrors(method.getName(), Strings.defaultToString(target), method.getParameterTypes(), arguments, t);
/*     */   }
/*     */ 
/*     */   public static Object newInstance(Class clazz)
/*     */     throws Throwable
/*     */   {
/*  73 */     if (clazz == null)
/*  74 */       throw new IllegalArgumentException("Null clazz");
/*     */     try
/*     */     {
/*  77 */       return clazz.newInstance();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  81 */     throw handleErrors("new", clazz.getName(), null, null, t);
/*     */   }
/*     */ 
/*     */   public static Object newInstance(String className, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/*  95 */     if (className == null)
/*  96 */       throw new IllegalArgumentException("Null class name");
/*  97 */     if (cl == null)
/*  98 */       throw new IllegalArgumentException("Null classloader");
/*  99 */     Class clazz = cl.loadClass(className);
/*     */     try
/*     */     {
/* 102 */       return clazz.newInstance();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 106 */     throw handleErrors("new", clazz.getName(), null, null, t);
/*     */   }
/*     */ 
/*     */   public static Object newInstance(String className)
/*     */     throws Throwable
/*     */   {
/* 119 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 120 */     return newInstance(className, cl);
/*     */   }
/*     */ 
/*     */   public static Object newInstance(Constructor constructor, Object[] arguments)
/*     */     throws Throwable
/*     */   {
/* 133 */     if (constructor == null)
/* 134 */       throw new IllegalArgumentException("Null constructor");
/*     */     try
/*     */     {
/* 137 */       return constructor.newInstance(arguments);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 141 */     throw handleErrors("new", constructor.getClass().getName(), constructor.getParameterTypes(), arguments, t);
/*     */   }
/*     */ 
/*     */   public static Object getField(Field field, Object target)
/*     */     throws Throwable
/*     */   {
/* 155 */     if (field == null)
/* 156 */       throw new IllegalArgumentException("Null field");
/*     */     try
/*     */     {
/* 159 */       return field.get(target);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 163 */     throw handleErrors("set", field, target, null, t);
/*     */   }
/*     */ 
/*     */   public static Object setField(Field field, Object target, Object value)
/*     */     throws Throwable
/*     */   {
/* 178 */     if (field == null)
/* 179 */       throw new IllegalArgumentException("Null field");
/*     */     try
/*     */     {
/* 182 */       field.set(target, value);
/* 183 */       return null;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 187 */     throw handleErrors("set", field, target, value, t);
/*     */   }
/*     */ 
/*     */   protected static Object arrayInfo(Object[] objects)
/*     */   {
/* 200 */     return objects == null ? "<null>" : Arrays.asList(objects);
/*     */   }
/*     */ 
/*     */   public static Method findMethod(Class clazz, String name, Class<?>[] parameterTypes)
/*     */   {
/* 213 */     if (clazz == null) {
/* 214 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 218 */       return clazz.getDeclaredMethod(name, parameterTypes);
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/* 223 */     return findMethod(clazz.getSuperclass(), name, parameterTypes);
/*     */   }
/*     */ 
/*     */   public static Method findExactMethod(Class clazz, String name, Class<?>[] parameterTypes)
/*     */     throws NoSuchMethodException
/*     */   {
/* 238 */     Method method = findMethod(clazz, name, parameterTypes);
/* 239 */     if (method == null)
/* 240 */       throw new NoSuchMethodException(clazz + "." + name + " - " + arrayInfo(parameterTypes));
/* 241 */     return method;
/*     */   }
/*     */ 
/*     */   public static Field findField(Class clazz, String name)
/*     */   {
/* 253 */     if (clazz == null) {
/* 254 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 258 */       return clazz.getDeclaredField(name);
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/* 263 */     return findField(clazz.getSuperclass(), name);
/*     */   }
/*     */ 
/*     */   public static Field findExactField(Class clazz, String name)
/*     */     throws NoSuchFieldException
/*     */   {
/* 277 */     Field field = findField(clazz, name);
/* 278 */     if (field == null)
/* 279 */       throw new NoSuchFieldException(clazz + "." + name);
/* 280 */     return field;
/*     */   }
/*     */ 
/*     */   public static Constructor findConstructor(Class clazz, Class<?>[] parameterTypes)
/*     */   {
/* 292 */     if (clazz == null) {
/* 293 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 297 */       return clazz.getDeclaredConstructor(parameterTypes);
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/* 302 */     return findConstructor(clazz.getSuperclass(), parameterTypes);
/*     */   }
/*     */ 
/*     */   public static Constructor findExactConstructor(Class clazz, Class<?>[] parameterTypes)
/*     */     throws NoSuchMethodException
/*     */   {
/* 316 */     Constructor constructor = findConstructor(clazz, parameterTypes);
/* 317 */     if (constructor == null)
/* 318 */       throw new NoSuchMethodException(clazz + " - " + arrayInfo(parameterTypes));
/* 319 */     return constructor;
/*     */   }
/*     */ 
/*     */   public static Throwable handleErrors(String context, Object target, Class[] parameters, Object[] arguments, Throwable t)
/*     */     throws Throwable
/*     */   {
/* 335 */     if ((t instanceof IllegalArgumentException))
/*     */     {
/* 337 */       if (target == null)
/* 338 */         throw new IllegalArgumentException("Null target for " + context);
/* 339 */       ArrayList expected = new ArrayList();
/* 340 */       if (parameters != null)
/*     */       {
/* 342 */         for (int i = 0; i < parameters.length; i++)
/* 343 */           expected.add(parameters[i].getName());
/*     */       }
/* 345 */       ArrayList actual = new ArrayList();
/* 346 */       if (arguments != null)
/*     */       {
/* 348 */         for (int i = 0; i < arguments.length; i++)
/*     */         {
/* 350 */           if (arguments[i] == null)
/* 351 */             actual.add(null);
/*     */           else
/* 353 */             actual.add(arguments[i].getClass().getName());
/*     */         }
/*     */       }
/* 356 */       throw new IllegalArgumentException("Wrong arguments. " + context + " for target " + target + " expected=" + expected + " actual=" + actual);
/*     */     }
/* 358 */     if ((t instanceof InvocationTargetException))
/*     */     {
/* 360 */       throw ((InvocationTargetException)t).getTargetException();
/*     */     }
/* 362 */     throw t;
/*     */   }
/*     */ 
/*     */   public static Throwable handleErrors(String context, Field field, Object target, Object value, Throwable t)
/*     */     throws Throwable
/*     */   {
/* 378 */     if ((t instanceof IllegalArgumentException))
/*     */     {
/* 380 */       String valueType = null;
/* 381 */       if (value != null)
/* 382 */         valueType = value.getClass().getName();
/* 383 */       throw new IllegalArgumentException("Error invoking field " + context + " for target " + target + " field " + field.getName() + " expected=" + field.getType().getName() + " actual=" + valueType);
/*     */     }
/* 385 */     throw t;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.introspection.ReflectionUtils
 * JD-Core Version:    0.6.0
 */