/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.EnumConstantInfo;
/*     */ import org.jboss.reflect.spi.EnumInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class EnumConstantInfoImpl extends AnnotationHolder
/*     */   implements EnumConstantInfo
/*     */ {
/*     */   private static final long serialVersionUID = 3761411923568243761L;
/*     */   protected String name;
/*     */   protected EnumInfo declaring;
/*  47 */   protected int hash = -1;
/*     */ 
/*     */   public EnumConstantInfoImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public EnumConstantInfoImpl(String name, EnumInfo declaring)
/*     */   {
/*  64 */     this.name = name;
/*  65 */     this.declaring = declaring;
/*     */   }
/*     */ 
/*     */   public EnumConstantInfoImpl(String name, EnumInfo declaring, AnnotationValue[] annotations)
/*     */   {
/*  77 */     super(annotations);
/*  78 */     this.name = name;
/*  79 */     this.declaring = declaring;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  84 */     return this.name;
/*     */   }
/*     */ 
/*     */   public EnumInfo getDeclaring()
/*     */   {
/*  89 */     return this.declaring;
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/*  94 */     return this.declaring.getEnumValue(getName());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 100 */     if (this == o) return true;
/* 101 */     if ((o == null) || (!(o instanceof EnumConstantInfo))) return false;
/*     */ 
/* 103 */     EnumConstantInfo enumConstantInfo = (EnumConstantInfo)o;
/*     */ 
/* 105 */     if (!this.name.equals(enumConstantInfo.getName())) {
/* 106 */       return false;
/*     */     }
/* 108 */     return this.declaring.equals(enumConstantInfo.getDeclaring());
/*     */   }
/*     */ 
/*     */   public int getHashCode()
/*     */   {
/* 116 */     int result = this.name.hashCode();
/* 117 */     result = 29 * result + this.declaring.hashCode();
/* 118 */     return result;
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 124 */     buffer.append(this.name);
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 130 */     buffer.append("name=").append(this.name);
/* 131 */     buffer.append(" declaring=").append(this.declaring);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.EnumConstantInfoImpl
 * JD-Core Version:    0.6.0
 */