/*     */ package org.jboss.reflect.plugins;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.reflect.spi.AbstractValue;
/*     */ import org.jboss.reflect.spi.AnnotationInfo;
/*     */ import org.jboss.reflect.spi.AnnotationValue;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.Value;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class AnnotationValueImpl extends AbstractValue
/*     */   implements AnnotationValue
/*     */ {
/*     */   private static final long serialVersionUID = 3257290210164289843L;
/*     */   protected AnnotationInfo annotationType;
/*     */   protected HashMap<String, Value> attributeValues;
/*     */   protected Annotation underlying;
/*  56 */   protected int hash = -1;
/*     */ 
/*     */   public AnnotationValueImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   @Deprecated
/*     */   public AnnotationValueImpl(AnnotationInfo annotationType, HashMap<String, Value> attributeValues)
/*     */   {
/*  74 */     this(annotationType, attributeValues, null);
/*     */   }
/*     */ 
/*     */   public AnnotationValueImpl(AnnotationInfo annotationType, HashMap<String, Value> attributeValues, Annotation underlying)
/*     */   {
/*  86 */     if (annotationType == null)
/*  87 */       throw new IllegalArgumentException("Null annotationType");
/*  88 */     if (attributeValues == null) {
/*  89 */       throw new IllegalArgumentException("Null attribute values");
/*     */     }
/*  91 */     this.annotationType = annotationType;
/*  92 */     this.attributeValues = attributeValues;
/*  93 */     this.underlying = underlying;
/*  94 */     calculateHash();
/*     */   }
/*     */ 
/*     */   public boolean isAnnotation()
/*     */   {
/* 100 */     return true;
/*     */   }
/*     */ 
/*     */   public AnnotationInfo getAnnotationType()
/*     */   {
/* 105 */     return this.annotationType;
/*     */   }
/*     */ 
/*     */   public Value getValue(String attributeName)
/*     */   {
/* 110 */     return (Value)this.attributeValues.get(attributeName);
/*     */   }
/*     */ 
/*     */   public Map<String, Value> getValues()
/*     */   {
/* 115 */     return this.attributeValues;
/*     */   }
/*     */ 
/*     */   public TypeInfo getType()
/*     */   {
/* 120 */     return this.annotationType;
/*     */   }
/*     */ 
/*     */   public Annotation getUnderlyingAnnotation()
/*     */   {
/* 125 */     return this.underlying;
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getUnderlyingAnnotation(Class<T> annotationType)
/*     */   {
/* 130 */     return (Annotation)annotationType.cast(this.underlying);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 135 */     if (this == o) return true;
/* 136 */     if ((o == null) || (!(o instanceof AnnotationValue))) return false;
/*     */ 
/* 138 */     AnnotationValue annotationValue = (AnnotationValue)o;
/*     */ 
/* 140 */     if (!this.annotationType.equals(annotationValue.getAnnotationType())) return false;
/* 141 */     if (!this.attributeValues.equals(annotationValue.getValues())) return false;
/*     */ 
/* 143 */     Annotation otherUnderlying = annotationValue.getUnderlyingAnnotation();
/* 144 */     if ((this.underlying == null) && (otherUnderlying != null))
/* 145 */       return false;
/* 146 */     if ((this.underlying != null) && (otherUnderlying == null))
/* 147 */       return false;
/* 148 */     return this.underlying.equals(otherUnderlying);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 153 */     return this.hash;
/*     */   }
/*     */ 
/*     */   protected void calculateHash()
/*     */   {
/* 162 */     int result = this.annotationType != null ? this.annotationType.hashCode() : 0;
/* 163 */     result = 29 * result + this.attributeValues.hashCode();
/* 164 */     this.hash = result;
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 169 */     buffer.append(this.annotationType.getName());
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 174 */     buffer.append("name=").append(this.annotationType.getName());
/* 175 */     if ((this.attributeValues != null) && (this.attributeValues.size() > 0))
/* 176 */       buffer.append(" values=").append(this.attributeValues);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.reflect.plugins.AnnotationValueImpl
 * JD-Core Version:    0.6.0
 */