/*     */ package org.jboss.proxy.ejb.handle;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.AccessControlException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ 
/*     */ public class StatefulHandleImpl
/*     */   implements Handle
/*     */ {
/*  62 */   private static final Logger log = Logger.getLogger(StatefulHandleImpl.class);
/*     */   static final long serialVersionUID = -6324520755180597156L;
/*     */   protected static final Method GET_EJB_OBJECT;
/*  71 */   private Object invokerID = null;
/*     */   public int objectName;
/*     */   public String jndiName;
/*     */   public String invokerProxyBinding;
/*     */   public Invoker invoker;
/*     */   public Object id;
/*     */   protected Hashtable jndiEnv;
/*     */ 
/*     */   public StatefulHandleImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public StatefulHandleImpl(int objectName, String jndiName, Invoker invoker, String invokerProxyBinding, Object id, Object invokerID)
/*     */   {
/* 119 */     this.jndiName = jndiName;
/* 120 */     this.id = id;
/* 121 */     this.jndiEnv = ((Hashtable)NamingContextFactory.lastInitialContextEnv.get());
/*     */     try
/*     */     {
/* 124 */       String property = System.getProperty("org.jboss.ejb.sfsb.handle.V327");
/* 125 */       if (property != null)
/*     */       {
/* 127 */         this.invokerProxyBinding = invokerProxyBinding;
/* 128 */         this.invokerID = invokerID;
/* 129 */         this.objectName = objectName;
/* 130 */         this.invoker = invoker;
/*     */       }
/*     */     }
/*     */     catch (AccessControlException ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getID()
/*     */   {
/* 144 */     return this.id;
/*     */   }
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/* 152 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject()
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 177 */       InitialContext ic = null;
/* 178 */       if (this.jndiEnv != null)
/* 179 */         ic = new InitialContext(this.jndiEnv);
/*     */       else {
/* 181 */         ic = new InitialContext();
/*     */       }
/* 183 */       Proxy proxy = (Proxy)ic.lookup(this.jndiName);
/*     */ 
/* 186 */       InvocationHandler ih = Proxy.getInvocationHandler(proxy);
/* 187 */       return (EJBObject)ih.invoke(proxy, GET_EJB_OBJECT, new Object[] { this.id });
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 191 */       throw e;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 195 */       t.printStackTrace();
/* 196 */     }throw new RemoteException("Error during getEJBObject", t);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  80 */       GET_EJB_OBJECT = Handle.class.getMethod("getEJBObject", new Class[0]);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  84 */       e.printStackTrace();
/*  85 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.handle.StatefulHandleImpl
 * JD-Core Version:    0.6.0
 */