/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.proxy.Interceptor;
/*     */ import org.jboss.proxy.ejb.handle.StatefulHandleImpl;
/*     */ 
/*     */ public class StatefulSessionInterceptor extends GenericEJBInterceptor
/*     */ {
/*     */   private static final long serialVersionUID = -4333233488946091285L;
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  62 */     InvocationContext ctx = invocation.getInvocationContext();
/*     */ 
/*  64 */     Method m = invocation.getMethod();
/*     */ 
/*  67 */     if (m.equals(TO_STRING))
/*     */     {
/*  69 */       return toString(ctx);
/*     */     }
/*  71 */     if (m.equals(EQUALS))
/*     */     {
/*  73 */       Object[] args = invocation.getArguments();
/*  74 */       String argsString = args[0] != null ? args[0].toString() : "";
/*  75 */       String thisString = toString(ctx);
/*  76 */       return new Boolean(thisString.equals(argsString));
/*     */     }
/*  78 */     if (m.equals(HASH_CODE))
/*     */     {
/*  80 */       return new Integer(ctx.getCacheId().hashCode());
/*     */     }
/*     */ 
/*  83 */     if (m.equals(GET_HANDLE))
/*     */     {
/*  85 */       int objectName = ((Integer)ctx.getObjectName()).intValue();
/*  86 */       String jndiName = (String)ctx.getValue(InvocationKey.JNDI_NAME);
/*  87 */       Invoker invoker = ctx.getInvoker();
/*  88 */       Object id = ctx.getCacheId();
/*  89 */       return new StatefulHandleImpl(objectName, jndiName, invoker, ctx.getInvokerProxyBinding(), id, ctx.getValue("InvokerID"));
/*     */     }
/*     */ 
/*  97 */     if (m.equals(GET_EJB_HOME))
/*     */     {
/*  99 */       return getEJBHome(invocation);
/*     */     }
/* 101 */     if (m.equals(GET_PRIMARY_KEY))
/*     */     {
/* 103 */       throw new RemoteException("Call to getPrimaryKey not allowed on session bean");
/*     */     }
/* 105 */     if (m.equals(IS_IDENTICAL))
/*     */     {
/* 107 */       Object[] args = invocation.getArguments();
/* 108 */       String argsString = args[0].toString();
/* 109 */       String thisString = toString(ctx);
/* 110 */       return new Boolean(thisString.equals(argsString));
/*     */     }
/*     */ 
/* 116 */     invocation.setType(InvocationType.REMOTE);
/*     */ 
/* 119 */     invocation.setId(ctx.getCacheId());
/*     */ 
/* 121 */     return getNext().invoke(invocation);
/*     */   }
/*     */ 
/*     */   private String toString(InvocationContext ctx)
/*     */   {
/* 127 */     return ctx.getValue(InvocationKey.JNDI_NAME) + ":" + ctx.getCacheId().toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.StatefulSessionInterceptor
 * JD-Core Version:    0.6.0
 */