/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.rmi.ServerException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EJBProxyFactory;
/*     */ import org.jboss.ejb.EJBProxyFactoryContainer;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.metadata.InvokerProxyBindingMetaData;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.SessionMetaData;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.proxy.ClientContainer;
/*     */ import org.jboss.proxy.ClientContainerEx;
/*     */ import org.jboss.proxy.IClientContainer;
/*     */ import org.jboss.proxy.Interceptor;
/*     */ import org.jboss.proxy.ejb.handle.HomeHandleImpl;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class ProxyFactory
/*     */   implements EJBProxyFactory
/*     */ {
/*     */   protected static final String HOME_INTERCEPTOR = "home";
/*     */   protected static final String BEAN_INTERCEPTOR = "bean";
/*     */   protected static final String LIST_ENTITY_INTERCEPTOR = "list-entity";
/*  95 */   protected static Logger log = Logger.getLogger(ProxyFactory.class);
/*     */   public EJBMetaData ejbMetaData;
/*     */   protected boolean isServiceEndpointOnly;
/*     */   protected EJBHome home;
/*     */   protected EJBObject statelessObject;
/*     */   protected String jndiBinding;
/*     */   protected ObjectName jmxName;
/*     */   protected int jmxNameHash;
/*     */   private Integer jmxNameHashInteger;
/*     */   protected Invoker beanInvoker;
/*     */   protected Invoker homeInvoker;
/*     */   protected InvokerProxyBindingMetaData invokerMetaData;
/* 124 */   protected ArrayList homeInterceptorClasses = new ArrayList();
/*     */ 
/* 128 */   protected ArrayList beanInterceptorClasses = new ArrayList();
/*     */ 
/* 132 */   protected ArrayList listEntityInterceptorClasses = new ArrayList();
/*     */   protected boolean includeIClientIface;
/*     */   protected Container container;
/*     */   protected Constructor proxyClassConstructor;
/*     */ 
/*     */   public void setContainer(Container con)
/*     */   {
/* 145 */     this.container = con;
/*     */   }
/*     */ 
/*     */   public void setInvokerMetaData(InvokerProxyBindingMetaData metadata)
/*     */   {
/* 150 */     this.invokerMetaData = metadata;
/*     */   }
/*     */ 
/*     */   public void setInvokerBinding(String binding)
/*     */   {
/* 155 */     this.jndiBinding = binding;
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/* 160 */     this.jmxName = this.container.getJmxName();
/* 161 */     this.jmxNameHash = this.jmxName.hashCode();
/* 162 */     this.jmxNameHashInteger = new Integer(this.jmxNameHash);
/*     */ 
/* 165 */     BeanMetaData bmd = this.container.getBeanMetaData();
/* 166 */     boolean isSession = !(bmd instanceof EntityMetaData);
/* 167 */     boolean isStatelessSession = false;
/* 168 */     if (isSession)
/*     */     {
/* 170 */       SessionMetaData smd = (SessionMetaData)bmd;
/* 171 */       if (bmd.getRemote() == null)
/*     */       {
/* 173 */         this.isServiceEndpointOnly = true;
/*     */ 
/* 175 */         return;
/*     */       }
/* 177 */       isStatelessSession = smd.isStateless();
/*     */     }
/* 179 */     Class pkClass = null;
/* 180 */     if (!isSession)
/*     */     {
/* 182 */       EntityMetaData metaData = (EntityMetaData)bmd;
/* 183 */       String pkClassName = metaData.getPrimaryKeyClass();
/*     */       try
/*     */       {
/* 186 */         if (pkClassName != null)
/*     */         {
/* 188 */           pkClass = this.container.getClassLoader().loadClass(pkClassName);
/*     */         }
/*     */         else
/*     */         {
/* 192 */           pkClass = this.container.getClassLoader().loadClass(metaData.getEjbClass()).getField(metaData.getPrimKeyField()).getClass();
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (NoSuchFieldException e)
/*     */       {
/* 201 */         log.error("Unable to identify Bean's Primary Key class! Did you specify a primary key class and/or field?  Does that field exist?");
/*     */ 
/* 205 */         throw new RuntimeException("Primary Key Problem");
/*     */       }
/*     */       catch (NullPointerException e)
/*     */       {
/* 209 */         log.error("Unable to identify Bean's Primary Key class! Did you specify a primary key class and/or field?  Does that field exist?");
/*     */ 
/* 213 */         throw new RuntimeException("Primary Key Problem");
/*     */       }
/*     */     }
/*     */ 
/* 217 */     this.ejbMetaData = new EJBMetaDataImpl(((EJBProxyFactoryContainer)this.container).getRemoteClass(), ((EJBProxyFactoryContainer)this.container).getHomeClass(), pkClass, isSession, isStatelessSession, new HomeHandleImpl(this.jndiBinding));
/*     */ 
/* 225 */     log.debug("Proxy Factory for " + this.jndiBinding + " initialized");
/*     */ 
/* 227 */     initInterceptorClasses();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 236 */     if (!this.isServiceEndpointOnly)
/*     */     {
/* 238 */       setupInvokers();
/* 239 */       bindProxy();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setupInvokers()
/*     */     throws Exception
/*     */   {
/* 250 */     ObjectName oname = new ObjectName(this.invokerMetaData.getInvokerMBean());
/* 251 */     Invoker invoker = (Invoker)Registry.lookup(oname);
/* 252 */     if (invoker == null)
/*     */     {
/* 254 */       throw new RuntimeException("invoker is null: " + oname);
/*     */     }
/*     */ 
/* 257 */     this.homeInvoker = (this.beanInvoker = invoker);
/*     */   }
/*     */ 
/*     */   protected void initInterceptorClasses()
/*     */     throws Exception
/*     */   {
/* 266 */     HashMap interceptors = new HashMap();
/*     */ 
/* 268 */     Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
/* 269 */     Element clientInterceptors = MetaData.getOptionalChild(proxyConfig, "client-interceptors", null);
/*     */ 
/* 273 */     if (clientInterceptors != null)
/*     */     {
/* 275 */       String value = MetaData.getElementAttribute(clientInterceptors, "exposeContainer");
/* 276 */       this.includeIClientIface = Boolean.valueOf(value).booleanValue();
/* 277 */       NodeList children = clientInterceptors.getChildNodes();
/* 278 */       for (int i = 0; i < children.getLength(); i++)
/*     */       {
/* 280 */         Node currentChild = children.item(i);
/* 281 */         if (currentChild.getNodeType() != 1)
/*     */           continue;
/* 283 */         Element interceptor = (Element)children.item(i);
/* 284 */         interceptors.put(interceptor.getTagName(), interceptor);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 290 */       log.debug("client interceptors element is null");
/*     */     }
/* 292 */     Element homeInterceptorConf = (Element)interceptors.get("home");
/* 293 */     loadInterceptorClasses(this.homeInterceptorClasses, homeInterceptorConf);
/* 294 */     if (this.homeInterceptorClasses.size() == 0)
/*     */     {
/* 296 */       throw new DeploymentException("There are no home interface interceptors configured");
/*     */     }
/*     */ 
/* 299 */     Element beanInterceptorConf = (Element)interceptors.get("bean");
/* 300 */     loadInterceptorClasses(this.beanInterceptorClasses, beanInterceptorConf);
/* 301 */     if (this.beanInterceptorClasses.size() == 0)
/*     */     {
/* 303 */       throw new DeploymentException("There are no bean interface interceptors configured");
/*     */     }
/*     */ 
/* 306 */     Element listEntityInterceptorConf = (Element)interceptors.get("list-entity");
/* 307 */     loadInterceptorClasses(this.listEntityInterceptorClasses, listEntityInterceptorConf);
/*     */   }
/*     */ 
/*     */   protected void loadInterceptorClasses(ArrayList classes, Element interceptors)
/*     */     throws Exception
/*     */   {
/* 319 */     Iterator interceptorElements = MetaData.getChildrenByTagName(interceptors, "interceptor");
/* 320 */     ClassLoader loader = this.container.getClassLoader();
/* 321 */     while ((interceptorElements != null) && (interceptorElements.hasNext()))
/*     */     {
/* 323 */       Element ielement = (Element)interceptorElements.next();
/* 324 */       String className = null;
/* 325 */       className = MetaData.getElementContent(ielement);
/*     */ 
/* 328 */       String byValueAttr = MetaData.getElementAttribute(ielement, "call-by-value");
/* 329 */       if (byValueAttr != null)
/*     */       {
/* 331 */         if (this.container.isCallByValue() == new Boolean(byValueAttr).booleanValue())
/*     */         {
/* 333 */           Class clazz = loader.loadClass(className);
/* 334 */           classes.add(clazz);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 339 */         Class clazz = loader.loadClass(className);
/* 340 */         classes.add(clazz);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void loadInterceptorChain(ArrayList chain, ClientContainer client)
/*     */     throws Exception
/*     */   {
/* 354 */     Interceptor last = null;
/* 355 */     for (int i = 0; i < chain.size(); i++)
/*     */     {
/* 357 */       Class clazz = (Class)chain.get(i);
/* 358 */       Interceptor interceptor = (Interceptor)clazz.newInstance();
/* 359 */       if (last == null)
/*     */       {
/* 361 */         last = interceptor;
/* 362 */         client.setNext(interceptor);
/*     */       }
/*     */       else
/*     */       {
/* 366 */         last.setNext(interceptor);
/* 367 */         last = interceptor;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bindProxy()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 384 */       InvocationContext context = new InvocationContext();
/*     */ 
/* 386 */       context.setObjectName(this.jmxNameHashInteger);
/* 387 */       context.setValue(InvocationKey.JNDI_NAME, this.jndiBinding);
/*     */ 
/* 389 */       context.setInvoker(this.homeInvoker);
/* 390 */       context.setValue(InvocationKey.EJB_METADATA, this.ejbMetaData);
/* 391 */       context.setInvokerProxyBinding(this.invokerMetaData.getName());
/*     */ 
/* 393 */       ClientContainer client = null;
/* 394 */       EJBProxyFactoryContainer pfc = (EJBProxyFactoryContainer)this.container;
/* 395 */       Class[] ifaces = { pfc.getHomeClass(), Class.forName("javax.ejb.Handle") };
/* 396 */       if (this.includeIClientIface)
/*     */       {
/* 398 */         ifaces = new Class[] { IClientContainer.class, pfc.getHomeClass(), Class.forName("javax.ejb.Handle") };
/*     */ 
/* 400 */         client = new ClientContainerEx(context);
/*     */       }
/*     */       else
/*     */       {
/* 404 */         client = new ClientContainer(context);
/*     */       }
/* 406 */       loadInterceptorChain(this.homeInterceptorClasses, client);
/*     */ 
/* 409 */       this.home = ((EJBHome)Proxy.newProxyInstance(pfc.getHomeClass().getClassLoader(), ifaces, client));
/*     */ 
/* 419 */       if (this.ejbMetaData.isStatelessSession() == true)
/*     */       {
/* 422 */         context = new InvocationContext();
/*     */ 
/* 424 */         context.setObjectName(this.jmxNameHashInteger);
/* 425 */         context.setValue(InvocationKey.JNDI_NAME, this.jndiBinding);
/*     */ 
/* 427 */         context.setInvoker(this.beanInvoker);
/* 428 */         context.setInvokerProxyBinding(this.invokerMetaData.getName());
/* 429 */         context.setValue(InvocationKey.EJB_HOME, this.home);
/*     */ 
/* 431 */         Class[] ssifaces = { pfc.getRemoteClass() };
/* 432 */         if (this.includeIClientIface)
/*     */         {
/* 434 */           ssifaces = new Class[] { IClientContainer.class, pfc.getRemoteClass() };
/* 435 */           client = new ClientContainerEx(context);
/*     */         }
/*     */         else
/*     */         {
/* 439 */           client = new ClientContainer(context);
/*     */         }
/* 441 */         loadInterceptorChain(this.beanInterceptorClasses, client);
/*     */ 
/* 443 */         this.statelessObject = ((EJBObject)Proxy.newProxyInstance(pfc.getRemoteClass().getClassLoader(), ssifaces, client));
/*     */       }
/*     */       else
/*     */       {
/* 456 */         Class[] intfs = { pfc.getRemoteClass() };
/* 457 */         if (this.includeIClientIface)
/*     */         {
/* 459 */           intfs = new Class[] { IClientContainer.class, pfc.getRemoteClass() };
/*     */         }
/* 461 */         Class proxyClass = Proxy.getProxyClass(pfc.getRemoteClass().getClassLoader(), intfs);
/* 462 */         Class[] constructorParams = { InvocationHandler.class };
/* 463 */         this.proxyClassConstructor = proxyClass.getConstructor(constructorParams);
/*     */       }
/*     */ 
/* 468 */       rebindHomeProxy();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 472 */       throw new ServerException("Could not bind home", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void rebindHomeProxy()
/*     */     throws NamingException
/*     */   {
/* 479 */     log.debug("(re-)Binding Home " + this.jndiBinding);
/* 480 */     Util.rebind(new InitialContext(), this.jndiBinding, getEJBHome());
/*     */ 
/* 489 */     log.info("Bound EJB Home '" + this.container.getBeanMetaData().getEjbName() + "' to jndi '" + this.jndiBinding + "'");
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 498 */     if (!this.isServiceEndpointOnly)
/*     */     {
/* 500 */       log.info("Unbind EJB Home '" + this.container.getBeanMetaData().getEjbName() + "' from jndi '" + this.jndiBinding + "'");
/*     */       try
/*     */       {
/* 504 */         InitialContext ctx = new InitialContext();
/* 505 */         ctx.unbind(this.jndiBinding);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/* 511 */       this.homeInterceptorClasses.clear();
/* 512 */       this.beanInterceptorClasses.clear();
/* 513 */       this.listEntityInterceptorClasses.clear();
/*     */     }
/*     */ 
/* 516 */     this.container = null;
/* 517 */     this.ejbMetaData = null;
/* 518 */     this.home = null;
/* 519 */     this.statelessObject = null;
/* 520 */     this.beanInvoker = null;
/* 521 */     this.homeInvoker = null;
/* 522 */     this.invokerMetaData = null;
/* 523 */     this.proxyClassConstructor = null;
/*     */   }
/*     */ 
/*     */   public boolean isIdentical(Container container, Invocation mi)
/*     */   {
/* 530 */     throw new UnsupportedOperationException("TODO provide a default implementation");
/*     */   }
/*     */ 
/*     */   public EJBMetaData getEJBMetaData()
/*     */   {
/* 535 */     return this.ejbMetaData;
/*     */   }
/*     */ 
/*     */   public Object getEJBHome()
/*     */   {
/* 540 */     return this.home;
/*     */   }
/*     */ 
/*     */   public Object getStatelessSessionEJBObject()
/*     */   {
/* 549 */     return this.statelessObject;
/*     */   }
/*     */ 
/*     */   public Object getStatefulSessionEJBObject(Object id)
/*     */   {
/* 558 */     InvocationContext context = new InvocationContext();
/*     */ 
/* 560 */     context.setObjectName(this.jmxNameHashInteger);
/* 561 */     context.setCacheId(id);
/* 562 */     context.setValue(InvocationKey.JNDI_NAME, this.jndiBinding);
/* 563 */     context.setInvoker(this.beanInvoker);
/* 564 */     log.debug("seting invoker proxy binding for stateful session: " + this.invokerMetaData.getName());
/* 565 */     context.setInvokerProxyBinding(this.invokerMetaData.getName());
/* 566 */     context.setValue(InvocationKey.EJB_HOME, this.home);
/* 567 */     context.setValue("InvokerID", Invoker.ID);
/*     */     ClientContainer client;
/*     */     ClientContainer client;
/* 570 */     if (this.includeIClientIface)
/*     */     {
/* 572 */       client = new ClientContainerEx(context);
/*     */     }
/*     */     else
/*     */     {
/* 576 */       client = new ClientContainer(context);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 581 */       loadInterceptorChain(this.beanInterceptorClasses, client);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 585 */       throw new NestedRuntimeException("Failed to load interceptor chain", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 590 */       return (EJBObject)this.proxyClassConstructor.newInstance(new Object[] { client });
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 594 */     throw new NestedRuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object getEntityEJBObject(Object id)
/*     */   {
/*     */     Object result;
/*     */     Object result;
/* 605 */     if (id == null)
/*     */     {
/* 607 */       result = null;
/*     */     }
/*     */     else
/*     */     {
/* 612 */       InvocationContext context = new InvocationContext();
/*     */ 
/* 614 */       context.setObjectName(this.jmxNameHashInteger);
/* 615 */       context.setCacheId(id);
/* 616 */       context.setValue(InvocationKey.JNDI_NAME, this.jndiBinding);
/* 617 */       context.setInvoker(this.beanInvoker);
/* 618 */       context.setInvokerProxyBinding(this.invokerMetaData.getName());
/* 619 */       context.setValue(InvocationKey.EJB_HOME, this.home);
/*     */       ClientContainer client;
/*     */       ClientContainer client;
/* 622 */       if (this.includeIClientIface)
/*     */       {
/* 624 */         client = new ClientContainerEx(context);
/*     */       }
/*     */       else
/*     */       {
/* 628 */         client = new ClientContainer(context);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 633 */         loadInterceptorChain(this.beanInterceptorClasses, client);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 637 */         throw new NestedRuntimeException("Failed to load interceptor chain", e);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 642 */         result = this.proxyClassConstructor.newInstance(new Object[] { client });
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 646 */         throw new NestedRuntimeException(ex);
/*     */       }
/*     */     }
/* 649 */     return result;
/*     */   }
/*     */ 
/*     */   public Collection getEntityCollection(Collection ids)
/*     */   {
/* 657 */     ArrayList list = new ArrayList(ids.size());
/* 658 */     Iterator idEnum = ids.iterator();
/*     */ 
/* 660 */     while (idEnum.hasNext())
/*     */     {
/* 662 */       Object nextId = idEnum.next();
/* 663 */       list.add(getEntityEJBObject(nextId));
/*     */     }
/* 665 */     return list;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.ProxyFactory
 * JD-Core Version:    0.6.0
 */