/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.ejb.ListCacheKey;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ 
/*     */ public class ListEntityInterceptor extends EntityInterceptor
/*     */ {
/*     */   private static final long serialVersionUID = -5165912623246270565L;
/*     */   protected static final Method GET_READ_AHEAD_VALUES;
/*     */   private List list;
/*     */   private transient HashMap readAheadValues;
/*     */ 
/*     */   public ListEntityInterceptor()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ListEntityInterceptor(List list)
/*     */   {
/* 108 */     this.list = list;
/*     */   }
/*     */ 
/*     */   public Map getReadAheadValues()
/*     */   {
/* 115 */     if (this.readAheadValues == null)
/*     */     {
/* 117 */       this.readAheadValues = new HashMap();
/*     */     }
/* 119 */     return this.readAheadValues;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 142 */     Method m = invocation.getMethod();
/*     */ 
/* 144 */     if (m.equals(GET_READ_AHEAD_VALUES))
/*     */     {
/* 146 */       return getReadAheadValues();
/*     */     }
/*     */ 
/* 150 */     if (this.readAheadValues != null)
/*     */     {
/* 152 */       Object result = this.readAheadValues.get(m);
/* 153 */       if (this.readAheadValues.containsKey(m))
/*     */       {
/* 155 */         return this.readAheadValues.remove(m);
/*     */       }
/*     */     }
/*     */ 
/* 159 */     Object result = super.invoke(invocation);
/*     */ 
/* 163 */     if ((result instanceof ReadAheadResult))
/*     */     {
/* 165 */       ReadAheadResult raResult = (ReadAheadResult)result;
/* 166 */       Object[] aheadResult = raResult.getAheadResult();
/* 167 */       ListCacheKey key = (ListCacheKey)invocation.getInvocationContext().getCacheId();
/* 168 */       int from = key.getIndex() + 1;
/* 169 */       int to = Math.min(from + aheadResult.length, this.list.size());
/* 170 */       for (int i = from; i < to; i++)
/*     */       {
/* 172 */         ReadAheadBuffer buf = (ReadAheadBuffer)this.list.get(i);
/* 173 */         buf.getReadAheadValues().put(m, aheadResult[(i - from)]);
/*     */       }
/* 175 */       return raResult.getMainResult();
/*     */     }
/*     */ 
/* 179 */     return result;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 197 */     super.writeExternal(out);
/* 198 */     out.writeObject(this.list);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 212 */     super.readExternal(in);
/* 213 */     this.list = ((List)in.readObject());
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  70 */       Class[] empty = new Class[0];
/*     */ 
/*  72 */       GET_READ_AHEAD_VALUES = ReadAheadBuffer.class.getMethod("getReadAheadValues", empty);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  76 */       e.printStackTrace();
/*  77 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.ListEntityInterceptor
 * JD-Core Version:    0.6.0
 */