/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.rmi.CORBA.Stub;
/*     */ import javax.rmi.CORBA.Util;
/*     */ import org.jboss.iiop.rmi.marshal.strategy.StubStrategy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.BAD_OPERATION;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.SystemException;
/*     */ import org.omg.CORBA.portable.ApplicationException;
/*     */ import org.omg.CORBA.portable.RemarshalException;
/*     */ import org.omg.CORBA.portable.ServantObject;
/*     */ import org.omg.CORBA_2_3.portable.InputStream;
/*     */ import org.omg.CORBA_2_3.portable.OutputStream;
/*     */ 
/*     */ public abstract class DynamicIIOPStub extends Stub
/*     */ {
/*     */   static final long serialVersionUID = 3283717238950231589L;
/*  62 */   private Object handle = null;
/*     */ 
/*  66 */   private static final Logger logger = Logger.getLogger(DynamicIIOPStub.class);
/*     */ 
/*     */   private static void trace(String msg)
/*     */   {
/*  71 */     if (logger.isTraceEnabled())
/*  72 */       logger.trace(msg);
/*     */   }
/*     */ 
/*     */   public Object invoke(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/*  95 */     if ((operationName.equals("_get_handle")) && ((this instanceof EJBObject)))
/*     */     {
/*  97 */       if (this.handle == null) {
/*  98 */         this.handle = new HandleImplIIOP(this);
/*     */       }
/* 100 */       return this.handle;
/*     */     }
/* 102 */     if ((operationName.equals("_get_homeHandle")) && ((this instanceof EJBHome)))
/*     */     {
/* 104 */       if (this.handle == null) {
/* 105 */         this.handle = new HomeHandleImplIIOP(this);
/*     */       }
/* 107 */       return this.handle;
/*     */     }
/*     */     Object localObject1;
/* 109 */     if (!_is_local())
/*     */     {
/* 117 */       InputStream in = null;
/*     */       try
/*     */       {
/* 120 */         OutputStream out = (OutputStream)_request(operationName, true);
/*     */ 
/* 122 */         stubStrategy.writeParams(out, params);
/* 123 */         trace("sent request: " + operationName);
/* 124 */         in = (InputStream)_invoke(out);
/* 125 */         if (stubStrategy.isNonVoid()) {
/* 126 */           trace("received reply");
/* 127 */           localObject1 = stubStrategy.readRetval(in);
/*     */           return localObject1;
/*     */         }
/* 133 */         localObject1 = null;
/*     */         return localObject1;
/*     */       }
/*     */       catch (ApplicationException ex)
/*     */       {
/* 136 */         trace("got application exception");
/* 137 */         in = (InputStream)ex.getInputStream();
/* 138 */         throw stubStrategy.readException(ex.getId(), in);
/*     */       }
/*     */       catch (RemarshalException ex) {
/* 141 */         trace("got remarshal exception");
/* 142 */         localObject1 = invoke(operationName, stubStrategy, params);
/*     */         return localObject1;
/*     */       }
/*     */       catch (SystemException ex)
/*     */       {
/* 146 */         if (logger.isTraceEnabled()) {
/* 147 */           logger.trace("CORBA system exception in IIOP stub", ex);
/*     */         }
/* 149 */         throw Util.mapSystemException(ex);
/*     */       }
/*     */       finally {
/* 152 */         _releaseReply(in);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 157 */     ServantObject so = _servant_preinvoke(operationName, Object.class);
/*     */ 
/* 159 */     if (so == null)
/* 160 */       return invoke(operationName, stubStrategy, params);
/*     */     try
/*     */     {
/* 163 */       Object retval = ((LocalIIOPInvoker)so.servant).invoke(operationName, params, null, null, null);
/*     */ 
/* 169 */       localObject1 = stubStrategy.convertLocalRetval(retval);
/*     */       return localObject1;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 175 */       Throwable ex = e;
/* 176 */       if (stubStrategy.isDeclaredException(ex)) {
/* 177 */         throw ex;
/*     */       }
/* 179 */       throw Util.wrapException(ex);
/*     */     }
/*     */     finally {
/* 182 */       _servant_postinvoke(so); } throw localObject3;
/*     */   }
/*     */ 
/*     */   public boolean invokeBoolean(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 195 */     return ((Boolean)invoke(operationName, stubStrategy, params)).booleanValue();
/*     */   }
/*     */ 
/*     */   public byte invokeByte(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 207 */     return ((Number)invoke(operationName, stubStrategy, params)).byteValue();
/*     */   }
/*     */ 
/*     */   public char invokeChar(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 219 */     return ((Character)invoke(operationName, stubStrategy, params)).charValue();
/*     */   }
/*     */ 
/*     */   public short invokeShort(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 231 */     return ((Number)invoke(operationName, stubStrategy, params)).shortValue();
/*     */   }
/*     */ 
/*     */   public int invokeInt(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 243 */     return ((Number)invoke(operationName, stubStrategy, params)).intValue();
/*     */   }
/*     */ 
/*     */   public long invokeLong(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 254 */     return ((Number)invoke(operationName, stubStrategy, params)).longValue();
/*     */   }
/*     */ 
/*     */   public float invokeFloat(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 265 */     return ((Number)invoke(operationName, stubStrategy, params)).floatValue();
/*     */   }
/*     */ 
/*     */   public double invokeDouble(String operationName, StubStrategy stubStrategy, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 277 */     return ((Number)invoke(operationName, stubStrategy, params)).doubleValue();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 284 */     StringBuilder builder = new StringBuilder();
/* 285 */     builder.append("JBossDynStub[").append(getClass().getName()).append(", ");
/*     */     try
/*     */     {
/* 288 */       builder.append(_orb().object_to_string(this));
/*     */     }
/*     */     catch (BAD_OPERATION ignored)
/*     */     {
/* 292 */       builder.append("*DISCONNECTED*");
/*     */     }
/* 294 */     builder.append("]");
/* 295 */     return builder.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.DynamicIIOPStub
 * JD-Core Version:    0.6.0
 */