/*     */ package org.jboss.proxy.compiler;
/*     */ 
/*     */ import java.io.File;
/*     */ import org.apache.bcel.classfile.JavaClass;
/*     */ import org.apache.bcel.generic.ClassGen;
/*     */ import org.apache.bcel.generic.Type;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ProxyCompiler
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(ProxyCompiler.class);
/*     */ 
/*  47 */   public static final String CLASS_DUMP_PATH = System.getProperty(ProxyCompiler.class.getName() + ".dumpPath", null);
/*     */   public static final String IMPL_SUFFIX = "$Proxy";
/*     */   Runtime runtime;
/*     */   Class superclass;
/*     */   Class[] targetTypes;
/*     */   java.lang.reflect.Method[] methods;
/*     */   Class proxyType;
/*     */ 
/*     */   public ProxyCompiler(ClassLoader parent, Class superclass, Class[] targetTypes, java.lang.reflect.Method[] methods)
/*     */     throws Exception
/*     */   {
/*  82 */     this.superclass = superclass;
/*  83 */     this.targetTypes = targetTypes;
/*  84 */     this.methods = methods;
/*     */ 
/*  86 */     this.runtime = new Runtime(parent);
/*  87 */     this.runtime.targetTypes = targetTypes;
/*  88 */     this.runtime.methods = methods;
/*     */ 
/*  90 */     this.runtime.makeProxyType(this);
/*     */   }
/*     */ 
/*     */   public Class getProxyType() {
/*  94 */     return this.proxyType;
/*     */   }
/*     */ 
/*     */   public String getProxyClassName()
/*     */   {
/* 106 */     return this.targetTypes[0].getName() + "$Proxy";
/*     */   }
/*     */ 
/*     */   public byte[] getCode()
/*     */   {
/* 116 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 118 */     String proxyClassName = getProxyClassName();
/* 119 */     String superClassName = this.superclass.getName();
/*     */ 
/* 121 */     int icount = 1;
/* 122 */     for (int i = 0; i < this.targetTypes.length; i++) {
/* 123 */       Class targetType = this.targetTypes[i];
/* 124 */       if (targetType.isInterface()) {
/* 125 */         icount++;
/*     */       }
/*     */     }
/*     */ 
/* 129 */     String[] interfaceNames = new String[icount];
/* 130 */     interfaceNames[0] = Proxies.ProxyTarget.class.getName();
/* 131 */     icount = 1;
/* 132 */     for (int i = 0; i < this.targetTypes.length; i++) {
/* 133 */       Class targetType = this.targetTypes[i];
/* 134 */       if (targetType.isInterface()) {
/* 135 */         interfaceNames[(icount++)] = targetType.getName();
/*     */       }
/* 137 */       else if (!this.superclass.isAssignableFrom(targetType)) {
/* 138 */         throw new RuntimeException("unexpected: " + targetType);
/*     */       }
/*     */     }
/*     */ 
/* 142 */     ClassGen cg = new ClassGen(proxyClassName, superClassName, "<generated>", 17, interfaceNames);
/*     */ 
/* 148 */     ProxyImplementationFactory factory = new ProxyImplementationFactory(superClassName, proxyClassName, cg);
/*     */ 
/* 151 */     cg.addField(factory.createInvocationHandlerField());
/* 152 */     cg.addField(factory.createRuntimeField());
/* 153 */     cg.addMethod(factory.createConstructor());
/*     */ 
/* 157 */     cg.addMethod(factory.createGetInvocationHandler());
/* 158 */     cg.addMethod(factory.createGetTargetTypes());
/*     */ 
/* 160 */     boolean haveToString = false;
/*     */ 
/* 162 */     if (trace) log.trace("Creating proxy methods...");
/*     */ 
/* 165 */     for (int i = 0; i < this.methods.length; i++)
/*     */     {
/* 167 */       java.lang.reflect.Method m = this.methods[i];
/* 168 */       if (trace) log.trace("Reflected method: " + m);
/*     */ 
/* 170 */       String name = m.getName();
/* 171 */       Class rTypeClass = m.getReturnType();
/* 172 */       String rTypeName = rTypeClass.getName();
/* 173 */       Type rType = Utility.getType(rTypeClass);
/* 174 */       Type[] pTypes = Utility.getTypes(m.getParameterTypes());
/* 175 */       String[] exceptionNames = getNames(m.getExceptionTypes());
/*     */ 
/* 177 */       if ((name.equals("toString")) && (pTypes.length == 0)) {
/* 178 */         haveToString = true;
/*     */       }
/*     */ 
/* 181 */       org.apache.bcel.classfile.Method proxyMethod = factory.createProxyMethod(name, i, rType, pTypes, exceptionNames);
/*     */ 
/* 184 */       if (trace) log.trace("Created proxy method: " + proxyMethod);
/*     */ 
/* 186 */       cg.addMethod(proxyMethod);
/*     */     }
/*     */ 
/* 189 */     if (!haveToString) {
/* 190 */       cg.addMethod(factory.createToString());
/*     */     }
/*     */ 
/* 193 */     JavaClass jclass = cg.getJavaClass();
/* 194 */     if (trace) log.trace("Generated Java class: " + jclass);
/*     */ 
/* 197 */     if (CLASS_DUMP_PATH != null) {
/*     */       try {
/* 199 */         String filename = CLASS_DUMP_PATH + File.separator + proxyClassName + ".class";
/* 200 */         log.info("Dumping generated proxy class to " + filename);
/* 201 */         jclass.dump(filename);
/*     */       }
/*     */       catch (Exception e) {
/* 204 */         log.error("Failed to dump class file", e);
/*     */       }
/*     */     }
/*     */ 
/* 208 */     return jclass.getBytes();
/*     */   }
/*     */ 
/*     */   private String[] getNames(Class[] classes)
/*     */   {
/* 216 */     String[] names = new String[classes.length];
/* 217 */     for (int i = 0; i < classes.length; i++) {
/* 218 */       names[i] = classes[i].getName();
/*     */     }
/*     */ 
/* 221 */     return names;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.compiler.ProxyCompiler
 * JD-Core Version:    0.6.0
 */