/*     */ package org.jboss.proxy.compiler;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Member;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Stack;
/*     */ import java.util.Vector;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class ProxyAssembler
/*     */ {
/*  39 */   Vector cv = new Vector();
/*  40 */   Hashtable ct = new Hashtable();
/*  41 */   Hashtable ut = new Hashtable();
/*  42 */   short cn = 1;
/*     */   Vector members;
/*     */   AMember current;
/*     */   ByteArrayOutputStream code;
/*     */   Stack stack;
/*     */   String className;
/*     */   int modifiers;
/*     */   Class superClass;
/*     */   Class[] interfaces;
/*     */   private static final int opc_iconst_0 = 3;
/*     */   private static final int opc_bipush = 16;
/*     */   private static final int opc_sipush = 17;
/*     */   private static final int opc_ldc = 18;
/*     */   private static final int opc_ldc_w = 19;
/*     */   private static final int opc_ldc2_w = 20;
/*     */   private static final int opc_aaload = 50;
/*     */   private static final int opc_aastore = 83;
/*     */   private static final int opc_dup = 89;
/*     */   private static final int opc_getfield = 180;
/*     */   private static final int field_put = 1;
/*     */   private static final int field_static = -2;
/*     */   private static final int opc_invokevirtual = 182;
/*     */   private static final int opc_invokespecial = 183;
/*     */   private static final int opc_invokestatic = 184;
/*     */   private static final int opc_invokeinterface = 185;
/*     */   private static final int opc_new = 187;
/*     */   private static final int opc_newarray = 188;
/*     */   private static final int opc_anewarray = 189;
/*     */   private static final int opc_aload = 25;
/*     */   private static final int opc_aload_0 = 42;
/*     */   private static final int opc_wide = 196;
/*     */   private static final int opc_areturn = 176;
/*     */   private static final int opc_return = 177;
/*     */   private static final int opc_checkcast = 192;
/*     */   private static final int kind_a = 0;
/*     */   private static final int kind_i = -4;
/*     */   private static final int kind_l = -3;
/*     */   private static final int kind_f = -2;
/*     */   private static final int kind_d = -1;
/*     */   private static final int kind_b = 1;
/*     */   private static final int kind_c = 2;
/*     */   private static final int kind_s = 3;
/*     */   private static final int JAVA_MAGIC = -889275714;
/*     */   private static final short JAVA_VERSION = 45;
/*     */   private static final short JAVA_MINOR_VERSION = 3;
/*     */   private static final short CONSTANT_UTF8 = 1;
/*     */   private static final short CONSTANT_UNICODE = 2;
/*     */   private static final short CONSTANT_INTEGER = 3;
/*     */   private static final short CONSTANT_FLOAT = 4;
/*     */   private static final short CONSTANT_LONG = 5;
/*     */   private static final short CONSTANT_DOUBLE = 6;
/*     */   private static final short CONSTANT_CLASS = 7;
/*     */   private static final short CONSTANT_STRING = 8;
/*     */   private static final short CONSTANT_FIELD = 9;
/*     */   private static final short CONSTANT_METHOD = 10;
/*     */   private static final short CONSTANT_INTERFACEMETHOD = 11;
/*     */   private static final short CONSTANT_NAMEANDTYPE = 12;
/*     */ 
/*     */   public short getIndex(Object x)
/*     */   {
/*  57 */     Object n = this.ct.get(x);
/*  58 */     if (n == null) {
/*  59 */       n = new Short(this.cn++);
/*  60 */       this.ct.put(x, n);
/*  61 */       this.cv.addElement(x);
/*     */     }
/*  63 */     return ((Short)n).shortValue();
/*     */   }
/*     */ 
/*     */   public short getUtfIndex(String x) {
/*  67 */     Object n = this.ut.get(x);
/*  68 */     if (n == null) {
/*  69 */       n = new Short(this.cn++);
/*  70 */       this.ut.put(x, n);
/*  71 */       int xlen = 2 + x.length();
/*  72 */       ByteArrayOutputStream bytes = new ByteArrayOutputStream(xlen);
/*  73 */       DataOutputStream ds = new DataOutputStream(bytes);
/*     */       try {
/*  75 */         ds.writeByte(1);
/*  76 */         ds.writeUTF(x);
/*     */       } catch (IOException ee) {
/*  78 */         throw new RuntimeException(ee.toString());
/*     */       }
/*  80 */       this.cv.addElement(bytes.toByteArray());
/*     */     }
/*  82 */     return ((Short)n).shortValue();
/*     */   }
/*     */ 
/*     */   public short getNTIndex(String name, String sig) {
/*  86 */     NameAndType nt = new NameAndType(null);
/*  87 */     nt.name = getUtfIndex(name);
/*  88 */     nt.sig = getUtfIndex(sig);
/*  89 */     return getIndex(nt);
/*     */   }
/*     */ 
/*     */   public short getClassIndex(Class c)
/*     */   {
/*  94 */     short ci = getUtfIndex(c.getName().replace('.', '/'));
/*  95 */     short[] data = { 7, ci };
/*  96 */     return getIndex(data);
/*     */   }
/*     */ 
/*     */   public short getMemberIndex(Object cls, String name, Class[] ptypes) {
/* 100 */     if ((cls instanceof Class)) {
/* 101 */       Class c = (Class)cls;
/*     */       Member m;
/*     */       try
/*     */       {
/*     */         Member m;
/* 104 */         if (ptypes == null) {
/* 105 */           m = c.getField(name);
/*     */         }
/*     */         else
/*     */         {
/*     */           Member m;
/* 106 */           if (name.equals("<init>"))
/* 107 */             m = c.getConstructor(ptypes);
/*     */           else
/* 109 */             m = c.getMethod(name, ptypes);
/*     */         }
/*     */       } catch (NoSuchMethodException ee) {
/* 112 */         throw new IllegalArgumentException(ee + " in " + c);
/*     */       } catch (NoSuchFieldException ee) {
/* 114 */         throw new IllegalArgumentException(ee + " in " + c);
/*     */       }
/* 116 */       return getIndex(m);
/* 117 */     }if ((cls instanceof ProxyAssembler)) {
/* 118 */       ProxyAssembler asm = (ProxyAssembler)cls;
/* 119 */       String sig = getSig(null, ptypes);
/* 120 */       AMember m = asm.findMember(sig, name);
/* 121 */       if (m == null) {
/* 122 */         throw new IllegalArgumentException(sig + " " + name);
/*     */       }
/* 124 */       return getIndex(m);
/*     */     }
/* 126 */     throw new IllegalArgumentException("not a type: " + cls);
/*     */   }
/*     */ 
/*     */   public short getMemberIndex(Object cls, String name) {
/* 130 */     return getMemberIndex(cls, name, null);
/*     */   }
/*     */ 
/*     */   public static String getSig(Class t) {
/* 134 */     if (t == null)
/* 135 */       return "";
/* 136 */     if (t.isPrimitive())
/*     */     {
/* 139 */       if (t == Boolean.TYPE)
/* 140 */         return "Z";
/* 141 */       if (t == Character.TYPE)
/* 142 */         return "C";
/* 143 */       if (t == Byte.TYPE)
/* 144 */         return "B";
/* 145 */       if (t == Short.TYPE)
/* 146 */         return "S";
/* 147 */       if (t == Integer.TYPE)
/* 148 */         return "I";
/* 149 */       if (t == Long.TYPE)
/* 150 */         return "J";
/* 151 */       if (t == Float.TYPE)
/* 152 */         return "F";
/* 153 */       if (t == Double.TYPE)
/* 154 */         return "D";
/* 155 */       if (t == Void.TYPE) {
/* 156 */         return "V";
/*     */       }
/* 158 */       Class a = Array.newInstance(t, 0).getClass();
/* 159 */       return getSig(a).substring(1);
/*     */     }
/* 161 */     if (t.isArray()) {
/* 162 */       return t.getName().replace('.', '/');
/*     */     }
/* 164 */     return "L" + t.getName().replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   public static String getSig(Class rt, Class[] pt)
/*     */   {
/* 169 */     if (pt == null) {
/* 170 */       return getSig(rt);
/*     */     }
/* 172 */     StringBuffer sb = new StringBuffer();
/* 173 */     sb.append("(");
/* 174 */     for (int i = 0; i < pt.length; i++) {
/* 175 */       sb.append(getSig(pt[i]));
/*     */     }
/* 177 */     sb.append(")");
/* 178 */     sb.append(getSig(rt));
/* 179 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   boolean isInterface() {
/* 183 */     return Modifier.isInterface(this.modifiers);
/*     */   }
/*     */ 
/*     */   public ProxyAssembler(String className, int modifiers, Class superClass, Class[] interfaces)
/*     */   {
/* 188 */     if (interfaces == null) interfaces = new Class[0];
/* 189 */     this.className = className;
/* 190 */     this.modifiers = modifiers;
/* 191 */     this.superClass = superClass;
/* 192 */     this.interfaces = interfaces;
/* 193 */     this.cv.addElement(null);
/* 194 */     this.members = new Vector();
/* 195 */     addMember(0, "", null, "");
/*     */   }
/*     */ 
/*     */   public Object getCurrentMember()
/*     */   {
/* 237 */     return this.current;
/*     */   }
/*     */   public void setCurrentMember(Object m) {
/* 240 */     if (m == null) {
/* 241 */       m = this.members.elementAt(0);
/*     */     }
/* 243 */     this.current = ((AMember)m);
/* 244 */     this.code = this.current.code;
/* 245 */     this.stack = this.current.stack;
/*     */   }
/*     */ 
/*     */   AMember findMember(String sig, String name) {
/* 249 */     for (int i = 0; i < this.members.size(); i++) {
/* 250 */       AMember m = (AMember)this.members.elementAt(i);
/* 251 */       if ((m.name.equals(name)) && 
/* 252 */         (!sig.startsWith("(") ? !m.sig.startsWith("(") : m.sig.startsWith(sig)))
/*     */       {
/* 254 */         return m;
/*     */       }
/*     */     }
/*     */ 
/* 258 */     return null;
/*     */   }
/*     */ 
/*     */   void addExceptionAttribute(Class[] classes)
/*     */   {
/*     */     try
/*     */     {
/* 267 */       if ((classes == null) || (classes.length == 0)) {
/* 268 */         return;
/*     */       }
/* 270 */       ByteArrayOutputStream baos = new ByteArrayOutputStream();
/* 271 */       DataOutputStream dos = new DataOutputStream(baos);
/* 272 */       short count = (short)classes.length;
/* 273 */       dos.writeShort(count);
/* 274 */       for (int iter = 0; iter < classes.length; iter++)
/*     */       {
/* 276 */         dos.writeShort(getClassIndex(classes[iter]));
/*     */       }
/* 278 */       dos.flush();
/* 279 */       baos.flush();
/* 280 */       addAttribute("Exception", baos.toByteArray());
/*     */     }
/*     */     catch (IOException cantHappen)
/*     */     {
/* 284 */       cantHappen.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   AMember addMember(int mods, String sig, Class[] exceptionClasses, String name) {
/* 289 */     String qsig = sig.substring(0, 1 + sig.indexOf(')'));
/* 290 */     AMember m = findMember(qsig, name);
/* 291 */     if (m != null) {
/* 292 */       setCurrentMember(m);
/* 293 */       this.current.mods |= mods;
/* 294 */       this.modifiers |= mods & 0x400;
/* 295 */       return m;
/*     */     }
/* 297 */     m = new AMember(null);
/* 298 */     m.asm = this;
/* 299 */     if (isMethodSig(sig)) {
/* 300 */       m.code = new ByteArrayOutputStream();
/* 301 */       m.stack = new Stack();
/*     */     }
/* 303 */     m.sig = sig;
/* 304 */     m.name = name;
/* 305 */     m.attr = new Vector();
/* 306 */     m.index = this.members.size();
/* 307 */     m.mods = mods;
/* 308 */     this.members.addElement(m);
/* 309 */     setCurrentMember(m);
/* 310 */     addExceptionAttribute(exceptionClasses);
/* 311 */     return m;
/*     */   }
/*     */ 
/*     */   public Object addMember(int mods, Class rtype, String name, Class[] ptypes, Class[] exceptionClasses) {
/* 315 */     AMember m = addMember(mods, getSig(rtype, ptypes), exceptionClasses, name);
/* 316 */     if ((ptypes != null) && (this.stack.size() == 0))
/*     */     {
/* 318 */       if (!Modifier.isStatic(mods)) {
/* 319 */         declare(this);
/*     */       }
/* 321 */       for (int i = 0; i < ptypes.length; i++) {
/* 322 */         declare(ptypes[i]);
/*     */       }
/*     */     }
/* 325 */     m.type = rtype;
/* 326 */     addExceptionAttribute(exceptionClasses);
/* 327 */     return m;
/*     */   }
/*     */ 
/*     */   public Object addMember(int mods, Class type, Class[] exceptionClasses, String name) {
/* 331 */     return addMember(mods, type, name, null, exceptionClasses);
/*     */   }
/*     */ 
/*     */   public void addAttribute(AMember m, String name, Object data) {
/* 335 */     if (m == null) {
/* 336 */       m = (AMember)this.members.elementAt(0);
/*     */     }
/* 338 */     Attr a = new Attr(null);
/* 339 */     a.name = name; a.data = data;
/* 340 */     m.attr.addElement(a);
/*     */   }
/*     */ 
/*     */   public void addAttribute(String name, Object data) {
/* 344 */     addAttribute(this.current, name, data);
/*     */   }
/*     */ 
/*     */   public int declare(Object t)
/*     */   {
/* 383 */     int n = this.current.sp;
/* 384 */     this.current.sp += 1;
/* 385 */     if ((t == Double.TYPE) || (t == Long.TYPE)) {
/* 386 */       this.current.sp += 1;
/*     */     }
/* 388 */     if (this.current.spmax < this.current.sp) {
/* 389 */       this.current.spmax = this.current.sp;
/*     */     }
/* 391 */     AValue se = new AValue(null);
/* 392 */     se.num = n; se.type = t;
/* 393 */     this.stack.push(se);
/* 394 */     return this.stack.size() - 1;
/*     */   }
/*     */ 
/*     */   public void undeclare(Object t) {
/* 398 */     AValue se = (AValue)this.stack.pop();
/* 399 */     this.current.sp = se.num;
/*     */   }
/*     */ 
/*     */   public void pushConstant(Object x) {
/* 403 */     int op = 19;
/* 404 */     if ((x instanceof Integer)) {
/* 405 */       declare(Integer.TYPE);
/* 406 */       int v = ((Integer)x).intValue();
/* 407 */       if ((v >= -1) && (v <= 5)) {
/* 408 */         this.code.write(3 + v);
/* 409 */         return;
/* 410 */       }if ((v > -128) && (v < 128)) {
/* 411 */         this.code.write(16);
/* 412 */         this.code.write(v);
/* 413 */         return;
/* 414 */       }if ((v > -32768) && (v < 32768)) {
/* 415 */         this.code.write(17);
/* 416 */         codeShort(v);
/* 417 */         return;
/*     */       }
/* 419 */     } else if ((x instanceof Float)) {
/* 420 */       declare(Float.TYPE);
/* 421 */     } else if ((x instanceof String)) {
/* 422 */       declare(String.class);
/* 423 */     } else if ((x instanceof Long)) {
/* 424 */       declare(Long.TYPE);
/* 425 */       op = 20;
/* 426 */     } else if ((x instanceof Double)) {
/* 427 */       declare(Double.TYPE);
/* 428 */       op = 20;
/*     */     } else {
/* 430 */       throw new RuntimeException("unexpected: " + x);
/*     */     }
/* 432 */     int xi = getIndex(x);
/* 433 */     if ((op == 19) && (xi < 256)) {
/* 434 */       this.code.write(18);
/* 435 */       this.code.write(xi);
/*     */     } else {
/* 437 */       this.code.write(op);
/* 438 */       codeShort(xi);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void pushConstant(int x) {
/* 442 */     pushConstant(new Integer(x));
/*     */   }
/*     */ 
/*     */   public int pushLocal(int loc) {
/* 446 */     if (this.current.locmax < loc) {
/* 447 */       this.current.locmax = loc;
/*     */     }
/* 449 */     AValue se = (AValue)this.stack.elementAt(loc);
/* 450 */     int kind = typeKind(se.type, false);
/* 451 */     if (se.num <= 3)
/* 452 */       this.code.write(42 + kind * 4 + se.num);
/*     */     else {
/* 454 */       codeWide(25 + kind, se.num);
/*     */     }
/* 456 */     return declare(se.type);
/*     */   }
/*     */ 
/*     */   public int dup() {
/* 460 */     this.code.write(89);
/* 461 */     return declare(this.stack.peek());
/*     */   }
/*     */ 
/*     */   public void checkCast(Object t) {
/* 465 */     this.code.write(192);
/* 466 */     codeShort(getIndex(t));
/* 467 */     AValue se = (AValue)this.stack.pop();
/* 468 */     if (((se.type instanceof Class)) && (((Class)se.type).isPrimitive())) {
/* 469 */       undeclare(Object.class);
/* 470 */       declare(t);
/*     */     }
/* 472 */     se.type = t;
/*     */   }
/*     */ 
/*     */   public int pushNewArray(Object etype) {
/* 476 */     int kind = typeKind(etype, true);
/*     */     int tcode;
/*     */     Class t;
/*     */     int tcode;
/*     */     Class t;
/* 479 */     switch (kind) {
/*     */     case 0:
/* 481 */       this.code.write(189);
/* 482 */       codeShort(getIndex(etype));
/* 483 */       return declare([Ljava.lang.Object.class);
/*     */     case -2:
/* 485 */       tcode = 6;
/* 486 */       t = [F.class;
/* 487 */       break;
/*     */     case -1:
/* 489 */       tcode = 7;
/* 490 */       t = [D.class;
/* 491 */       break;
/*     */     case -4:
/* 493 */       tcode = 10;
/* 494 */       t = [I.class;
/* 495 */       break;
/*     */     case -3:
/* 497 */       tcode = 11;
/* 498 */       t = [J.class;
/* 499 */       break;
/*     */     case 1:
/* 501 */       if (etype == Boolean.TYPE) {
/* 502 */         tcode = 4;
/* 503 */         t = [Z.class;
/*     */       } else {
/* 505 */         tcode = 8;
/* 506 */         t = [B.class;
/*     */       }
/* 508 */       break;
/*     */     case 2:
/* 510 */       tcode = 5;
/* 511 */       t = [C.class;
/* 512 */       break;
/*     */     case 3:
/* 514 */       tcode = 9;
/* 515 */       t = [S.class;
/* 516 */       break;
/*     */     default:
/* 518 */       return 0;
/*     */     }
/* 520 */     this.code.write(188);
/* 521 */     this.code.write(tcode);
/* 522 */     return declare(t);
/*     */   }
/*     */ 
/*     */   public void setElement(Object etype) {
/* 526 */     int kind = typeKind(etype, true);
/* 527 */     this.code.write(83 + kind);
/* 528 */     undeclare(etype);
/* 529 */     undeclare(Integer.TYPE);
/* 530 */     undeclare(null);
/*     */   }
/*     */ 
/*     */   public void pushElement(Object etype) {
/* 534 */     int kind = typeKind(etype, true);
/* 535 */     this.code.write(50 + kind);
/* 536 */     undeclare(Integer.TYPE);
/* 537 */     undeclare(null);
/* 538 */     declare(etype);
/*     */   }
/*     */ 
/*     */   public void ret() {
/* 542 */     if (this.current.sig.endsWith("V")) {
/* 543 */       this.code.write(177);
/* 544 */       return;
/*     */     }
/* 546 */     Object t = this.current.type;
/* 547 */     undeclare(t);
/* 548 */     this.code.write(176 + typeKind(t, false));
/* 549 */     this.stack = null;
/*     */   }
/*     */ 
/*     */   private int dofield(Object cls, String name, boolean isPut) {
/* 553 */     int fi = getMemberIndex(cls, name);
/* 554 */     Object x = this.cv.elementAt(fi);
/* 555 */     int op = 180;
/*     */     Object t;
/*     */     int mod;
/*     */     Object t;
/* 558 */     if ((x instanceof Field)) {
/* 559 */       Field f = (Field)x;
/* 560 */       int mod = f.getModifiers();
/* 561 */       t = f.getType();
/*     */     } else {
/* 563 */       AMember m = (AMember)x;
/* 564 */       mod = m.mods;
/* 565 */       t = m.type;
/*     */     }
/* 567 */     if (isPut) {
/* 568 */       op++;
/* 569 */       undeclare(t);
/*     */     }
/* 571 */     if (Modifier.isStatic(mod))
/* 572 */       op -= 2;
/*     */     else {
/* 574 */       undeclare(cls);
/*     */     }
/* 576 */     this.code.write(op);
/* 577 */     codeShort(fi);
/* 578 */     return isPut ? -1 : declare(t);
/*     */   }
/*     */ 
/*     */   public int pushField(Object cls, String name) {
/* 582 */     return dofield(cls, name, false);
/*     */   }
/*     */ 
/*     */   public void setField(Object cls, String name) {
/* 586 */     dofield(cls, name, true);
/*     */   }
/*     */ 
/*     */   public int invoke(Object cls, String name, Class[] ptypes) {
/* 590 */     int mi = getMemberIndex(cls, name, ptypes);
/* 591 */     Object x = this.cv.elementAt(mi);
/*     */ 
/* 594 */     int op = 182;
/*     */     int mod;
/*     */     Object rtype;
/* 595 */     if ((x instanceof Method)) {
/* 596 */       Method m = (Method)x;
/* 597 */       int mod = m.getModifiers();
/* 598 */       Object rtype = m.getReturnType();
/* 599 */       if (m.getDeclaringClass().isInterface())
/* 600 */         op = 185;
/*     */     }
/* 602 */     else if ((x instanceof Constructor)) {
/* 603 */       Constructor m = (Constructor)x;
/* 604 */       int mod = m.getModifiers();
/* 605 */       Object rtype = Void.TYPE;
/* 606 */       op = 183;
/*     */     } else {
/* 608 */       AMember m = (AMember)x;
/* 609 */       mod = m.mods;
/* 610 */       rtype = m.type;
/* 611 */       if (m.asm.isInterface()) {
/* 612 */         op = 185;
/*     */       }
/*     */     }
/* 615 */     if (Modifier.isStatic(mod))
/* 616 */       op = 184;
/*     */     else {
/* 618 */       undeclare(cls);
/*     */     }
/* 620 */     int i = ptypes.length;
/*     */     while (true) { i--; if (i < 0) break;
/* 621 */       undeclare(ptypes[i]);
/*     */     }
/* 623 */     this.code.write(op);
/* 624 */     codeShort(mi);
/* 625 */     return declare(rtype);
/*     */   }
/*     */ 
/*     */   private int typeKind(Object t, boolean subwords) {
/* 629 */     if ((t != null) && ((t instanceof Class)) && (((Class)t).isPrimitive())) {
/* 630 */       if (t == Float.TYPE)
/* 631 */         return -2;
/* 632 */       if (t == Long.TYPE)
/* 633 */         return -3;
/* 634 */       if (t == Double.TYPE)
/* 635 */         return -1;
/* 636 */       if ((t == Integer.TYPE) || (!subwords))
/* 637 */         return -4;
/* 638 */       if (t == Character.TYPE)
/* 639 */         return 2;
/* 640 */       if (t == Short.TYPE) {
/* 641 */         return 3;
/*     */       }
/* 643 */       return 1;
/*     */     }
/*     */ 
/* 646 */     return 0;
/*     */   }
/*     */ 
/*     */   private void codeWide(int op, int n)
/*     */   {
/* 651 */     if (n < 256) {
/* 652 */       this.code.write(op);
/* 653 */       this.code.write(n);
/*     */     } else {
/* 655 */       this.code.write(196);
/* 656 */       this.code.write(op);
/* 657 */       codeShort(n);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void codeShort(int v) {
/* 662 */     this.code.write(v >>> 8);
/* 663 */     this.code.write(v);
/*     */   }
/*     */ 
/*     */   private static boolean isMethodSig(String sig) {
/* 667 */     return sig.indexOf('(') >= 0;
/*     */   }
/*     */ 
/*     */   public byte[] getCode() {
/*     */     try {
/* 672 */       return internalGetCode(); } catch (IOException ee) {
/*     */     }
/* 674 */     throw new RuntimeException(ee.toString());
/*     */   }
/*     */ 
/*     */   public byte[] internalGetCode()
/*     */     throws IOException
/*     */   {
/* 680 */     getIndex(this);
/* 681 */     getIndex(this.superClass);
/* 682 */     for (int i = 0; i < this.interfaces.length; i++) {
/* 683 */       getIndex(this.interfaces[i]);
/*     */     }
/* 685 */     int nfields = 0;
/* 686 */     int nmethods = 0;
/* 687 */     for (int i = 0; i < this.members.size(); i++) {
/* 688 */       AMember m = (AMember)this.members.elementAt(i);
/*     */ 
/* 690 */       if (m.code != null) {
/* 691 */         byte[] codeAttr = getMethodCode(m, m.code);
/* 692 */         if (codeAttr != null) {
/* 693 */           addAttribute(m, "Code", codeAttr);
/*     */         }
/*     */       }
/*     */ 
/* 697 */       for (int j = 0; j < m.attr.size(); j++) {
/* 698 */         Attr a = (Attr)m.attr.elementAt(j);
/* 699 */         getUtfIndex(a.name);
/*     */       }
/*     */ 
/* 702 */       if (m.name.length() == 0) {
/*     */         continue;
/*     */       }
/* 705 */       getUtfIndex(m.name);
/* 706 */       getUtfIndex(m.sig);
/* 707 */       if (isMethodSig(m.sig))
/* 708 */         nmethods++;
/*     */       else {
/* 710 */         nfields++;
/*     */       }
/*     */     }
/*     */ 
/* 714 */     for (int i = 0; i < this.cv.size(); i++) {
/* 715 */       Object x = this.cv.elementAt(i);
/* 716 */       if (x == null)
/*     */         continue;
/* 718 */       if ((x instanceof String)) {
/* 719 */         String s = (String)x;
/* 720 */         short si = getUtfIndex(s);
/* 721 */         short[] data = { 8, si };
/* 722 */         x = data;
/*     */       }
/* 724 */       else if ((x instanceof Class)) {
/* 725 */         Class c = (Class)x;
/* 726 */         short ci = getUtfIndex(c.getName().replace('.', '/'));
/* 727 */         short[] data = { 7, ci };
/* 728 */         x = data;
/* 729 */       } else if ((x instanceof Field)) {
/* 730 */         Field m = (Field)x;
/* 731 */         short ci = getIndex(m.getDeclaringClass());
/* 732 */         short nt = getNTIndex(m.getName(), getSig(m.getType()));
/*     */ 
/* 734 */         short[] data = { 9, ci, nt };
/* 735 */         x = data;
/* 736 */       } else if ((x instanceof Constructor)) {
/* 737 */         Constructor m = (Constructor)x;
/* 738 */         short ci = getIndex(m.getDeclaringClass());
/* 739 */         short nt = getNTIndex("<init>", getSig(Void.TYPE, m.getParameterTypes()));
/*     */ 
/* 742 */         short[] data = { 10, ci, nt };
/* 743 */         x = data;
/* 744 */       } else if ((x instanceof Method)) {
/* 745 */         Method m = (Method)x;
/* 746 */         Class c = m.getDeclaringClass();
/* 747 */         short kind = c.isInterface() ? 11 : 10;
/*     */ 
/* 749 */         short ci = getIndex(c);
/* 750 */         short nt = getNTIndex(m.getName(), getSig(m.getReturnType(), m.getParameterTypes()));
/*     */ 
/* 753 */         short[] data = { kind, ci, nt };
/* 754 */         x = data;
/* 755 */       } else if ((x instanceof ProxyAssembler)) {
/* 756 */         ProxyAssembler asm = (ProxyAssembler)x;
/* 757 */         short ci = getUtfIndex(asm.className.replace('.', '/'));
/* 758 */         short[] data = { 7, ci };
/* 759 */         x = data;
/* 760 */       } else if ((x instanceof AMember)) {
/* 761 */         AMember m = (AMember)x;
/* 762 */         short kind = m.asm.isInterface() ? 11 : !isMethodSig(m.sig) ? 9 : 10;
/*     */ 
/* 765 */         short ci = getIndex(m.asm);
/* 766 */         short nt = getNTIndex(m.name, m.sig);
/* 767 */         short[] data = { kind, ci, nt };
/* 768 */         x = data;
/* 769 */       } else if ((x instanceof NameAndType)) {
/* 770 */         NameAndType nt = (NameAndType)x;
/* 771 */         short[] data = { 12, nt.name, nt.sig };
/* 772 */         x = data;
/*     */       }
/* 774 */       this.cv.setElementAt(x, i);
/*     */     }
/*     */ 
/* 777 */     ByteArrayOutputStream bytes = new ByteArrayOutputStream(400);
/* 778 */     DataOutputStream ds = new DataOutputStream(bytes);
/* 779 */     ds.writeInt(-889275714);
/* 780 */     ds.writeShort(3);
/* 781 */     ds.writeShort(45);
/* 782 */     int cvsize = this.cv.size();
/* 783 */     ds.writeShort(cvsize);
/* 784 */     for (int i = 0; i < this.cv.size(); i++) {
/* 785 */       Object x = this.cv.elementAt(i);
/* 786 */       if (x == null)
/*     */         continue;
/* 788 */       if ((x instanceof short[])) {
/* 789 */         short[] data = (short[])(short[])x;
/* 790 */         ds.writeByte(data[0]);
/* 791 */         for (int j = 1; j < data.length; j++)
/* 792 */           ds.writeShort(data[j]);
/*     */       }
/* 794 */       else if ((x instanceof byte[])) {
/* 795 */         ds.write((byte[])(byte[])x);
/* 796 */       } else if ((x instanceof Integer)) {
/* 797 */         ds.writeByte(3);
/* 798 */         ds.writeInt(((Integer)x).intValue());
/*     */       }
/*     */       else {
/* 801 */         throw new RuntimeException("unexpected");
/*     */       }
/*     */     }
/* 804 */     ds.writeShort(this.modifiers);
/* 805 */     ds.writeShort(getIndex(this));
/* 806 */     ds.writeShort(getIndex(this.superClass));
/* 807 */     ds.writeShort(this.interfaces.length);
/* 808 */     for (int i = 0; i < this.interfaces.length; i++) {
/* 809 */       ds.writeShort(getIndex(this.interfaces[i]));
/*     */     }
/* 811 */     for (int pass = 0; pass <= 1; pass++) {
/* 812 */       boolean methods = pass > 0;
/* 813 */       ds.writeShort(methods ? nmethods : nfields);
/* 814 */       for (int i = 0; i < this.members.size(); i++) {
/* 815 */         AMember m = (AMember)this.members.elementAt(i);
/* 816 */         if ((m.name.length() == 0) || (isMethodSig(m.sig) != methods)) {
/*     */           continue;
/*     */         }
/* 819 */         ds.writeShort(m.mods);
/* 820 */         ds.writeShort(getUtfIndex(m.name));
/* 821 */         ds.writeShort(getUtfIndex(m.sig));
/* 822 */         writeAttrs(ds, m.attr);
/*     */       }
/*     */     }
/* 825 */     AMember m0 = (AMember)this.members.elementAt(0);
/* 826 */     writeAttrs(ds, m0.attr);
/*     */ 
/* 829 */     if (cvsize != this.cv.size()) {
/* 830 */       throw new RuntimeException("cvsize");
/*     */     }
/*     */ 
/* 833 */     return bytes.toByteArray();
/*     */   }
/*     */ 
/*     */   private byte[] getMethodCode(AMember m, ByteArrayOutputStream code) throws IOException {
/* 837 */     if (code.size() == 0) {
/* 838 */       if ((this.current.mods & 0x500) == 0) {
/* 839 */         this.current.mods |= 1024;
/* 840 */         this.modifiers |= 1024;
/*     */       }
/* 842 */       return null;
/*     */     }
/* 844 */     ByteArrayOutputStream bytes = new ByteArrayOutputStream(code.size() + 30);
/*     */ 
/* 846 */     DataOutputStream ds = new DataOutputStream(bytes);
/* 847 */     int slop = 10;
/* 848 */     int max_stack = this.current.locmax + slop;
/* 849 */     int max_locals = this.current.spmax + slop;
/* 850 */     ds.writeShort(max_stack);
/* 851 */     ds.writeShort(max_locals);
/* 852 */     ds.writeInt(code.size());
/* 853 */     code.writeTo(ds);
/* 854 */     ds.writeShort(0);
/*     */ 
/* 856 */     Vector attrs = new Vector();
/* 857 */     int i = m.attr.size();
/*     */     while (true) { i--; if (i < 0) break;
/* 858 */       Attr ma = (Attr)m.attr.elementAt(i);
/* 859 */       if (ma.name.startsWith("Code.")) {
/* 860 */         m.attr.removeElementAt(i);
/* 861 */         ma.name = ma.name.substring("Code.".length());
/* 862 */         attrs.addElement(ma);
/* 863 */         getUtfIndex(ma.name);
/*     */       }
/*     */     }
/* 866 */     writeAttrs(ds, attrs);
/*     */ 
/* 868 */     return bytes.toByteArray();
/*     */   }
/*     */ 
/*     */   private void writeAttrs(DataOutputStream ds, Vector attrs) throws IOException
/*     */   {
/* 873 */     ds.writeShort(attrs.size());
/* 874 */     for (int i = 0; i < attrs.size(); i++) {
/* 875 */       Attr a = (Attr)attrs.elementAt(i);
/* 876 */       ds.writeShort(getUtfIndex(a.name));
/* 877 */       if ((a.data instanceof byte[])) {
/* 878 */         byte[] xa = (byte[])(byte[])a.data;
/* 879 */         ds.writeInt(xa.length);
/* 880 */         ds.write(xa);
/*     */       } else {
/* 882 */         throw new RuntimeException("unexpected");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class NameAndType
/*     */   {
/*     */     short name;
/*     */     short sig;
/*     */ 
/*     */     public boolean equals(Object x)
/*     */     {
/* 225 */       if ((x instanceof NameAndType)) {
/* 226 */         NameAndType that = (NameAndType)x;
/* 227 */         return (that.name == this.name) && (that.sig == this.sig);
/*     */       }
/* 229 */       return false;
/*     */     }
/*     */     public int hashCode() {
/* 232 */       return this.name + this.sig * 1000;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class AValue
/*     */   {
/*     */     int num;
/*     */     Object type;
/*     */   }
/*     */ 
/*     */   private static class Attr
/*     */   {
/*     */     String name;
/*     */     Object data;
/*     */   }
/*     */ 
/*     */   private static class AMember
/*     */   {
/*     */     int mods;
/*     */     int sp;
/*     */     int spmax;
/*     */     int locmax;
/*     */     int index;
/*     */     Class type;
/*     */     String sig;
/*     */     String name;
/*     */     Vector attr;
/*     */     Stack stack;
/*     */     ByteArrayOutputStream code;
/*     */     ProxyAssembler asm;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.compiler.ProxyAssembler
 * JD-Core Version:    0.6.0
 */