/*     */ package org.jboss.proxy.compiler;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Member;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Hashtable;
/*     */ 
/*     */ public final class Proxies
/*     */ {
/*     */   public static ProxyTarget newTarget(ClassLoader parent, InvocationHandler invocationHandler, Class[] targetTypes)
/*     */     throws Exception
/*     */   {
/*  92 */     return Impl.getImpl(targetTypes).newTarget(invocationHandler, parent);
/*     */   }
/*     */ 
/*     */   public static ProxyInvocationHandler newInvocationHandler(Object target, Class targetType)
/*     */   {
/* 138 */     return Impl.getImpl(targetType).newInvocationHandler(target);
/*     */   }
/*     */ 
/*     */   public static ProxyInvocationHandler newInvocationHandler(Object target, Class[] targetTypes)
/*     */   {
/* 144 */     return Impl.getImpl(targetTypes).newInvocationHandler(target);
/*     */   }
/*     */ 
/*     */   public static Object getTarget(InvocationHandler invocationHandler)
/*     */   {
/* 173 */     if ((invocationHandler instanceof ProxyInvocationHandler))
/*     */     {
/* 175 */       Object target = ((ProxyInvocationHandler)invocationHandler).getTarget();
/* 176 */       if (target != null)
/*     */       {
/* 178 */         return target;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 183 */     return null;
/*     */   }
/*     */ 
/*     */   public static InvocationHandler getInvocationHandler(Object target, Class[] targetTypes)
/*     */   {
/* 201 */     if ((target instanceof ProxyTarget))
/*     */     {
/* 203 */       ProxyTarget tproxy = (ProxyTarget)target;
/* 204 */       InvocationHandler invocationHandler = tproxy.getInvocationHandler();
/* 205 */       if ((targetTypes == null) || (Impl.sameTypes(tproxy.getTargetTypes(), targetTypes)))
/*     */       {
/* 208 */         return invocationHandler;
/*     */       }
/*     */     }
/*     */ 
/* 212 */     return newInvocationHandler(target, targetTypes);
/*     */   }
/*     */ 
/*     */   public static InvocationHandler getInvocationHandler(Object target, Class targetType)
/*     */   {
/* 219 */     if (targetType == null)
/*     */     {
/* 221 */       return getInvocationHandler(target, (Class[])null);
/*     */     }
/*     */ 
/* 224 */     return getInvocationHandler(target, new Class[] { targetType });
/*     */   }
/*     */ 
/*     */   public static Method[] getMethods(Class targetType)
/*     */   {
/* 241 */     return Impl.getImpl(targetType).copyMethods();
/*     */   }
/*     */ 
/*     */   public static Method[] getMethods(Class[] targetTypes)
/*     */   {
/* 246 */     return Impl.getImpl(targetTypes).copyMethods();
/*     */   }
/*     */ 
/*     */   public static void forgetProxyForClass(Class clazz)
/*     */   {
/* 251 */     Impl.forgetProxyForClass(clazz);
/*     */   }
/*     */ 
/*     */   static class Impl
/*     */     implements Serializable
/*     */   {
/* 260 */     static Hashtable impls = new Hashtable();
/*     */     Class[] targetTypes;
/*     */     Method[] methods;
/*     */     Impl more;
/* 270 */     Class superclass = Object.class;
/*     */     String proxyString;
/*     */     Constructor proxyConstructor;
/*     */ 
/*     */     Impl(Class[] targetTypes)
/*     */     {
/* 279 */       this.targetTypes = targetTypes;
/*     */ 
/* 281 */       Method[][] methodLists = new Method[targetTypes.length][];
/* 282 */       for (int i = 0; i < targetTypes.length; i++)
/*     */       {
/* 284 */         methodLists[i] = checkTargetType(targetTypes[i]);
/*     */       }
/*     */ 
/* 287 */       checkSuperclass();
/* 288 */       this.methods = combineMethodLists(methodLists);
/*     */     }
/*     */ 
/*     */     static synchronized Impl getImpl(Class targetType)
/*     */     {
/* 293 */       Impl impl = (Impl)impls.get(targetType);
/* 294 */       if (impl == null)
/*     */       {
/* 296 */         impl = new Impl(new Class[] { targetType });
/* 297 */         impls.put(targetType, impl);
/*     */       }
/* 299 */       return impl;
/*     */     }
/*     */ 
/*     */     static synchronized Impl getImpl(Class[] targetTypes)
/*     */     {
/* 304 */       int n = targetTypes.length;
/* 305 */       if (n == 1)
/*     */       {
/* 307 */         return getImpl(targetTypes[0]);
/*     */       }
/*     */ 
/* 311 */       for (int i = 0; i < n; i++)
/*     */       {
/* 313 */         for (Impl impl = (Impl)impls.get(targetTypes[i]); impl != null; impl = impl.more)
/*     */         {
/* 315 */           if (sameTypes(targetTypes, impl.targetTypes)) {
/* 316 */             return impl;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 321 */       targetTypes = copyAndUniquify(targetTypes);
/* 322 */       Impl impl1 = getImpl(new Class[] { targetTypes[0] });
/* 323 */       Impl impl = new Impl(targetTypes);
/* 324 */       impl.more = impl1.more;
/* 325 */       impl1.more = impl;
/* 326 */       return impl;
/*     */     }
/*     */ 
/*     */     static synchronized void forgetProxyForClass(Class clazz)
/*     */     {
/* 343 */       impls.remove(clazz);
/*     */     }
/*     */ 
/*     */     static boolean sameTypes(Class[] tt1, Class[] tt2)
/*     */     {
/* 351 */       if ((tt1.length == 1) && (tt2.length == 1))
/*     */       {
/* 353 */         return tt1[0] == tt2[0];
/*     */       }
/*     */ 
/* 356 */       int totalSeen2 = 0;
/*     */ 
/* 358 */       int i = tt1.length;
/*     */       while (true) { i--; if (i < 0)
/*     */           break;
/* 360 */         Class c = tt1[i];
/* 361 */         int j = i;
/*     */         while (true) { j--; if (j >= 0)
/*     */           {
/* 363 */             if (c != tt1[j])
/*     */               continue;
/* 365 */             break;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 370 */         int seen2 = 0;
/* 371 */         int j = tt2.length;
/*     */         while (true) { j--; if (j < 0)
/*     */             break;
/* 373 */           if (c != tt2[j])
/*     */             continue;
/* 375 */           seen2++;
/*     */         }
/*     */ 
/* 379 */         if (seen2 == 0)
/*     */         {
/* 382 */           return false;
/*     */         }
/* 384 */         totalSeen2 += seen2;
/*     */       }
/*     */ 
/* 387 */       return totalSeen2 == tt2.length;
/*     */     }
/*     */ 
/*     */     static Class[] copyAndUniquify(Class[] targetTypes)
/*     */     {
/* 392 */       int n = targetTypes.length;
/* 393 */       Class[] tt = new Class[n];
/* 394 */       int k = 0;
/*     */ 
/* 396 */       label57: for (int i = 0; i < n; i++)
/*     */       {
/* 398 */         Class c = targetTypes[i];
/* 399 */         int j = i;
/*     */         while (true) { j--; if (j < 0)
/*     */             break;
/* 401 */           if (c != targetTypes[j])
/*     */             continue;
/* 403 */           break label57;
/*     */         }
/*     */ 
/* 406 */         tt[(k++)] = c;
/*     */       }
/* 408 */       if (k < n)
/*     */       {
/* 411 */         Class[] tt0 = new Class[k];
/* 412 */         for (int i = 0; i < k; i++)
/*     */         {
/* 414 */           tt0[i] = tt[i];
/*     */         }
/* 416 */         tt = tt0;
/*     */       }
/* 418 */       return tt;
/*     */     }
/*     */ 
/*     */     Method[] checkTargetType(Class targetType)
/*     */     {
/* 425 */       if (targetType.isArray())
/*     */       {
/* 427 */         throw new IllegalArgumentException("cannot subclass an array type: " + targetType.getName());
/*     */       }
/*     */ 
/* 431 */       if (targetType.isPrimitive())
/*     */       {
/* 433 */         throw new IllegalArgumentException("cannot subclass a primitive type: " + targetType);
/*     */       }
/*     */ 
/* 437 */       int tmod = targetType.getModifiers();
/* 438 */       if (Modifier.isFinal(tmod))
/*     */       {
/* 440 */         throw new IllegalArgumentException("cannot subclass a final type: " + targetType);
/*     */       }
/*     */ 
/* 444 */       if (!Modifier.isPublic(tmod))
/*     */       {
/* 446 */         throw new IllegalArgumentException("cannot subclass a non-public type: " + targetType);
/*     */       }
/*     */ 
/* 451 */       if (!targetType.isInterface())
/*     */       {
/* 453 */         if (!targetType.isAssignableFrom(this.superclass))
/*     */         {
/* 455 */           if (this.superclass.isAssignableFrom(targetType))
/*     */           {
/* 457 */             this.superclass = targetType;
/*     */           }
/*     */           else {
/* 460 */             throw new IllegalArgumentException("inconsistent superclass: " + targetType);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 467 */       Method[] methodList = targetType.getMethods();
/* 468 */       int nm = 0;
/* 469 */       for (int i = 0; i < methodList.length; i++)
/*     */       {
/* 471 */         Method m = methodList[i];
/* 472 */         if (!eligibleForInvocationHandler(m))
/*     */           continue;
/* 474 */         methodList[(nm++)] = m;
/*     */       }
/*     */ 
/* 478 */       while (nm < methodList.length)
/*     */       {
/* 480 */         methodList[(nm++)] = null;
/*     */       }
/*     */ 
/* 483 */       return methodList;
/*     */     }
/*     */ 
/*     */     void checkSuperclass()
/*     */     {
/* 488 */       Constructor[] constructors = this.superclass.getConstructors();
/* 489 */       for (int i = 0; i < constructors.length; i++)
/*     */       {
/* 491 */         Constructor c = constructors[i];
/* 492 */         int mod = c.getModifiers();
/* 493 */         if ((Modifier.isPublic(mod)) && (c.getParameterTypes().length == 0))
/*     */         {
/* 496 */           return;
/*     */         }
/*     */       }
/*     */ 
/* 500 */       throw new IllegalArgumentException("cannot subclass without nullary constructor: " + this.superclass.getName());
/*     */     }
/*     */ 
/*     */     static boolean eligibleForInvocationHandler(Method m)
/*     */     {
/* 511 */       int mod = m.getModifiers();
/*     */ 
/* 513 */       if ((Modifier.isStatic(mod)) || (Modifier.isFinal(mod)))
/*     */       {
/* 516 */         return false;
/*     */       }
/*     */ 
/* 522 */       return Modifier.isAbstract(mod);
/*     */     }
/*     */ 
/*     */     static boolean areEqual(Method m1, Method m2)
/*     */     {
/* 537 */       if (!m1.getName().equals(m2.getName())) {
/* 538 */         return false;
/*     */       }
/*     */ 
/* 541 */       Class[] a1 = m1.getParameterTypes();
/* 542 */       Class[] a2 = m2.getParameterTypes();
/* 543 */       if (a1.length != a2.length)
/* 544 */         return false;
/* 545 */       for (int i = 0; i < a1.length; i++) {
/* 546 */         if (!a1[i].equals(a2[i]))
/* 547 */           return false;
/*     */       }
/* 549 */       return true;
/*     */     }
/*     */ 
/*     */     static Method[] combineMethodLists(Method[][] methodLists)
/*     */     {
/* 558 */       int nm = 0;
/* 559 */       for (int i = 0; i < methodLists.length; i++)
/*     */       {
/* 561 */         nm += methodLists[i].length;
/*     */       }
/* 563 */       Method[] methods = new Method[nm];
/*     */ 
/* 566 */       nm = 0;
/* 567 */       for (int i = 0; i < methodLists.length; i++) {
/* 568 */         for (int j = 0; j < methodLists[i].length; j++) {
/* 569 */           methods[(nm++)] = methodLists[i][j];
/*     */         }
/*     */       }
/* 572 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 574 */         if (methods[i] == null)
/*     */           continue;
/* 576 */         for (int j = i + 1; j < methods.length; j++)
/*     */         {
/* 578 */           if (methods[j] == null)
/*     */             continue;
/* 580 */           if (!areEqual(methods[i], methods[j]))
/*     */             continue;
/* 582 */           methods[j] = null;
/* 583 */           nm--;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 589 */       ArrayList tmp = new ArrayList();
/* 590 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 592 */         if (methods[i] != null)
/* 593 */           tmp.add(methods[i]);
/*     */       }
/* 595 */       Method[] methodsCopy = new Method[tmp.size()];
/* 596 */       tmp.toArray(methodsCopy);
/* 597 */       return methodsCopy;
/*     */     }
/*     */ 
/*     */     Method[] copyMethods()
/*     */     {
/* 602 */       return (Method[])(Method[])this.methods.clone();
/*     */     }
/*     */ 
/*     */     Class[] copyTargetTypes()
/*     */     {
/* 607 */       return (Class[])(Class[])this.targetTypes.clone();
/*     */     }
/*     */ 
/*     */     Proxies.ProxyTarget newTarget(InvocationHandler invocationHandler, ClassLoader parent)
/*     */       throws Exception
/*     */     {
/* 614 */       if (this.proxyConstructor == null)
/*     */       {
/* 617 */         ProxyCompiler pc = new ProxyCompiler(parent, this.superclass, this.targetTypes, this.methods);
/*     */ 
/* 622 */         Class[] type = { InvocationHandler.class };
/* 623 */         this.proxyConstructor = pc.getProxyType().getConstructor(type);
/*     */       }
/*     */ 
/* 626 */       Object[] args = { invocationHandler };
/* 627 */       return (Proxies.ProxyTarget)this.proxyConstructor.newInstance(args);
/*     */     }
/*     */ 
/*     */     Proxies.ProxyInvocationHandler newInvocationHandler(Object target)
/*     */     {
/* 632 */       if (this.proxyString == null)
/*     */       {
/* 634 */         String s = "InvocationHandler@" + this.targetTypes[0].getName();
/* 635 */         for (int i = 1; i < this.targetTypes.length; i++)
/*     */         {
/* 637 */           s = s + "," + this.targetTypes[i].getName();
/*     */         }
/* 639 */         this.proxyString = s;
/*     */       }
/*     */ 
/* 642 */       return new Proxies.ProxyInvocationHandler(target)
/*     */       {
/*     */         public Object getTarget()
/*     */         {
/* 647 */           return this.val$target;
/*     */         }
/*     */ 
/*     */         public Class[] getTargetTypes()
/*     */         {
/* 652 */           return Proxies.Impl.this.copyTargetTypes();
/*     */         }
/*     */ 
/*     */         public String toString()
/*     */         {
/* 657 */           return Proxies.Impl.this.proxyString + "[" + this.val$target + "]";
/*     */         }
/*     */ 
/*     */         public Object invoke(Object dummy, Method method, Object[] values)
/*     */           throws Throwable
/*     */         {
/* 665 */           return Proxies.Impl.this.invoke(this.val$target, method, values);
/*     */         }
/*     */       };
/*     */     }
/*     */ 
/*     */     Object invoke(Object target, Member method, Object[] values)
/*     */       throws Throwable
/*     */     {
/*     */       try
/*     */       {
/* 684 */         Method[] methods = this.methods;
/*     */ 
/* 687 */         int i = methods.length;
/*     */         while (true) { i--; if (i < 0)
/*     */             break;
/* 689 */           if (methods[i] == method)
/*     */           {
/* 691 */             return methods[i].invoke(target, values);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 696 */         if (method == null)
/*     */         {
/* 698 */           if (methods.length == 1)
/*     */           {
/* 700 */             return methods[0].invoke(target, values);
/*     */           }
/* 702 */           throw new IllegalArgumentException("non-unique method");
/*     */         }
/*     */ 
/* 706 */         int i = methods.length;
/*     */         while (true) { i--; if (i < 0)
/*     */             break;
/* 708 */           if (methods[i].equals(method))
/*     */           {
/* 710 */             return methods[i].invoke(target, values);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 717 */         throw e.getTargetException();
/*     */       }
/*     */ 
/* 720 */       throw new IllegalArgumentException("method unexpected " + method);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface ProxyInvocationHandler extends InvocationHandler, Serializable
/*     */   {
/*     */     public abstract Object getTarget();
/*     */   }
/*     */ 
/*     */   public static abstract interface ProxyTarget extends Serializable
/*     */   {
/*     */     public abstract InvocationHandler getInvocationHandler();
/*     */ 
/*     */     public abstract Class[] getTargetTypes();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.compiler.Proxies
 * JD-Core Version:    0.6.0
 */