/*     */ package org.jboss.proxy;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.PayloadKey;
/*     */ 
/*     */ public class ClientContainer
/*     */   implements Externalizable, InvocationHandler
/*     */ {
/*     */   private static final long serialVersionUID = -4061374432170701306L;
/*  54 */   protected static final Object[] EMPTY_ARGS = new Object[0];
/*     */   public InvocationContext context;
/*     */   public Interceptor next;
/*     */ 
/*     */   public ClientContainer()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ClientContainer(InvocationContext context)
/*     */   {
/*  74 */     this.context = context;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method m, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  84 */     if (args == null) {
/*  85 */       args = EMPTY_ARGS;
/*     */     }
/*     */ 
/*  88 */     Invocation invocation = new Invocation();
/*     */ 
/*  91 */     invocation.setInvocationContext(this.context);
/*  92 */     invocation.setId(this.context.getCacheId());
/*  93 */     invocation.setObjectName(this.context.getObjectName());
/*  94 */     invocation.setMethod(m);
/*  95 */     invocation.setArguments(args);
/*  96 */     invocation.setValue(InvocationKey.INVOKER_PROXY_BINDING, this.context.getInvokerProxyBinding(), PayloadKey.AS_IS);
/*     */ 
/* 101 */     Object obj = this.next.invoke(invocation);
/* 102 */     return obj;
/*     */   }
/*     */ 
/*     */   public InvocationContext getInvocationContext()
/*     */   {
/* 107 */     return this.context;
/*     */   }
/*     */ 
/*     */   public ArrayList getInterceptors() {
/* 111 */     ArrayList tmp = new ArrayList();
/* 112 */     Interceptor inext = this.next;
/* 113 */     while (inext != null)
/*     */     {
/* 115 */       tmp.add(inext);
/* 116 */       inext = inext.nextInterceptor;
/*     */     }
/* 118 */     return tmp;
/*     */   }
/*     */ 
/*     */   public void setInterceptors(ArrayList interceptors) {
/* 122 */     if (interceptors.size() == 0)
/* 123 */       return;
/* 124 */     this.next = ((Interceptor)interceptors.get(0));
/* 125 */     Interceptor i = this.next;
/* 126 */     for (int n = 1; n < interceptors.size(); n++)
/*     */     {
/* 128 */       Interceptor inext = (Interceptor)interceptors.get(n);
/* 129 */       i.setNext(inext);
/* 130 */       i = inext;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Interceptor setNext(Interceptor interceptor)
/*     */   {
/* 136 */     this.next = interceptor;
/*     */ 
/* 138 */     return interceptor;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 147 */     out.writeObject(this.next);
/* 148 */     out.writeObject(this.context);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 157 */     this.next = ((Interceptor)in.readObject());
/* 158 */     this.context = ((InvocationContext)in.readObject());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ClientContainer
 * JD-Core Version:    0.6.0
 */