/*     */ package org.jboss.profileservice.spi.repository;
/*     */ 
/*     */ import java.util.NoSuchElementException;
/*     */ import java.util.StringTokenizer;
/*     */ 
/*     */ public class Version
/*     */   implements Comparable
/*     */ {
/*     */   private final int major;
/*     */   private final int minor;
/*     */   private final int micro;
/*     */   private final String qualifier;
/*     */   private static final String SEPARATOR = ".";
/*  66 */   public static final Version emptyVersion = new Version(0, 0, 0);
/*     */ 
/*     */   public Version(int major, int minor, int micro)
/*     */   {
/*  84 */     this(major, minor, micro, null);
/*     */   }
/*     */ 
/*     */   public Version(int major, int minor, int micro, String qualifier)
/*     */   {
/* 106 */     if (qualifier == null)
/*     */     {
/* 108 */       qualifier = "";
/*     */     }
/*     */ 
/* 111 */     this.major = major;
/* 112 */     this.minor = minor;
/* 113 */     this.micro = micro;
/* 114 */     this.qualifier = qualifier;
/* 115 */     validate();
/*     */   }
/*     */ 
/*     */   public Version(String version)
/*     */   {
/* 143 */     int major = 0;
/* 144 */     int minor = 0;
/* 145 */     int micro = 0;
/* 146 */     String qualifier = "";
/*     */     try
/*     */     {
/* 150 */       StringTokenizer st = new StringTokenizer(version, ".", true);
/* 151 */       major = Integer.parseInt(st.nextToken());
/*     */ 
/* 153 */       if (st.hasMoreTokens())
/*     */       {
/* 155 */         st.nextToken();
/* 156 */         minor = Integer.parseInt(st.nextToken());
/*     */ 
/* 158 */         if (st.hasMoreTokens())
/*     */         {
/* 160 */           st.nextToken();
/* 161 */           micro = Integer.parseInt(st.nextToken());
/*     */ 
/* 163 */           if (st.hasMoreTokens())
/*     */           {
/* 165 */             st.nextToken();
/* 166 */             qualifier = st.nextToken();
/*     */ 
/* 168 */             if (st.hasMoreTokens())
/*     */             {
/* 170 */               throw new IllegalArgumentException("invalid format");
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (NoSuchElementException e)
/*     */     {
/* 178 */       throw new IllegalArgumentException("invalid format");
/*     */     }
/*     */ 
/* 181 */     this.major = major;
/* 182 */     this.minor = minor;
/* 183 */     this.micro = micro;
/* 184 */     this.qualifier = qualifier;
/* 185 */     validate();
/*     */   }
/*     */ 
/*     */   private void validate()
/*     */   {
/* 197 */     if (this.major < 0)
/*     */     {
/* 199 */       throw new IllegalArgumentException("negative major");
/*     */     }
/* 201 */     if (this.minor < 0)
/*     */     {
/* 203 */       throw new IllegalArgumentException("negative minor");
/*     */     }
/* 205 */     if (this.micro < 0)
/*     */     {
/* 207 */       throw new IllegalArgumentException("negative micro");
/*     */     }
/* 209 */     int length = this.qualifier.length();
/* 210 */     for (int i = 0; i < length; i++)
/*     */     {
/* 212 */       if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-".indexOf(this.qualifier.charAt(i)) == -1)
/* 213 */         throw new IllegalArgumentException("invalid qualifier");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Version parseVersion(String version)
/*     */   {
/* 236 */     if (version == null)
/*     */     {
/* 238 */       return emptyVersion;
/*     */     }
/*     */ 
/* 241 */     version = version.trim();
/* 242 */     if (version.length() == 0)
/*     */     {
/* 244 */       return emptyVersion;
/*     */     }
/*     */ 
/* 247 */     return new Version(version);
/*     */   }
/*     */ 
/*     */   public int getMajor()
/*     */   {
/* 257 */     return this.major;
/*     */   }
/*     */ 
/*     */   public int getMinor()
/*     */   {
/* 267 */     return this.minor;
/*     */   }
/*     */ 
/*     */   public int getMicro()
/*     */   {
/* 277 */     return this.micro;
/*     */   }
/*     */ 
/*     */   public String getQualifier()
/*     */   {
/* 287 */     return this.qualifier;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 302 */     String base = this.major + "." + this.minor + "." + this.micro;
/* 303 */     if (this.qualifier.length() == 0)
/*     */     {
/* 305 */       return base;
/*     */     }
/*     */ 
/* 309 */     return base + "." + this.qualifier;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 320 */     return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 340 */     if (object == this)
/*     */     {
/* 342 */       return true;
/*     */     }
/*     */ 
/* 345 */     if (!(object instanceof Version))
/*     */     {
/* 347 */       return false;
/*     */     }
/*     */ 
/* 350 */     Version other = (Version)object;
/* 351 */     return (this.major == other.major) && (this.minor == other.minor) && (this.micro == other.micro) && (this.qualifier.equals(other.qualifier));
/*     */   }
/*     */ 
/*     */   public int compareTo(Object object)
/*     */   {
/* 383 */     if (object == this)
/*     */     {
/* 385 */       return 0;
/*     */     }
/*     */ 
/* 388 */     Version other = (Version)object;
/*     */ 
/* 390 */     int result = this.major - other.major;
/* 391 */     if (result != 0)
/*     */     {
/* 393 */       return result;
/*     */     }
/*     */ 
/* 396 */     result = this.minor - other.minor;
/* 397 */     if (result != 0)
/*     */     {
/* 399 */       return result;
/*     */     }
/*     */ 
/* 402 */     result = this.micro - other.micro;
/* 403 */     if (result != 0)
/*     */     {
/* 405 */       return result;
/*     */     }
/*     */ 
/* 408 */     return this.qualifier.compareTo(other.qualifier);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.spi.repository.Version
 * JD-Core Version:    0.6.0
 */