package org.jboss.profileservice.spi;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
import org.jboss.virtual.VirtualFile;

public abstract interface Profile
{
  public abstract ProfileKey getKey();

  public abstract String getVersion();

  public abstract Set<String> getDeploymentNames();

  public abstract Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase paramDeploymentPhase);

  public abstract Set<String> getDeploymentNamesForType(String paramString);

  public abstract VirtualFile getRootFile(ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract void addDeployment(VFSDeployment paramVFSDeployment, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract void updateDeployment(VFSDeployment paramVFSDeployment, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract VFSDeployment removeDeployment(String paramString, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract VFSDeployment getDeployment(String paramString, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception, NoSuchDeploymentException;

  public abstract Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract Collection<VFSDeployment> getDeployments()
    throws Exception;

  public abstract Collection<ModificationInfo> getModifiedDeployments()
    throws Exception;

  public abstract void enableModifiedDeploymentChecks(boolean paramBoolean);

  public abstract Map<String, Object> getConfig();

  public abstract boolean hasDeployment(String paramString, ManagedDeployment.DeploymentPhase paramDeploymentPhase);
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.spi.Profile
 * JD-Core Version:    0.6.0
 */