/*     */ package org.jboss.profileservice.management.builders;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.plugins.DefaultFieldsImpl;
/*     */ import org.jboss.util.xml.DOMWriter;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class DomFields extends DefaultFieldsImpl
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  44 */   private static final Logger log = Logger.getLogger(DomFields.class);
/*     */   private Element element;
/*  49 */   private boolean deleteOnEmptyValue = true;
/*     */ 
/*     */   public DomFields(Element element, String elementName)
/*     */   {
/*  60 */     this(element, elementName, true);
/*     */   }
/*     */ 
/*     */   public DomFields(Element element, String elementName, boolean deleteOnEmptyValue) {
/*  64 */     this.element = element;
/*  65 */     setField("name", elementName);
/*  66 */     this.deleteOnEmptyValue = deleteOnEmptyValue;
/*     */   }
/*     */ 
/*     */   public String getElementName()
/*     */   {
/*  71 */     return (String)super.getField("name");
/*     */   }
/*     */ 
/*     */   public Serializable getField(String name) {
/*  75 */     if ("value".equals(name))
/*     */     {
/*  77 */       String elementName = getElementName();
/*  78 */       NodeList nodes = this.element.getElementsByTagName(elementName);
/*  79 */       if (nodes.getLength() == 0) {
/*  80 */         return null;
/*     */       }
/*     */ 
/*  83 */       Element element = (Element)nodes.item(0);
/*  84 */       return element.getTextContent();
/*     */     }
/*     */ 
/*  87 */     return super.getField(name);
/*     */   }
/*     */ 
/*     */   public void setField(String name, Serializable value)
/*     */   {
/*  98 */     if ("value".equals(name))
/*     */     {
/* 100 */       String string = value.toString();
/* 101 */       String elementName = getElementName();
/* 102 */       NodeList nodes = this.element.getElementsByTagName(elementName);
/* 103 */       Element childElement = null;
/* 104 */       if (nodes.getLength() == 0)
/*     */       {
/* 106 */         if ((string == null) || ((this.deleteOnEmptyValue) && (string.length() == 0)))
/* 107 */           return;
/* 108 */         Document doc = this.element.getOwnerDocument();
/* 109 */         childElement = doc.createElement(elementName);
/* 110 */         this.element.appendChild(childElement);
/*     */       }
/*     */       else
/*     */       {
/* 114 */         childElement = (Element)nodes.item(0);
/* 115 */         if ((string == null) || (string.length() == 0))
/*     */         {
/* 117 */           this.element.removeChild(childElement);
/* 118 */           return;
/*     */         }
/*     */       }
/* 121 */       childElement.setTextContent(string);
/* 122 */       if (log.isTraceEnabled())
/*     */       {
/* 124 */         Document document = this.element.getOwnerDocument();
/* 125 */         StringBuffer tmp = new StringBuffer("After update of ");
/* 126 */         tmp.append(elementName);
/* 127 */         tmp.append('[');
/* 128 */         tmp.append(DOMWriter.printNode(document, false));
/* 129 */         tmp.append(']');
/* 130 */         log.trace(tmp.toString());
/*     */       }
/* 132 */       return;
/*     */     }
/* 134 */     super.setField(name, value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.builders.DomFields
 * JD-Core Version:    0.6.0
 */