/*     */ package org.jboss.net.sockets;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketAddress;
/*     */ import java.net.SocketException;
/*     */ import java.nio.channels.SocketChannel;
/*     */ 
/*     */ public class TimeoutSocket extends Socket
/*     */ {
/*     */   private Socket s;
/*     */ 
/*     */   public TimeoutSocket(Socket s)
/*     */   {
/*  44 */     this.s = s;
/*     */   }
/*     */ 
/*     */   public InetAddress getInetAddress()
/*     */   {
/*  49 */     return this.s.getInetAddress();
/*     */   }
/*     */ 
/*     */   public InetAddress getLocalAddress()
/*     */   {
/*  54 */     return this.s.getLocalAddress();
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/*  59 */     return this.s.getPort();
/*     */   }
/*     */ 
/*     */   public int getLocalPort()
/*     */   {
/*  64 */     return this.s.getLocalPort();
/*     */   }
/*     */ 
/*     */   public SocketAddress getRemoteSocketAddress()
/*     */   {
/*  69 */     return this.s.getRemoteSocketAddress();
/*     */   }
/*     */ 
/*     */   public SocketAddress getLocalSocketAddress()
/*     */   {
/*  74 */     return this.s.getLocalSocketAddress();
/*     */   }
/*     */ 
/*     */   public SocketChannel getChannel()
/*     */   {
/*  79 */     return this.s.getChannel();
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream() throws IOException
/*     */   {
/*  84 */     InputStream is = this.s.getInputStream();
/*  85 */     InterruptableInputStream iis = new InterruptableInputStream(is);
/*  86 */     return iis;
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream() throws IOException
/*     */   {
/*  91 */     return this.s.getOutputStream();
/*     */   }
/*     */ 
/*     */   public void setTcpNoDelay(boolean on) throws SocketException
/*     */   {
/*  96 */     this.s.setTcpNoDelay(on);
/*     */   }
/*     */ 
/*     */   public boolean getTcpNoDelay() throws SocketException
/*     */   {
/* 101 */     return this.s.getTcpNoDelay();
/*     */   }
/*     */ 
/*     */   public void setSoLinger(boolean on, int linger) throws SocketException
/*     */   {
/* 106 */     this.s.setSoLinger(on, linger);
/*     */   }
/*     */ 
/*     */   public int getSoLinger() throws SocketException
/*     */   {
/* 111 */     return this.s.getSoLinger();
/*     */   }
/*     */ 
/*     */   public void sendUrgentData(int data) throws IOException
/*     */   {
/* 116 */     this.s.sendUrgentData(data);
/*     */   }
/*     */ 
/*     */   public void setOOBInline(boolean on) throws SocketException
/*     */   {
/* 121 */     this.s.setOOBInline(on);
/*     */   }
/*     */ 
/*     */   public boolean getOOBInline() throws SocketException
/*     */   {
/* 126 */     return this.s.getOOBInline();
/*     */   }
/*     */ 
/*     */   public synchronized void setSoTimeout(int timeout) throws SocketException
/*     */   {
/* 131 */     this.s.setSoTimeout(1000);
/*     */   }
/*     */ 
/*     */   public synchronized int getSoTimeout() throws SocketException
/*     */   {
/* 136 */     return this.s.getSoTimeout();
/*     */   }
/*     */ 
/*     */   public synchronized void setSendBufferSize(int size) throws SocketException
/*     */   {
/* 141 */     this.s.setSendBufferSize(size);
/*     */   }
/*     */ 
/*     */   public synchronized int getSendBufferSize() throws SocketException
/*     */   {
/* 146 */     return this.s.getSendBufferSize();
/*     */   }
/*     */ 
/*     */   public synchronized void setReceiveBufferSize(int size) throws SocketException
/*     */   {
/* 151 */     this.s.setReceiveBufferSize(size);
/*     */   }
/*     */ 
/*     */   public synchronized int getReceiveBufferSize() throws SocketException
/*     */   {
/* 156 */     return this.s.getReceiveBufferSize();
/*     */   }
/*     */ 
/*     */   public void setKeepAlive(boolean on) throws SocketException
/*     */   {
/* 161 */     this.s.setKeepAlive(on);
/*     */   }
/*     */ 
/*     */   public boolean getKeepAlive() throws SocketException
/*     */   {
/* 166 */     return this.s.getKeepAlive();
/*     */   }
/*     */ 
/*     */   public void setTrafficClass(int tc) throws SocketException
/*     */   {
/* 171 */     this.s.setTrafficClass(tc);
/*     */   }
/*     */ 
/*     */   public int getTrafficClass() throws SocketException
/*     */   {
/* 176 */     return this.s.getTrafficClass();
/*     */   }
/*     */ 
/*     */   public void setReuseAddress(boolean on) throws SocketException
/*     */   {
/* 181 */     this.s.setReuseAddress(on);
/*     */   }
/*     */ 
/*     */   public boolean getReuseAddress() throws SocketException
/*     */   {
/* 186 */     return this.s.getReuseAddress();
/*     */   }
/*     */ 
/*     */   public synchronized void close() throws IOException
/*     */   {
/* 191 */     this.s.close();
/*     */   }
/*     */ 
/*     */   public void shutdownInput() throws IOException
/*     */   {
/* 196 */     this.s.shutdownInput();
/*     */   }
/*     */ 
/*     */   public void shutdownOutput() throws IOException
/*     */   {
/* 201 */     this.s.shutdownOutput();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 206 */     return this.s.toString();
/*     */   }
/*     */ 
/*     */   public boolean isConnected()
/*     */   {
/* 211 */     return this.s.isConnected();
/*     */   }
/*     */ 
/*     */   public boolean isBound()
/*     */   {
/* 216 */     return this.s.isBound();
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */   {
/* 221 */     return this.s.isClosed();
/*     */   }
/*     */ 
/*     */   public boolean isInputShutdown()
/*     */   {
/* 226 */     return this.s.isInputShutdown();
/*     */   }
/*     */ 
/*     */   public boolean isOutputShutdown()
/*     */   {
/* 231 */     return this.s.isOutputShutdown();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.sockets.TimeoutSocket
 * JD-Core Version:    0.6.0
 */