/*     */ package org.jboss.net.sockets;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.DigestOutputStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ 
/*     */ public class MethodHash
/*     */ {
/*  36 */   static Map hashMap = new WeakHashMap();
/*     */ 
/*     */   public static Map getInterfaceHashes(Class intf)
/*     */   {
/*  47 */     Method[] methods = intf.getMethods();
/*  48 */     HashMap map = new HashMap();
/*  49 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  51 */       Method method = methods[i];
/*  52 */       Class[] parameterTypes = method.getParameterTypes();
/*  53 */       String methodDesc = method.getName() + "(";
/*  54 */       for (int j = 0; j < parameterTypes.length; j++)
/*     */       {
/*  56 */         methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */       }
/*  58 */       methodDesc = methodDesc + ")" + getTypeString(method.getReturnType());
/*     */       try
/*     */       {
/*  62 */         long hash = 0L;
/*  63 */         ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/*  64 */         MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/*  65 */         DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/*  66 */         dataoutputstream.writeUTF(methodDesc);
/*  67 */         dataoutputstream.flush();
/*  68 */         byte[] abyte0 = messagedigest.digest();
/*  69 */         for (int j = 0; j < Math.min(8, abyte0.length); j++)
/*  70 */           hash += ((abyte0[j] & 0xFF) << j * 8);
/*  71 */         map.put(method.toString(), new Long(hash));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  75 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/*  79 */     return map;
/*     */   }
/*     */ 
/*     */   static String getTypeString(Class cl)
/*     */   {
/*  84 */     if (cl == Byte.TYPE)
/*     */     {
/*  86 */       return "B";
/*  87 */     }if (cl == Character.TYPE)
/*     */     {
/*  89 */       return "C";
/*  90 */     }if (cl == Double.TYPE)
/*     */     {
/*  92 */       return "D";
/*  93 */     }if (cl == Float.TYPE)
/*     */     {
/*  95 */       return "F";
/*  96 */     }if (cl == Integer.TYPE)
/*     */     {
/*  98 */       return "I";
/*  99 */     }if (cl == Long.TYPE)
/*     */     {
/* 101 */       return "J";
/* 102 */     }if (cl == Short.TYPE)
/*     */     {
/* 104 */       return "S";
/* 105 */     }if (cl == Boolean.TYPE)
/*     */     {
/* 107 */       return "Z";
/* 108 */     }if (cl == Void.TYPE)
/*     */     {
/* 110 */       return "V";
/* 111 */     }if (cl.isArray())
/*     */     {
/* 113 */       return "[" + getTypeString(cl.getComponentType());
/*     */     }
/*     */ 
/* 116 */     return "L" + cl.getName().replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   public static long calculateHash(Method method)
/*     */   {
/* 129 */     Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
/*     */ 
/* 131 */     if (methodHashes == null)
/*     */     {
/* 133 */       methodHashes = getInterfaceHashes(method.getDeclaringClass());
/*     */ 
/* 136 */       WeakHashMap newHashMap = new WeakHashMap();
/* 137 */       newHashMap.putAll(hashMap);
/* 138 */       newHashMap.put(method.getDeclaringClass(), methodHashes);
/* 139 */       hashMap = newHashMap;
/*     */     }
/*     */ 
/* 142 */     return ((Long)methodHashes.get(method.toString())).longValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.sockets.MethodHash
 * JD-Core Version:    0.6.0
 */