/*     */ package org.jboss.net.protocol.http;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.List;
/*     */ import org.apache.commons.httpclient.HttpException;
/*     */ import org.apache.commons.httpclient.HttpURL;
/*     */ import org.apache.webdav.lib.WebdavResource;
/*     */ import org.jboss.net.protocol.URLLister.URLFilter;
/*     */ import org.jboss.net.protocol.URLListerBase;
/*     */ 
/*     */ public class DavURLLister extends URLListerBase
/*     */ {
/*     */   public Collection listMembers(URL baseUrl, URLLister.URLFilter filter)
/*     */     throws IOException
/*     */   {
/*  40 */     return listMembers(baseUrl, filter, false);
/*     */   }
/*     */ 
/*     */   public Collection listMembers(URL baseUrl, URLLister.URLFilter filter, boolean scanNonDottedSubDirs) throws IOException
/*     */   {
/*  45 */     WebdavResource resource = null;
/*     */     try
/*     */     {
/*  48 */       resource = new WebdavResource(baseUrl.toString());
/*  49 */       WebdavResource[] resources = resource.listWebdavResources();
/*  50 */       List urls = new ArrayList(resources.length);
/*  51 */       for (int i = 0; i < resources.length; i++)
/*     */       {
/*  53 */         WebdavResource member = resources[i];
/*  54 */         HttpURL httpURL = member.getHttpURL();
/*  55 */         if (!filter.accept(baseUrl, httpURL.getName()))
/*     */           continue;
/*  57 */         String uri = httpURL.getURI();
/*  58 */         if (member.isCollection())
/*     */         {
/*  60 */           if (!uri.endsWith("/")) {
/*  61 */             uri = uri + "/";
/*     */           }
/*     */ 
/*  64 */           String path = httpURL.getPath();
/*  65 */           if ((scanNonDottedSubDirs) && (getFilePartFromUrl(path).indexOf(".") == -1))
/*     */           {
/*  67 */             URL subUrl = new URL(uri);
/*  68 */             urls.addAll(listMembers(subUrl, filter, scanNonDottedSubDirs));
/*     */           }
/*     */           else
/*     */           {
/*  72 */             urls.add(new URL(uri));
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/*  77 */           urls.add(new URL(uri));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*  82 */       i = urls;
/*     */       return i;
/*     */     }
/*     */     catch (HttpException e)
/*     */     {
/*  85 */       throw new IOException(e.getMessage());
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*  89 */       throw new IllegalStateException(e.getMessage());
/*     */     }
/*     */     finally {
/*  92 */       if (resource != null)
/*     */       {
/*  94 */         resource.close(); } 
/*  94 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   protected static final String getFilePartFromUrl(String name)
/*     */   {
/* 101 */     int length = name.length();
/*     */ 
/* 103 */     if (name.charAt(length - 1) == '/')
/*     */     {
/* 105 */       int start = name.lastIndexOf("/", length - 2);
/* 106 */       return name.substring(start, length - 2);
/*     */     }
/*     */ 
/* 110 */     int start = name.lastIndexOf("/");
/* 111 */     return name.substring(start);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.http.DavURLLister
 * JD-Core Version:    0.6.0
 */